/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.Member;
import com.hazelcast.core.MultiExecutionCallback;
import com.hazelcast.core.PartitionAware;
import com.hazelcast.executor.RunnableAdapter;
import com.hazelcast.executor.client.IsShutdownRequest;
import com.hazelcast.executor.client.LocalTargetCallableRequest;
import com.hazelcast.executor.client.TargetCallableRequest;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.monitor.LocalExecutorStats;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.executor.CompletedFuture;
import com.hazelcast.util.executor.DelegatingFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientExecutorServiceProxy
extends ClientProxy
implements IExecutorService {
    private final String name;
    private final AtomicInteger consecutiveSubmits = new AtomicInteger();
    private volatile long lastSubmitTime = 0L;

    public ClientExecutorServiceProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
        this.name = objectId;
    }

    @Override
    public Future<?> submit(Runnable command) {
        Data key = this.getTaskPartitionKey(command);
        RunnableAdapter callable = this.createRunnableAdapter(command);
        return this.submitToKeyOwnerInternal(callable, key);
    }

    @Override
    public <T> Future<T> submit(Runnable command, T result) {
        Data key = this.getTaskPartitionKey(command);
        RunnableAdapter<T> callable = this.createRunnableAdapter(command);
        return new DelegatingFuture<T>(this.submitToKeyOwnerInternal(callable, key), null, result);
    }

    @Override
    public void execute(Runnable command) {
        this.executeOnKeyOwner(command, this.getTaskPartitionKey(command));
    }

    @Override
    public void executeOnKeyOwner(Runnable command, Object key) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToKeyOwnerInternal(callable, this.toData(key));
    }

    @Override
    public void executeOnMember(Runnable command, Member member) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        MemberImpl m = this.getContext().getClusterService().getMember(member.getUuid());
        if (m == null) {
            throw new HazelcastException("Member is not available!!!");
        }
        this.submitToTargetInternal(callable, m.getAddress());
    }

    @Override
    public void executeOnMembers(Runnable command, Collection<Member> members) {
        for (Member member : members) {
            this.executeOnMember(command, member);
        }
    }

    @Override
    public void executeOnAllMembers(Runnable command) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        Collection<MemberImpl> memberList = this.getContext().getClusterService().getMemberList();
        for (MemberImpl m : memberList) {
            this.submitToTargetInternal(callable, m.getAddress());
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        Data partitionKey = this.getTaskPartitionKey(task);
        return this.submitToKeyOwnerInternal(task, partitionKey);
    }

    @Override
    public <T> Future<T> submitToKeyOwner(Callable<T> task, Object key) {
        return this.submitToKeyOwnerInternal(task, this.toData(key));
    }

    @Override
    public <T> Future<T> submitToMember(Callable<T> task, Member member) {
        MemberImpl m = this.getContext().getClusterService().getMember(member.getUuid());
        if (m != null) {
            return this.submitToTargetInternal(task, m.getAddress());
        }
        throw new HazelcastException("Member is not available!!!");
    }

    @Override
    public <T> Map<Member, Future<T>> submitToMembers(Callable<T> task, Collection<Member> members) {
        HashMap<Member, Future<T>> futureMap = new HashMap<Member, Future<T>>(members.size());
        for (Member member : members) {
            Future<T> f = this.submitToMember(task, member);
            futureMap.put(member, f);
        }
        return futureMap;
    }

    @Override
    public <T> Map<Member, Future<T>> submitToAllMembers(Callable<T> task) {
        Collection<MemberImpl> memberList = this.getContext().getClusterService().getMemberList();
        HashMap<Member, Future<T>> futureMap = new HashMap<Member, Future<T>>(memberList.size());
        for (MemberImpl m : memberList) {
            Future<T> f = this.submitToTargetInternal(task, m.getAddress());
            futureMap.put(m, f);
        }
        return futureMap;
    }

    @Override
    public void submit(Runnable command, ExecutionCallback callback) {
        this.submitToKeyOwner(command, (Object)this.getTaskPartitionKey(command), callback);
    }

    @Override
    public void submitToKeyOwner(Runnable command, Object key, ExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        this.submitToKeyOwnerInternal(callable, this.toData(key), callback);
    }

    @Override
    public void submitToMember(Runnable command, Member member, ExecutionCallback callback) {
        RunnableAdapter callable = this.createRunnableAdapter(command);
        MemberImpl m = this.getContext().getClusterService().getMember(member.getUuid());
        if (m == null) {
            throw new HazelcastException("Member is not available!!!");
        }
        this.submitToTargetInternal(callable, m.getAddress(), callback);
    }

    @Override
    public void submitToMembers(Runnable command, Collection<Member> members, MultiExecutionCallback callback) {
        MultiExecutionCallbackWrapper multiExecutionCallbackWrapper = new MultiExecutionCallbackWrapper(members.size(), callback);
        for (Member member : members) {
            ExecutionCallbackWrapper executionCallback = new ExecutionCallbackWrapper(multiExecutionCallbackWrapper, member);
            this.submitToMember(command, member, executionCallback);
        }
    }

    @Override
    public void submitToAllMembers(Runnable command, MultiExecutionCallback callback) {
        Collection<MemberImpl> memberList = this.getContext().getClusterService().getMemberList();
        MultiExecutionCallbackWrapper multiExecutionCallbackWrapper = new MultiExecutionCallbackWrapper(memberList.size(), callback);
        for (Member member : memberList) {
            ExecutionCallbackWrapper executionCallback = new ExecutionCallbackWrapper(multiExecutionCallbackWrapper, member);
            this.submitToMember(command, member, executionCallback);
        }
    }

    @Override
    public <T> void submit(Callable<T> task, ExecutionCallback<T> callback) {
        this.submitToKeyOwner(task, (Object)this.getTaskPartitionKey(task), callback);
    }

    @Override
    public <T> void submitToKeyOwner(Callable<T> task, Object key, ExecutionCallback<T> callback) {
        this.submitToKeyOwnerInternal(task, this.toData(key), callback);
    }

    @Override
    public <T> void submitToMember(Callable<T> task, Member member, ExecutionCallback<T> callback) {
        MemberImpl m = this.getContext().getClusterService().getMember(member.getUuid());
        if (m == null) {
            throw new HazelcastException("Member is not available!!!");
        }
        this.submitToTargetInternal(task, m.getAddress(), callback);
    }

    @Override
    public <T> void submitToMembers(Callable<T> task, Collection<Member> members, MultiExecutionCallback callback) {
        MultiExecutionCallbackWrapper multiExecutionCallbackWrapper = new MultiExecutionCallbackWrapper(members.size(), callback);
        for (Member member : members) {
            ExecutionCallbackWrapper executionCallback = new ExecutionCallbackWrapper(multiExecutionCallbackWrapper, member);
            this.submitToMember(task, member, executionCallback);
        }
    }

    @Override
    public <T> void submitToAllMembers(Callable<T> task, MultiExecutionCallback callback) {
        Collection<MemberImpl> memberList = this.getContext().getClusterService().getMemberList();
        MultiExecutionCallbackWrapper multiExecutionCallbackWrapper = new MultiExecutionCallbackWrapper(memberList.size(), callback);
        for (Member member : memberList) {
            ExecutionCallbackWrapper executionCallback = new ExecutionCallbackWrapper(multiExecutionCallbackWrapper, member);
            this.submitToMember(task, member, executionCallback);
        }
    }

    @Override
    public LocalExecutorStats getLocalExecutorStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    public void shutdown() {
        this.destroy();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        try {
            IsShutdownRequest request = new IsShutdownRequest(this.name);
            Boolean result = (Boolean)this.invoke(request);
            return result;
        }
        catch (HazelcastInstanceNotActiveException e) {
            return true;
        }
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return false;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        ArrayList<Future<T>> result = new ArrayList<Future<T>>(tasks.size());
        for (Callable<T> callable : tasks) {
            futures.add(this.submit(callable));
        }
        for (Future future : futures) {
            Object value;
            try {
                value = future.get();
            }
            catch (ExecutionException e) {
                value = e;
            }
            result.add(new CompletedFuture(this.getContext().getSerializationService(), value));
        }
        return result;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void onDestroy() {
    }

    private Data getTaskPartitionKey(Object task) {
        if (task instanceof PartitionAware) {
            Object partitionKey = ((PartitionAware)task).getPartitionKey();
            return this.toData(partitionKey);
        }
        return null;
    }

    private <T> RunnableAdapter<T> createRunnableAdapter(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        return new RunnableAdapter(command);
    }

    private <T> Future<T> submitToKeyOwnerInternal(Callable<T> task, Data partitionKey) {
        Future<T> f;
        this.check(task);
        ClientPartitionService partitionService = this.getContext().getPartitionService();
        if (partitionKey == null) {
            final LocalTargetCallableRequest request = new LocalTargetCallableRequest(this.name, task);
            f = this.getContext().getExecutionService().submit(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return ClientExecutorServiceProxy.this.invoke(request);
                }
            });
            f = this.checkSync(f);
        } else {
            int partitionId = partitionService.getPartitionId(partitionKey);
            Address owner = partitionService.getPartitionOwner(partitionId);
            f = this.submitToTargetInternal(task, owner);
        }
        return f;
    }

    private <T> Future<T> submitToTargetInternal(Callable<T> task, final Address address) {
        this.check(task);
        final TargetCallableRequest request = new TargetCallableRequest(this.name, task, address);
        Future f = this.getContext().getExecutionService().submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return ClientExecutorServiceProxy.this.invoke(request, address);
            }
        });
        return this.checkSync(f);
    }

    private <T> void submitToKeyOwnerInternal(Callable<T> task, Data partitionKey, final ExecutionCallback<T> callback) {
        this.check(task);
        ClientPartitionService partitionService = this.getContext().getPartitionService();
        if (partitionKey == null) {
            final LocalTargetCallableRequest request = new LocalTargetCallableRequest(this.name, task);
            this.getContext().getExecutionService().submit(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    try {
                        Object result = ClientExecutorServiceProxy.this.invoke(request);
                        callback.onResponse(result);
                    }
                    catch (Exception e) {
                        callback.onFailure(e);
                    }
                    return null;
                }
            });
        } else {
            int partitionId = partitionService.getPartitionId(partitionKey);
            Address owner = partitionService.getPartitionOwner(partitionId);
            this.submitToTargetInternal(task, owner, callback);
        }
    }

    private <T> void submitToTargetInternal(Callable<T> task, Address address, final ExecutionCallback<T> callback) {
        this.check(task);
        final TargetCallableRequest request = new TargetCallableRequest(this.name, task, address);
        this.getContext().getExecutionService().submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    Object result = ClientExecutorServiceProxy.this.invoke(request);
                    callback.onResponse(result);
                }
                catch (Exception e) {
                    callback.onFailure(e);
                }
                return null;
            }
        });
    }

    private void check(Callable task) {
        if (task == null) {
            throw new NullPointerException();
        }
    }

    private String getRejectionMessage() {
        return "ExecutorService[" + this.name + "] is shutdown! In order to create a new ExecutorService with name '" + this.name + "', you need to destroy current ExecutorService first!";
    }

    private Data toData(Object o) {
        return this.getContext().getSerializationService().toData(o);
    }

    private <T> T invoke(Object request, Address target) {
        try {
            return this.getContext().getInvocationService().invokeOnTarget(request, target);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private <T> T invoke(Object request) {
        try {
            return this.getContext().getInvocationService().invokeOnRandomTarget(request);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private <T> Future<T> checkSync(Future<T> f) {
        boolean sync = false;
        long last = this.lastSubmitTime;
        long now = Clock.currentTimeMillis();
        if (last + 10L < now) {
            this.consecutiveSubmits.set(0);
        } else if (this.consecutiveSubmits.incrementAndGet() % 100 == 0) {
            sync = true;
        }
        this.lastSubmitTime = now;
        if (sync) {
            Object response;
            try {
                response = f.get();
            }
            catch (Exception e) {
                response = e;
            }
            return new CompletedFuture(this.getContext().getSerializationService(), response);
        }
        return f;
    }

    private class MultiExecutionCallbackWrapper
    implements MultiExecutionCallback {
        private final AtomicInteger members;
        private final MultiExecutionCallback multiExecutionCallback;
        private final Map<Member, Object> values;

        private MultiExecutionCallbackWrapper(int memberSize, MultiExecutionCallback multiExecutionCallback) {
            this.multiExecutionCallback = multiExecutionCallback;
            this.members = new AtomicInteger(memberSize);
            this.values = new HashMap<Member, Object>(memberSize);
        }

        @Override
        public void onResponse(Member member, Object value) {
            this.multiExecutionCallback.onResponse(member, value);
            this.values.put(member, value);
            int waitingResponse = this.members.decrementAndGet();
            if (waitingResponse == 0) {
                this.onComplete(this.values);
            }
        }

        @Override
        public void onComplete(Map<Member, Object> values) {
            this.multiExecutionCallback.onComplete(values);
        }
    }

    private class ExecutionCallbackWrapper<T>
    implements ExecutionCallback<T> {
        MultiExecutionCallbackWrapper multiExecutionCallbackWrapper;
        Member member;

        private ExecutionCallbackWrapper(MultiExecutionCallbackWrapper multiExecutionCallback, Member member) {
            this.multiExecutionCallbackWrapper = multiExecutionCallback;
            this.member = member;
        }

        @Override
        public void onResponse(T response) {
            this.multiExecutionCallbackWrapper.onResponse(this.member, response);
        }

        @Override
        public void onFailure(Throwable t) {
        }
    }
}

