/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientEngine;
import com.hazelcast.client.ClientPrincipal;
import com.hazelcast.core.Client;
import com.hazelcast.core.ClientType;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.TcpIpConnection;
import com.hazelcast.spi.EventService;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public final class ClientEndpoint
implements Client {
    private final ClientEngine clientEngine;
    private final Connection conn;
    private String uuid;
    private LoginContext loginContext = null;
    private ClientPrincipal principal;
    private boolean firstConnection = false;
    private final SocketAddress socketAddress;
    private volatile boolean authenticated = false;
    private volatile TransactionContext transactionContext;
    private List<Runnable> destroyActions = Collections.synchronizedList(new LinkedList());

    ClientEndpoint(ClientEngine clientEngine, Connection conn, String uuid) {
        this.clientEngine = clientEngine;
        this.conn = conn;
        this.socketAddress = conn instanceof TcpIpConnection ? ((TcpIpConnection)conn).getSocketChannelWrapper().socket().getRemoteSocketAddress() : null;
        this.uuid = uuid;
    }

    Connection getConnection() {
        return this.conn;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    public boolean live() {
        return this.conn.live();
    }

    void setLoginContext(LoginContext loginContext) {
        this.loginContext = loginContext;
    }

    public Subject getSubject() {
        return this.loginContext != null ? this.loginContext.getSubject() : null;
    }

    public boolean isFirstConnection() {
        return this.firstConnection;
    }

    void authenticated(ClientPrincipal principal, boolean firstConnection) {
        this.principal = principal;
        this.uuid = principal.getUuid();
        this.firstConnection = firstConnection;
        this.authenticated = true;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public ClientPrincipal getPrincipal() {
        return this.principal;
    }

    @Override
    public SocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    @Override
    public ClientType getClientType() {
        switch (this.conn.getType()) {
            case JAVA_CLIENT: {
                return ClientType.JAVA;
            }
            case CSHARP_CLIENT: {
                return ClientType.CSHARP;
            }
            case CPP_CLIENT: {
                return ClientType.CPP;
            }
            case PYTHON_CLIENT: {
                return ClientType.PYTHON;
            }
            case RUBY_CLIENT: {
                return ClientType.RUBY;
            }
            case BINARY_CLIENT: {
                return ClientType.OTHER;
            }
        }
        throw new IllegalArgumentException("Invalid connection type: " + (Object)((Object)this.conn.getType()));
    }

    public TransactionContext getTransactionContext() {
        TransactionContext context = this.transactionContext;
        if (context == null) {
            throw new TransactionException("No transaction context!");
        }
        return context;
    }

    public void setTransactionContext(TransactionContext transactionContext) {
        this.transactionContext = transactionContext;
    }

    public void setListenerRegistration(final String service, final String topic, final String id) {
        this.destroyActions.add(new Runnable(){

            @Override
            public void run() {
                EventService eventService = ClientEndpoint.this.clientEngine.getEventService();
                eventService.deregisterListener(service, topic, id);
            }
        });
    }

    public void setDistributedObjectListener(final String id) {
        this.destroyActions.add(new Runnable(){

            @Override
            public void run() {
                ClientEndpoint.this.clientEngine.getProxyService().removeProxyListener(id);
            }
        });
    }

    void destroy() throws LoginException {
        TransactionContext context;
        for (Runnable destroyAction : this.destroyActions) {
            try {
                destroyAction.run();
            }
            catch (Exception e) {
                this.getLogger().warning("Exception during destroy action", e);
            }
        }
        LoginContext lc = this.loginContext;
        if (lc != null) {
            lc.logout();
        }
        if ((context = this.transactionContext) != null) {
            try {
                context.rollbackTransaction();
            }
            catch (HazelcastInstanceNotActiveException ignored) {
            }
            catch (Exception e) {
                this.getLogger().warning(e);
            }
            this.transactionContext = null;
        }
        this.authenticated = false;
    }

    private ILogger getLogger() {
        return this.clientEngine.getLogger(this.getClass());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClientEndpoint{");
        sb.append("conn=").append(this.conn);
        sb.append(", uuid='").append(this.uuid).append('\'');
        sb.append(", firstConnection=").append(this.firstConnection);
        sb.append(", authenticated=").append(this.authenticated);
        sb.append('}');
        return sb.toString();
    }
}

