/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.monitor.LocalQueueStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.queue.client.AddAllRequest;
import com.hazelcast.queue.client.AddListenerRequest;
import com.hazelcast.queue.client.ClearRequest;
import com.hazelcast.queue.client.CompareAndRemoveRequest;
import com.hazelcast.queue.client.ContainsRequest;
import com.hazelcast.queue.client.DrainRequest;
import com.hazelcast.queue.client.IteratorRequest;
import com.hazelcast.queue.client.OfferRequest;
import com.hazelcast.queue.client.PeekRequest;
import com.hazelcast.queue.client.PollRequest;
import com.hazelcast.queue.client.RemainingCapacityRequest;
import com.hazelcast.queue.client.RemoveRequest;
import com.hazelcast.queue.client.SizeRequest;
import com.hazelcast.queue.proxy.QueueIterator;
import com.hazelcast.spi.impl.PortableCollection;
import com.hazelcast.spi.impl.PortableItemEvent;
import com.hazelcast.util.ExceptionUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;

public final class ClientQueueProxy<E>
extends ClientProxy
implements IQueue<E> {
    private final String name;

    public ClientQueueProxy(String serviceName, String name) {
        super(serviceName, name);
        this.name = name;
    }

    @Override
    public String addItemListener(final ItemListener<E> listener, final boolean includeValue) {
        AddListenerRequest request = new AddListenerRequest(this.name, includeValue);
        EventHandler<PortableItemEvent> eventHandler = new EventHandler<PortableItemEvent>(){

            @Override
            public void handle(PortableItemEvent portableItemEvent) {
                Object item = includeValue ? ClientQueueProxy.this.getContext().getSerializationService().toObject(portableItemEvent.getItem()) : null;
                MemberImpl member = ClientQueueProxy.this.getContext().getClusterService().getMember(portableItemEvent.getUuid());
                ItemEvent<Object> itemEvent = new ItemEvent<Object>(ClientQueueProxy.this.name, portableItemEvent.getEventType(), item, (Member)member);
                if (portableItemEvent.getEventType() == ItemEventType.ADDED) {
                    listener.itemAdded(itemEvent);
                } else {
                    listener.itemRemoved(itemEvent);
                }
            }
        };
        return this.listen(request, this.getPartitionKey(), eventHandler);
    }

    @Override
    public boolean removeItemListener(String registrationId) {
        return this.stopListening(registrationId);
    }

    @Override
    public LocalQueueStats getLocalQueueStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    public boolean add(E e) {
        if (this.offer(e)) {
            return true;
        }
        throw new IllegalStateException("Queue is full!");
    }

    @Override
    public boolean offer(E e) {
        try {
            return this.offer(e, 0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.offer(e, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        Data data = this.getContext().getSerializationService().toData(e);
        OfferRequest request = new OfferRequest(this.name, unit.toMillis(timeout), data);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public E take() throws InterruptedException {
        return this.poll(-1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        PollRequest request = new PollRequest(this.name, unit.toMillis(timeout));
        return (E)this.invoke(request);
    }

    @Override
    public int remainingCapacity() {
        RemainingCapacityRequest request = new RemainingCapacityRequest(this.name);
        Integer result = (Integer)this.invoke(request);
        return result;
    }

    @Override
    public boolean remove(Object o) {
        Data data = this.getContext().getSerializationService().toData(o);
        RemoveRequest request = new RemoveRequest(this.name, data);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public boolean contains(Object o) {
        ArrayList<Data> list = new ArrayList<Data>(1);
        list.add(this.getContext().getSerializationService().toData(o));
        ContainsRequest request = new ContainsRequest(this.name, list);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public int drainTo(Collection<? super E> objects) {
        return this.drainTo(objects, -1);
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        DrainRequest request = new DrainRequest(this.name, maxElements);
        PortableCollection result = (PortableCollection)this.invoke(request);
        Collection<Data> coll = result.getCollection();
        for (Data data : coll) {
            Object e = this.getContext().getSerializationService().toObject(data);
            c.add(e);
        }
        return coll.size();
    }

    @Override
    public E remove() {
        E res = this.poll();
        if (res == null) {
            throw new NoSuchElementException("Queue is empty!");
        }
        return res;
    }

    @Override
    public E poll() {
        try {
            return this.poll(0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public E element() {
        E res = this.peek();
        if (res == null) {
            throw new NoSuchElementException("Queue is empty!");
        }
        return res;
    }

    @Override
    public E peek() {
        PeekRequest request = new PeekRequest(this.name);
        return (E)this.invoke(request);
    }

    @Override
    public int size() {
        SizeRequest request = new SizeRequest(this.name);
        Integer result = (Integer)this.invoke(request);
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<E> iterator() {
        IteratorRequest request = new IteratorRequest(this.name);
        PortableCollection result = (PortableCollection)this.invoke(request);
        Collection<Data> coll = result.getCollection();
        return new QueueIterator(coll.iterator(), this.getContext().getSerializationService(), false);
    }

    @Override
    public Object[] toArray() {
        IteratorRequest request = new IteratorRequest(this.name);
        PortableCollection result = (PortableCollection)this.invoke(request);
        Collection<Data> coll = result.getCollection();
        int i = 0;
        Object[] array = new Object[coll.size()];
        for (Data data : coll) {
            array[i++] = this.getContext().getSerializationService().toObject(data);
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        IteratorRequest request = new IteratorRequest(this.name);
        PortableCollection result = (PortableCollection)this.invoke(request);
        Collection<Data> coll = result.getCollection();
        int size = coll.size();
        if (ts.length < size) {
            ts = (Object[])Array.newInstance(ts.getClass().getComponentType(), size);
        }
        int i = 0;
        for (Data data : coll) {
            ts[i++] = this.getContext().getSerializationService().toObject(data);
        }
        return ts;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        List<Data> list = this.getDataList(c);
        ContainsRequest request = new ContainsRequest(this.name, list);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        AddAllRequest request = new AddAllRequest(this.name, this.getDataList(c));
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        CompareAndRemoveRequest request = new CompareAndRemoveRequest(this.name, this.getDataList(c), false);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        CompareAndRemoveRequest request = new CompareAndRemoveRequest(this.name, this.getDataList(c), true);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public void clear() {
        ClearRequest request = new ClearRequest(this.name);
        this.invoke(request);
    }

    @Override
    protected void onDestroy() {
    }

    private <T> T invoke(Object req) {
        try {
            return this.getContext().getInvocationService().invokeOnKeyOwner(req, this.getPartitionKey());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private List<Data> getDataList(Collection<?> objects) {
        ArrayList<Data> dataList = new ArrayList<Data>(objects.size());
        for (Object o : objects) {
            dataList.add(this.getContext().getSerializationService().toData(o));
        }
        return dataList;
    }
}

