/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.countdownlatch;

import com.hazelcast.concurrent.countdownlatch.AwaitOperation;
import com.hazelcast.concurrent.countdownlatch.CountDownLatchService;
import com.hazelcast.concurrent.countdownlatch.CountDownOperation;
import com.hazelcast.concurrent.countdownlatch.GetCountOperation;
import com.hazelcast.concurrent.countdownlatch.SetCountOperation;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.ExceptionUtil;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class CountDownLatchProxy
extends AbstractDistributedObject<CountDownLatchService>
implements ICountDownLatch {
    private final String name;
    private final int partitionId;

    public CountDownLatchProxy(String name, NodeEngine nodeEngine) {
        super(nodeEngine, null);
        this.name = name;
        this.partitionId = nodeEngine.getPartitionService().getPartitionId(this.getNameAsPartitionAwareData());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        NodeEngine nodeEngine = this.getNodeEngine();
        Invocation inv = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:countDownLatchService", (Operation)new AwaitOperation(this.name, this.getTimeInMillis(timeout, unit)), this.partitionId).build();
        try {
            return (Boolean)nodeEngine.toObject(inv.invoke().get());
        }
        catch (ExecutionException e) {
            throw ExceptionUtil.rethrowAllowInterrupted(e);
        }
    }

    private long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    @Override
    public void countDown() {
        NodeEngine nodeEngine = this.getNodeEngine();
        Invocation inv = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:countDownLatchService", (Operation)new CountDownOperation(this.name), this.partitionId).build();
        try {
            inv.invoke().get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public int getCount() {
        NodeEngine nodeEngine = this.getNodeEngine();
        Invocation inv = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:countDownLatchService", (Operation)new GetCountOperation(this.name), this.partitionId).build();
        try {
            return (Integer)nodeEngine.toObject(inv.invoke().get());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public boolean trySetCount(int count) {
        NodeEngine nodeEngine = this.getNodeEngine();
        Invocation inv = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:countDownLatchService", (Operation)new SetCountOperation(this.name, count), this.partitionId).build();
        try {
            return (Boolean)nodeEngine.toObject(inv.invoke().get());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public String getServiceName() {
        return "hz:impl:countDownLatchService";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ICountDownLatch{");
        sb.append("name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

