/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.config.MapConfig;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapService;
import com.hazelcast.map.PartitionContainer;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.record.Record;
import com.hazelcast.map.record.RecordReplicationInfo;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.util.Clock;
import com.hazelcast.util.scheduler.ScheduledEntry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MapReplicationOperation
extends AbstractOperation {
    private Map<String, Set<RecordReplicationInfo>> data;
    private Map<String, Boolean> mapInitialLoadInfo;

    public MapReplicationOperation() {
    }

    public MapReplicationOperation(PartitionContainer container, int partitionId, int replicaIndex) {
        this.setPartitionId(partitionId).setReplicaIndex(replicaIndex);
        SerializationService ss = container.getMapService().getSerializationService();
        this.data = new HashMap<String, Set<RecordReplicationInfo>>(container.getMaps().size());
        this.mapInitialLoadInfo = new HashMap<String, Boolean>(container.getMaps().size());
        for (Map.Entry entry : container.getMaps().entrySet()) {
            RecordStore recordStore = (RecordStore)entry.getValue();
            MapContainer mapContainer = recordStore.getMapContainer();
            MapConfig mapConfig = mapContainer.getMapConfig();
            if (mapConfig.getTotalBackupCount() < replicaIndex) continue;
            String name = (String)entry.getKey();
            if (mapContainer.getStore() != null) {
                this.mapInitialLoadInfo.put(name, recordStore.isLoaded());
            }
            HashSet<RecordReplicationInfo> recordSet = new HashSet<RecordReplicationInfo>(recordStore.size());
            for (Map.Entry<Data, Record> recordEntry : recordStore.getReadonlyRecordMap().entrySet()) {
                Data key = recordEntry.getKey();
                Record record = recordEntry.getValue();
                RecordReplicationInfo recordReplicationInfo = replicaIndex == 0 ? this.createScheduledRecordState(mapContainer, recordEntry, key) : new RecordReplicationInfo(record.getKey(), ss.toData(record.getValue()), record.getStatistics());
                recordSet.add(recordReplicationInfo);
            }
            this.data.put(name, recordSet);
        }
    }

    private RecordReplicationInfo createScheduledRecordState(MapContainer mapContainer, Map.Entry<Data, Record> recordEntry, Data key) {
        ScheduledEntry idleScheduledEntry = mapContainer.getIdleEvictionScheduler() == null ? null : mapContainer.getIdleEvictionScheduler().cancel(key);
        long idleDelay = idleScheduledEntry == null ? -1L : this.findDelayMillis(idleScheduledEntry);
        ScheduledEntry ttlScheduledEntry = mapContainer.getTtlEvictionScheduler() == null ? null : mapContainer.getTtlEvictionScheduler().cancel(key);
        long ttlDelay = ttlScheduledEntry == null ? -1L : this.findDelayMillis(ttlScheduledEntry);
        ScheduledEntry writeScheduledEntry = mapContainer.getMapStoreWriteScheduler() == null ? null : mapContainer.getMapStoreWriteScheduler().cancel(key);
        long writeDelay = writeScheduledEntry == null ? -1L : this.findDelayMillis(writeScheduledEntry);
        ScheduledEntry deleteScheduledEntry = mapContainer.getMapStoreDeleteScheduler() == null ? null : mapContainer.getMapStoreDeleteScheduler().cancel(key);
        long deleteDelay = deleteScheduledEntry == null ? -1L : this.findDelayMillis(deleteScheduledEntry);
        Record record = recordEntry.getValue();
        SerializationService ss = mapContainer.getMapService().getSerializationService();
        return new RecordReplicationInfo(record.getKey(), ss.toData(record.getValue()), record.getStatistics(), idleDelay, ttlDelay, writeDelay, deleteDelay);
    }

    @Override
    public void run() {
        MapService mapService = (MapService)this.getService();
        if (this.data != null) {
            for (Map.Entry entry : this.data.entrySet()) {
                Set recordReplicationInfos = (Set)entry.getValue();
                String mapName = (String)entry.getKey();
                RecordStore recordStore = mapService.getRecordStore(this.getPartitionId(), mapName);
                for (RecordReplicationInfo recordReplicationInfo : recordReplicationInfos) {
                    Data key = recordReplicationInfo.getKey();
                    Record newRecord = mapService.createRecord(mapName, key, recordReplicationInfo.getValue(), -1L, false);
                    newRecord.setStatistics(recordReplicationInfo.getStatistics());
                    recordStore.putRecord(key, newRecord);
                    if (recordReplicationInfo.getIdleDelayMillis() >= 0L) {
                        mapService.scheduleIdleEviction(mapName, key, recordReplicationInfo.getIdleDelayMillis());
                    }
                    if (recordReplicationInfo.getTtlDelayMillis() >= 0L) {
                        mapService.scheduleTtlEviction(mapName, newRecord, recordReplicationInfo.getTtlDelayMillis());
                    }
                    if (recordReplicationInfo.getMapStoreWriteDelayMillis() >= 0L) {
                        mapService.scheduleMapStoreWrite(mapName, key, newRecord.getValue(), recordReplicationInfo.getMapStoreWriteDelayMillis());
                    }
                    if (recordReplicationInfo.getMapStoreDeleteDelayMillis() < 0L) continue;
                    mapService.scheduleMapStoreDelete(mapName, key, recordReplicationInfo.getMapStoreDeleteDelayMillis());
                }
            }
        }
        if (this.mapInitialLoadInfo != null) {
            for (String string : this.mapInitialLoadInfo.keySet()) {
                RecordStore recordStore = mapService.getRecordStore(this.getPartitionId(), string);
                recordStore.setLoaded(this.mapInitialLoadInfo.get(string));
            }
        }
    }

    private long findDelayMillis(ScheduledEntry entry) {
        return Math.max(0L, entry.getScheduledDelayMillis() - (Clock.currentTimeMillis() - entry.getScheduleTime()));
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        String name;
        int i;
        int size = in.readInt();
        this.data = new HashMap<String, Set<RecordReplicationInfo>>(size);
        for (i = 0; i < size; ++i) {
            name = in.readUTF();
            int mapSize = in.readInt();
            HashSet<RecordReplicationInfo> recordReplicationInfos = new HashSet<RecordReplicationInfo>(mapSize);
            for (int j = 0; j < mapSize; ++j) {
                RecordReplicationInfo recordReplicationInfo = (RecordReplicationInfo)in.readObject();
                recordReplicationInfos.add(recordReplicationInfo);
            }
            this.data.put(name, recordReplicationInfos);
        }
        size = in.readInt();
        this.mapInitialLoadInfo = new HashMap<String, Boolean>(size);
        for (i = 0; i < size; ++i) {
            name = in.readUTF();
            boolean loaded = in.readBoolean();
            this.mapInitialLoadInfo.put(name, loaded);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeInt(this.data.size());
        for (Map.Entry<String, Set<RecordReplicationInfo>> entry : this.data.entrySet()) {
            out.writeUTF(entry.getKey());
            Set<RecordReplicationInfo> recordReplicationInfos = entry.getValue();
            out.writeInt(recordReplicationInfos.size());
            for (RecordReplicationInfo recordReplicationInfo : recordReplicationInfos) {
                out.writeObject(recordReplicationInfo);
            }
        }
        out.writeInt(this.mapInitialLoadInfo.size());
        for (Map.Entry<String, Object> entry : this.mapInitialLoadInfo.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeBoolean((Boolean)entry.getValue());
        }
    }

    public boolean isEmpty() {
        return this.data == null || this.data.isEmpty();
    }
}

