/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management.operation;

import com.hazelcast.config.MapConfig;
import com.hazelcast.management.MapConfigAdapter;
import com.hazelcast.map.MapService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class UpdateMapConfigOperation
extends Operation {
    private String mapName;
    private MapConfig mapConfig;

    public UpdateMapConfigOperation() {
    }

    public UpdateMapConfigOperation(String mapName, MapConfig mapConfig) {
        this.mapName = mapName;
        this.mapConfig = mapConfig;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void run() throws Exception {
        MapService service = (MapService)this.getService();
        MapConfig config = service.getMapContainer(this.mapName).getMapConfig();
        config.setTimeToLiveSeconds(this.mapConfig.getTimeToLiveSeconds());
        config.setMaxIdleSeconds(this.mapConfig.getMaxIdleSeconds());
        config.setEvictionPolicy(this.mapConfig.getEvictionPolicy());
        config.setEvictionPercentage(this.mapConfig.getEvictionPercentage());
        config.setReadBackupData(this.mapConfig.isReadBackupData());
        config.setBackupCount(this.mapConfig.getTotalBackupCount());
        config.setAsyncBackupCount(this.mapConfig.getAsyncBackupCount());
        config.setMaxSizeConfig(this.mapConfig.getMaxSizeConfig());
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return null;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.mapName);
        new MapConfigAdapter(this.mapConfig).writeData(out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.mapName = in.readUTF();
        MapConfigAdapter adapter = new MapConfigAdapter();
        adapter.readData(in);
        this.mapConfig = adapter.getMapConfig();
    }
}

