/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.txn;

import com.hazelcast.multimap.MultiMapWrapper;
import com.hazelcast.multimap.operations.MultiMapBackupAwareOperation;
import com.hazelcast.multimap.txn.TxnCommitBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Notifier;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.WaitNotifyKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TxnCommitOperation
extends MultiMapBackupAwareOperation
implements Notifier {
    List<Operation> opList;
    transient List<Operation> backupOpList;
    long version;
    transient boolean notify = true;

    public TxnCommitOperation() {
    }

    public TxnCommitOperation(String name, Data dataKey, int threadId, long version, List<Operation> opList) {
        super(name, dataKey, threadId);
        this.version = version;
        this.opList = opList;
    }

    @Override
    public void run() throws Exception {
        MultiMapWrapper wrapper = this.getCollectionWrapper();
        if (wrapper == null || wrapper.getVersion() != this.version) {
            this.notify = false;
            return;
        }
        wrapper.incrementAndGetVersion();
        this.backupOpList = new ArrayList<Operation>();
        for (Operation op : this.opList) {
            op.setNodeEngine(this.getNodeEngine()).setServiceName(this.getServiceName()).setPartitionId(this.getPartitionId());
            op.beforeRun();
            op.run();
            op.afterRun();
            if (!Boolean.TRUE.equals(op.getResponse())) continue;
            this.backupOpList.add(op);
        }
        this.getOrCreateContainer().unlock(this.dataKey, this.getCallerUuid(), this.threadId);
    }

    @Override
    public boolean shouldBackup() {
        return this.notify;
    }

    @Override
    public Operation getBackupOperation() {
        return new TxnCommitBackupOperation(this.name, this.dataKey, this.backupOpList, this.getCallerUuid(), this.threadId);
    }

    @Override
    public boolean shouldNotify() {
        return this.notify;
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        return this.getWaitKey();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.version);
        out.writeInt(this.opList.size());
        for (Operation op : this.opList) {
            out.writeObject(op);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.version = in.readLong();
        int size = in.readInt();
        this.opList = new ArrayList<Operation>(size);
        for (int i = 0; i < size; ++i) {
            this.opList.add((Operation)in.readObject());
        }
    }

    @Override
    public int getId() {
        return 28;
    }
}

