/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection;

import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.connection.Connection;
import com.hazelcast.client.connection.DefaultSocketFactory;
import com.hazelcast.client.connection.SocketFactory;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.ObjectDataInputStream;
import com.hazelcast.nio.serialization.ObjectDataOutputStream;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.util.Clock;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

final class ConnectionImpl
implements Connection {
    private static int CONN_ID = 1;
    private static final int BUFFER_SIZE = 16384;
    private final Socket socket;
    private Address endpoint;
    private final ObjectDataOutputStream out;
    private final ObjectDataInputStream in;
    private final int id = ConnectionImpl.newConnId();
    private volatile long lastRead = Clock.currentTimeMillis();

    private static synchronized int newConnId() {
        return CONN_ID++;
    }

    public ConnectionImpl(Address address, SocketOptions options, SerializationService serializationService, boolean ownerConnection) throws IOException {
        InetSocketAddress isa = address.getInetSocketAddress();
        SocketFactory socketFactory = options.getSocketFactory();
        if (socketFactory == null) {
            socketFactory = new DefaultSocketFactory();
        }
        Socket socket = socketFactory.createSocket();
        try {
            int bufferSize;
            socket.setKeepAlive(options.isKeepAlive());
            socket.setTcpNoDelay(options.isTcpNoDelay());
            socket.setReuseAddress(options.isReuseAddress());
            if (options.getLingerSeconds() > 0) {
                socket.setSoLinger(true, options.getLingerSeconds());
            }
            if (options.getTimeout() > 0 && !ownerConnection) {
                socket.setSoTimeout(options.getTimeout());
            }
            if ((bufferSize = options.getBufferSize() * 1024) < 0) {
                bufferSize = 16384;
            }
            socket.setSendBufferSize(bufferSize);
            socket.setReceiveBufferSize(bufferSize);
            socket.connect(isa, 3000);
            this.socket = socket;
            this.out = serializationService.createObjectDataOutputStream(new BufferedOutputStream(socket.getOutputStream(), bufferSize));
            this.in = serializationService.createObjectDataInputStream(new BufferedInputStream(socket.getInputStream(), bufferSize));
        }
        catch (IOException e) {
            socket.close();
            throw e;
        }
    }

    Socket getSocket() {
        return this.socket;
    }

    @Override
    public Address getEndpoint() {
        return this.endpoint;
    }

    void init() throws IOException {
        this.out.write("CB1".getBytes());
        this.out.write("JVM".getBytes());
        this.out.flush();
    }

    @Override
    public boolean write(Data data) throws IOException {
        data.writeData(this.out);
        this.out.flush();
        return true;
    }

    @Override
    public Data read() throws IOException {
        Data data = new Data();
        data.readData(this.in);
        this.lastRead = Clock.currentTimeMillis();
        return data;
    }

    @Override
    public void release() throws IOException {
        this.out.close();
        this.in.close();
        this.socket.close();
    }

    @Override
    public void close() throws IOException {
        this.release();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public long getLastReadTime() {
        return this.lastRead;
    }

    public String toString() {
        return "Connection [" + this.endpoint + " -> " + this.socket.getLocalSocketAddress() + "]";
    }

    @Override
    public void setEndpoint(Address address) {
        this.endpoint = address;
    }
}

