/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn;

import com.hazelcast.client.ClientEngine;
import com.hazelcast.client.InvocationClientRequest;
import com.hazelcast.client.txn.ClientTxnPortableHook;
import com.hazelcast.cluster.ClusterService;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.SerializableCollection;
import com.hazelcast.transaction.impl.RecoverTxnOperation;
import com.hazelcast.transaction.impl.RecoveredTransaction;
import com.hazelcast.transaction.impl.TransactionManagerServiceImpl;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class RecoverAllTransactionsRequest
extends InvocationClientRequest
implements Portable {
    @Override
    public void invoke() {
        ClientEngine clientEngine = this.getClientEngine();
        ClusterService clusterService = clientEngine.getClusterService();
        Collection<MemberImpl> memberList = clusterService.getMemberList();
        TransactionManagerServiceImpl service = (TransactionManagerServiceImpl)this.getService();
        ArrayList<Future> futures = new ArrayList<Future>(memberList.size());
        for (MemberImpl member : memberList) {
            Invocation inv = this.createInvocationBuilder("hz:core:txManagerService", (Operation)new RecoverTxnOperation(), member.getAddress()).build();
            futures.add(inv.invoke());
        }
        HashSet<Data> xids = new HashSet<Data>();
        for (Future future : futures) {
            ILogger logger;
            try {
                SerializableCollection collectionWrapper = (SerializableCollection)future.get(5000L, TimeUnit.MILLISECONDS);
                for (Data data : collectionWrapper) {
                    RecoveredTransaction rt = (RecoveredTransaction)clientEngine.toObject(data);
                    service.addClientRecoveredTransaction(rt);
                    xids.add(clientEngine.toData(rt.getXid()));
                }
            }
            catch (MemberLeftException e) {
                logger = clientEngine.getLogger(RecoverAllTransactionsRequest.class);
                logger.warning("Member left while recovering: " + e);
            }
            catch (Throwable e) {
                if (e instanceof ExecutionException) {
                    Throwable throwable = e = e.getCause() != null ? e.getCause() : e;
                }
                if (e instanceof TargetNotMemberException) {
                    logger = clientEngine.getLogger(RecoverAllTransactionsRequest.class);
                    logger.warning("Member left while recovering: " + e);
                    continue;
                }
                throw ExceptionUtil.rethrow(e);
            }
        }
        clientEngine.sendResponse(this.getEndpoint(), new SerializableCollection(xids));
    }

    @Override
    public String getServiceName() {
        return "hz:core:txManagerService";
    }

    @Override
    public int getFactoryId() {
        return ClientTxnPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
    }
}

