/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn.proxy;

import com.hazelcast.client.txn.TransactionContextProxy;
import com.hazelcast.client.txn.proxy.ClientTxnProxy;
import com.hazelcast.core.TransactionalMap;
import com.hazelcast.map.MapKeySet;
import com.hazelcast.map.MapValueCollection;
import com.hazelcast.map.client.AbstractTxnMapRequest;
import com.hazelcast.map.client.TxnMapRequest;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ClientTxnMapProxy<K, V>
extends ClientTxnProxy
implements TransactionalMap<K, V> {
    public ClientTxnMapProxy(String name, TransactionContextProxy proxy) {
        super(name, proxy);
    }

    @Override
    public boolean containsKey(Object key) {
        int threadId = (int)Thread.currentThread().getId();
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.CONTAINS_KEY, this.toData(key), threadId);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public V get(Object key) {
        int threadId = (int)Thread.currentThread().getId();
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.GET, this.toData(key), threadId);
        return (V)this.invoke(request);
    }

    @Override
    public int size() {
        int threadId = (int)Thread.currentThread().getId();
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.SIZE, threadId);
        Integer result = (Integer)this.invoke(request);
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public V put(K key, V value) {
        int threadId = (int)Thread.currentThread().getId();
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.PUT, this.toData(key), this.toData(value), threadId);
        return (V)this.invoke(request);
    }

    @Override
    public void set(K key, V value) {
        int threadId = (int)Thread.currentThread().getId();
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.SET, this.toData(key), this.toData(value), threadId);
        this.invoke(request);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        int threadId = (int)Thread.currentThread().getId();
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.PUT_IF_ABSENT, this.toData(key), this.toData(value), threadId);
        return (V)this.invoke(request);
    }

    @Override
    public V replace(K key, V value) {
        int threadId = (int)Thread.currentThread().getId();
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.REPLACE, this.toData(key), this.toData(value), threadId);
        return (V)this.invoke(request);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        int threadId = (int)Thread.currentThread().getId();
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.REPLACE_IF_SAME, this.toData(key), this.toData(oldValue), this.toData(newValue), threadId);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public V remove(Object key) {
        int threadId = (int)Thread.currentThread().getId();
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.REMOVE, this.toData(key), threadId);
        return (V)this.invoke(request);
    }

    @Override
    public void delete(Object key) {
        int threadId = (int)Thread.currentThread().getId();
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.DELETE, this.toData(key), threadId);
        this.invoke(request);
    }

    @Override
    public boolean remove(Object key, Object value) {
        int threadId = (int)Thread.currentThread().getId();
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.REMOVE_IF_SAME, this.toData(key), this.toData(value), threadId);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public Set<K> keySet() {
        int threadId = (int)Thread.currentThread().getId();
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.KEYSET, threadId);
        MapKeySet result = (MapKeySet)this.invoke(request);
        Set<Data> dataKeySet = result.getKeySet();
        HashSet<Object> keySet = new HashSet<Object>(dataKeySet.size());
        for (Data data : dataKeySet) {
            keySet.add(this.toObject(data));
        }
        return keySet;
    }

    @Override
    public Set<K> keySet(Predicate predicate) {
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        int threadId = (int)Thread.currentThread().getId();
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.KEYSET_BY_PREDICATE, predicate, threadId);
        MapKeySet result = (MapKeySet)this.invoke(request);
        Set<Data> dataKeySet = result.getKeySet();
        HashSet<Object> keySet = new HashSet<Object>(dataKeySet.size());
        for (Data data : dataKeySet) {
            keySet.add(this.toObject(data));
        }
        return keySet;
    }

    @Override
    public Collection<V> values() {
        int threadId = (int)Thread.currentThread().getId();
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.VALUES, threadId);
        MapValueCollection result = (MapValueCollection)this.invoke(request);
        Collection<Data> dataValues = result.getValues();
        HashSet<Object> values = new HashSet<Object>(dataValues.size());
        for (Data value : dataValues) {
            values.add(this.toObject(value));
        }
        return values;
    }

    @Override
    public Collection<V> values(Predicate predicate) {
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        int threadId = (int)Thread.currentThread().getId();
        TxnMapRequest request = new TxnMapRequest(this.getName(), AbstractTxnMapRequest.TxnMapRequestType.VALUES_BY_PREDICATE, predicate, threadId);
        MapValueCollection result = (MapValueCollection)this.invoke(request);
        Collection<Data> dataValues = result.getValues();
        HashSet<Object> values = new HashSet<Object>(dataValues.size());
        for (Data value : dataValues) {
            values.add(this.toObject(value));
        }
        return values;
    }

    @Override
    public String getName() {
        return (String)this.getId();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    void onDestroy() {
    }
}

