/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock.proxy;

import com.hazelcast.concurrent.lock.InternalLockNamespace;
import com.hazelcast.concurrent.lock.LockServiceImpl;
import com.hazelcast.concurrent.lock.proxy.ConditionImpl;
import com.hazelcast.concurrent.lock.proxy.LockProxySupport;
import com.hazelcast.core.ICondition;
import com.hazelcast.core.ILock;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.ObjectNamespace;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

public class LockProxy
extends AbstractDistributedObject<LockServiceImpl>
implements ILock {
    private final String name;
    private final LockProxySupport lockSupport;
    final Data key;

    public LockProxy(NodeEngine nodeEngine, LockServiceImpl lockService, String name) {
        super(nodeEngine, lockService);
        this.name = name;
        this.key = this.getNameAsPartitionAwareData();
        this.lockSupport = new LockProxySupport(new InternalLockNamespace(name));
    }

    @Override
    public boolean isLocked() {
        return this.lockSupport.isLocked(this.getNodeEngine(), this.key);
    }

    @Override
    public boolean isLockedByCurrentThread() {
        return this.lockSupport.isLockedByCurrentThread(this.getNodeEngine(), this.key);
    }

    @Override
    public int getLockCount() {
        return this.lockSupport.getLockCount(this.getNodeEngine(), this.key);
    }

    @Override
    public long getRemainingLeaseTime() {
        return this.lockSupport.getRemainingLeaseTime(this.getNodeEngine(), this.key);
    }

    @Override
    public void lock() {
        this.lockSupport.lock(this.getNodeEngine(), this.key);
    }

    @Override
    public void lock(long ttl, TimeUnit timeUnit) {
        this.lockSupport.lock(this.getNodeEngine(), this.key, timeUnit.toMillis(ttl));
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lock();
    }

    @Override
    public boolean tryLock() {
        return this.lockSupport.tryLock(this.getNodeEngine(), this.key);
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return this.lockSupport.tryLock(this.getNodeEngine(), this.key, time, unit);
    }

    @Override
    public void unlock() {
        this.lockSupport.unlock(this.getNodeEngine(), this.key);
    }

    @Override
    public void forceUnlock() {
        this.lockSupport.forceUnlock(this.getNodeEngine(), this.key);
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException("Use ICondition.newCondition(String name) instead!");
    }

    @Override
    public ICondition newCondition(String name) {
        return new ConditionImpl(this, name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:lockService";
    }

    @Override
    @Deprecated
    public Object getKey() {
        return this.getName();
    }

    int getPartitionId() {
        return this.getNodeEngine().getPartitionService().getPartitionId(this.key);
    }

    ObjectNamespace getNamespace() {
        return this.lockSupport.getNamespace();
    }

    public static String convertToStringKey(Object key, SerializationService serializationService) {
        if (key instanceof String) {
            return String.valueOf(key);
        }
        Data data = serializationService.toData(key, PARTITIONING_STRATEGY);
        byte[] buffer = data.getBuffer();
        return Arrays.toString(buffer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ILock{");
        sb.append("name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

