/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.client;

import com.hazelcast.client.CallableClientRequest;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.core.TransactionalQueue;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.queue.QueuePortableHook;
import com.hazelcast.security.permission.QueuePermission;
import com.hazelcast.transaction.TransactionContext;
import java.io.IOException;
import java.security.Permission;
import java.util.concurrent.TimeUnit;

public class TxnOfferRequest
extends CallableClientRequest
implements Portable,
SecureRequest {
    String name;
    long timeout;
    Data data;

    public TxnOfferRequest() {
    }

    public TxnOfferRequest(String name, long timeout, Data data) {
        this.name = name;
        this.timeout = timeout;
        this.data = data;
    }

    public Object call() throws Exception {
        ClientEndpoint endpoint = this.getEndpoint();
        TransactionContext context = endpoint.getTransactionContext();
        TransactionalQueue<Data> queue = context.getQueue(this.name);
        return queue.offer(this.data, this.timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:queueService";
    }

    @Override
    public int getFactoryId() {
        return QueuePortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 14;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeLong("t", this.timeout);
        this.data.writeData(writer.getRawDataOutput());
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.timeout = reader.readLong("t");
        this.data = new Data();
        this.data.readData(reader.getRawDataInput());
    }

    @Override
    public Permission getRequiredPermission() {
        return new QueuePermission(this.name, "add");
    }
}

