/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.AuthenticationFailureOperation;
import com.hazelcast.cluster.ClusterProxy;
import com.hazelcast.cluster.ClusterService;
import com.hazelcast.cluster.FinalizeJoinOperation;
import com.hazelcast.cluster.HeartbeatOperation;
import com.hazelcast.cluster.JoinCheckOperation;
import com.hazelcast.cluster.JoinMessage;
import com.hazelcast.cluster.JoinRequest;
import com.hazelcast.cluster.JoinRequestOperation;
import com.hazelcast.cluster.MasterConfirmationOperation;
import com.hazelcast.cluster.MemberInfo;
import com.hazelcast.cluster.MemberInfoUpdateOperation;
import com.hazelcast.cluster.MemberRemoveOperation;
import com.hazelcast.cluster.PostJoinOperation;
import com.hazelcast.cluster.SetMasterOperation;
import com.hazelcast.cluster.SplitBrainHandler;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.InitialMembershipEvent;
import com.hazelcast.core.InitialMembershipListener;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.instance.LifecycleServiceImpl;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.security.Credentials;
import com.hazelcast.spi.EventPublishingService;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MembershipAwareService;
import com.hazelcast.spi.MembershipServiceEvent;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.SplitBrainHandlerService;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.util.Clock;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public final class ClusterServiceImpl
implements ClusterService,
ConnectionListener,
ManagedService,
EventPublishingService<MembershipEvent, MembershipListener> {
    public static final String SERVICE_NAME = "hz:core:clusterService";
    private final Node node;
    private final NodeEngineImpl nodeEngine;
    private final ILogger logger;
    protected final Address thisAddress;
    protected final MemberImpl thisMember;
    private final long waitMillisBeforeJoin;
    private final long maxWaitSecondsBeforeJoin;
    private final long maxNoHeartbeatMillis;
    private final long maxNoMasterConfirmationMillis;
    private final boolean icmpEnabled;
    private final int icmpTtl;
    private final int icmpTimeout;
    private final Lock lock = new ReentrantLock();
    private final Set<MemberInfo> setJoins = new LinkedHashSet<MemberInfo>(100);
    private final AtomicReference<Map<Address, MemberImpl>> membersRef = new AtomicReference();
    private final AtomicBoolean preparingToMerge = new AtomicBoolean(false);
    private boolean joinInProgress = false;
    private long timeToStartJoin = 0L;
    private long firstJoinRequest = 0L;
    private final ConcurrentMap<MemberImpl, Long> masterConfirmationTimes = new ConcurrentHashMap<MemberImpl, Long>();
    private volatile long clusterTimeDiff = Long.MAX_VALUE;

    public ClusterServiceImpl(Node node) {
        this.node = node;
        this.nodeEngine = node.nodeEngine;
        this.logger = node.getLogger(ClusterService.class.getName());
        this.thisAddress = node.getThisAddress();
        this.thisMember = node.getLocalMember();
        this.setMembers(this.thisMember);
        this.waitMillisBeforeJoin = (long)node.groupProperties.WAIT_SECONDS_BEFORE_JOIN.getInteger() * 1000L;
        this.maxWaitSecondsBeforeJoin = node.groupProperties.MAX_WAIT_SECONDS_BEFORE_JOIN.getInteger();
        this.maxNoHeartbeatMillis = (long)node.groupProperties.MAX_NO_HEARTBEAT_SECONDS.getInteger() * 1000L;
        this.maxNoMasterConfirmationMillis = (long)node.groupProperties.MAX_NO_MASTER_CONFIRMATION_SECONDS.getInteger() * 1000L;
        this.icmpEnabled = node.groupProperties.ICMP_ENABLED.getBoolean();
        this.icmpTtl = node.groupProperties.ICMP_TTL.getInteger();
        this.icmpTimeout = node.groupProperties.ICMP_TIMEOUT.getInteger();
        node.connectionManager.addConnectionListener(this);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        long mergeFirstRunDelay = this.node.getGroupProperties().MERGE_FIRST_RUN_DELAY_SECONDS.getLong() * 1000L;
        mergeFirstRunDelay = mergeFirstRunDelay <= 0L ? 100L : mergeFirstRunDelay;
        ExecutionService executionService = nodeEngine.getExecutionService();
        String executorName = "hz:cluster";
        executionService.register(executorName, 8, 100000);
        long mergeNextRunDelay = this.node.getGroupProperties().MERGE_NEXT_RUN_DELAY_SECONDS.getLong() * 1000L;
        mergeNextRunDelay = mergeNextRunDelay <= 0L ? 100L : mergeNextRunDelay;
        executionService.scheduleWithFixedDelay(executorName, new SplitBrainHandler(this.node), mergeFirstRunDelay, mergeNextRunDelay, TimeUnit.MILLISECONDS);
        long heartbeatInterval = this.node.groupProperties.HEARTBEAT_INTERVAL_SECONDS.getInteger();
        heartbeatInterval = heartbeatInterval <= 0L ? 1L : heartbeatInterval;
        executionService.scheduleWithFixedDelay(executorName, new Runnable(){

            @Override
            public void run() {
                ClusterServiceImpl.this.heartBeater();
            }
        }, heartbeatInterval, heartbeatInterval, TimeUnit.SECONDS);
        long masterConfirmationInterval = this.node.groupProperties.MASTER_CONFIRMATION_INTERVAL_SECONDS.getInteger();
        masterConfirmationInterval = masterConfirmationInterval <= 0L ? 1L : masterConfirmationInterval;
        executionService.scheduleWithFixedDelay(executorName, new Runnable(){

            @Override
            public void run() {
                ClusterServiceImpl.this.sendMasterConfirmation();
            }
        }, masterConfirmationInterval, masterConfirmationInterval, TimeUnit.SECONDS);
        long memberListPublishInterval = this.node.groupProperties.MEMBER_LIST_PUBLISH_INTERVAL_SECONDS.getInteger();
        memberListPublishInterval = memberListPublishInterval <= 0L ? 1L : memberListPublishInterval;
        executionService.scheduleWithFixedDelay(executorName, new Runnable(){

            @Override
            public void run() {
                ClusterServiceImpl.this.sendMemberListToOthers();
            }
        }, memberListPublishInterval, memberListPublishInterval, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJoinInProgress() {
        this.lock.lock();
        try {
            boolean bl = this.joinInProgress || !this.setJoins.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public JoinRequest checkJoinInfo(Address target) {
        Invocation inv = this.nodeEngine.getOperationService().createInvocationBuilder(SERVICE_NAME, (Operation)new JoinCheckOperation(this.node.createJoinRequest()), target).setTryCount(1).build();
        try {
            return (JoinRequest)this.nodeEngine.toObject(inv.invoke().get());
        }
        catch (Exception e) {
            this.logger.warning("Error during join check!", e);
            return null;
        }
    }

    public boolean validateJoinMessage(JoinMessage joinMessage) throws Exception {
        boolean valid;
        boolean bl = valid = 1 == joinMessage.getPacketVersion();
        if (valid) {
            try {
                valid = this.node.createConfigCheck().isCompatible(joinMessage.getConfigCheck());
            }
            catch (Exception e) {
                String message = "Invalid join request from: " + joinMessage.getAddress() + ", reason:" + e.getMessage();
                this.logger.warning(message);
                this.node.getSystemLogService().logJoin(message);
                throw e;
            }
        }
        return valid;
    }

    private void logMissingConnection(Address address) {
        String msg = this.node.getLocalMember() + " has no connection to " + address;
        this.logger.warning(msg);
    }

    public final void heartBeater() {
        block21: {
            Collection<MemberImpl> members;
            long now;
            block20: {
                if (!this.node.joined() || !this.node.isActive()) {
                    return;
                }
                now = Clock.currentTimeMillis();
                members = this.getMemberList();
                if (!this.node.isMaster()) break block20;
                ArrayList<Address> deadAddresses = null;
                for (MemberImpl memberImpl : members) {
                    Address address = memberImpl.getAddress();
                    if (this.thisAddress.equals(address)) continue;
                    try {
                        Connection conn = this.node.connectionManager.getOrConnect(address);
                        if (conn != null && conn.live()) {
                            Long lastConfirmation;
                            if (now - memberImpl.getLastRead() >= this.maxNoHeartbeatMillis) {
                                if (deadAddresses == null) {
                                    deadAddresses = new ArrayList<Address>();
                                }
                                this.logger.warning("Added " + address + " to list of dead addresses because of timeout since last read");
                                deadAddresses.add(address);
                            } else if (now - memberImpl.getLastRead() >= 5000L && now - memberImpl.getLastPing() >= 5000L) {
                                this.ping(memberImpl);
                            }
                            if (now - memberImpl.getLastWrite() > 500L) {
                                this.sendHeartbeat(address);
                            }
                            if ((lastConfirmation = (Long)this.masterConfirmationTimes.get(memberImpl)) != null && now - lastConfirmation <= this.maxNoMasterConfirmationMillis) continue;
                            if (deadAddresses == null) {
                                deadAddresses = new ArrayList();
                            }
                            this.logger.warning("Added " + address + " to list of dead addresses because it has not sent a master confirmation recently");
                            deadAddresses.add(address);
                            continue;
                        }
                        if (conn != null || now - memberImpl.getLastRead() <= 5000L) continue;
                        this.logMissingConnection(address);
                        memberImpl.didRead();
                    }
                    catch (Exception e) {
                        this.logger.severe(e);
                    }
                }
                if (deadAddresses == null) break block21;
                for (Address address : deadAddresses) {
                    this.logger.finest("No heartbeat should remove " + address);
                    this.removeAddress(address);
                }
                break block21;
            }
            Address masterAddress = this.node.getMasterAddress();
            if (masterAddress != null) {
                this.node.connectionManager.getOrConnect(masterAddress);
                MemberImpl masterMember = this.getMember(masterAddress);
                boolean removed = false;
                if (masterMember != null) {
                    if (now - masterMember.getLastRead() >= this.maxNoHeartbeatMillis) {
                        this.logger.warning("Master node has timed out its heartbeat and will be removed");
                        this.removeAddress(masterAddress);
                        removed = true;
                    } else if (now - masterMember.getLastRead() >= 5000L && now - masterMember.getLastPing() >= 5000L) {
                        this.ping(masterMember);
                    }
                }
                if (!removed) {
                    this.sendHeartbeat(masterAddress);
                }
            }
            for (MemberImpl member : members) {
                if (member.localMember()) continue;
                Address address = member.getAddress();
                Connection conn = this.node.connectionManager.getOrConnect(address);
                if (conn != null) {
                    this.sendHeartbeat(address);
                    continue;
                }
                this.logger.finest("Could not connect to " + address + " to send heartbeat");
            }
        }
    }

    private void ping(final MemberImpl memberImpl) {
        memberImpl.didPing();
        if (!this.icmpEnabled) {
            return;
        }
        this.nodeEngine.getExecutionService().execute("hz:system", new Runnable(){

            @Override
            public void run() {
                try {
                    Address address = memberImpl.getAddress();
                    ClusterServiceImpl.this.logger.warning(ClusterServiceImpl.this.thisAddress + " will ping " + address);
                    for (int i = 0; i < 5; ++i) {
                        try {
                            if (!address.getInetAddress().isReachable(null, ClusterServiceImpl.this.icmpTtl, ClusterServiceImpl.this.icmpTimeout)) continue;
                            ClusterServiceImpl.this.logger.info(ClusterServiceImpl.this.thisAddress + " pings successfully. Target: " + address);
                            return;
                        }
                        catch (ConnectException connectException) {
                            // empty catch block
                        }
                    }
                    ClusterServiceImpl.this.logger.warning(ClusterServiceImpl.this.thisAddress + " couldn't ping " + address);
                    ClusterServiceImpl.this.removeAddress(address);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    private void sendHeartbeat(Address target) {
        if (target == null) {
            return;
        }
        try {
            this.node.nodeEngine.getOperationService().send((Operation)new HeartbeatOperation(), target);
        }
        catch (Exception e) {
            this.logger.finest("Error while sending heartbeat -> " + e.getClass().getName() + "[" + e.getMessage() + "]");
        }
    }

    private void sendMasterConfirmation() {
        if (!this.node.joined() || !this.node.isActive() || this.isMaster()) {
            return;
        }
        Address masterAddress = this.getMasterAddress();
        if (masterAddress == null) {
            this.logger.finest("Could not send MasterConfirmation, master is null!");
            return;
        }
        MemberImpl masterMember = this.getMember(masterAddress);
        if (masterMember == null) {
            this.logger.finest("Could not send MasterConfirmation, master is null!");
            return;
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Sending MasterConfirmation to " + masterMember);
        }
        this.nodeEngine.getOperationService().send((Operation)new MasterConfirmationOperation(), masterAddress);
    }

    private void resetMemberMasterConfirmations() {
        Collection<MemberImpl> memberList = this.getMemberList();
        for (MemberImpl member : memberList) {
            this.masterConfirmationTimes.put(member, Clock.currentTimeMillis());
        }
    }

    private void sendMemberListToOthers() {
        if (!this.isMaster()) {
            return;
        }
        Collection<MemberImpl> members = this.getMemberList();
        MemberInfoUpdateOperation op = new MemberInfoUpdateOperation(ClusterServiceImpl.createMemberInfos(members), this.getClusterTime(), false);
        for (MemberImpl member : members) {
            if (member.equals(this.thisMember)) continue;
            this.nodeEngine.getOperationService().send((Operation)op, member.getAddress());
        }
    }

    public void removeAddress(Address deadAddress) {
        this.doRemoveAddress(deadAddress, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemoveAddress(Address deadAddress, boolean destroyConnection) {
        if (this.preparingToMerge.get()) {
            this.logger.warning("Cluster-merge process is ongoing, won't process member removal: " + deadAddress);
            return;
        }
        if (!this.node.joined()) {
            this.node.failedConnection(deadAddress);
            return;
        }
        if (deadAddress.equals(this.thisAddress)) {
            return;
        }
        this.lock.lock();
        try {
            MemberImpl deadMember;
            if (deadAddress.equals(this.node.getMasterAddress())) {
                this.assignNewMaster();
            }
            if (this.node.isMaster()) {
                this.setJoins.remove(new MemberInfo(deadAddress));
                this.resetMemberMasterConfirmations();
            }
            Connection conn = this.node.connectionManager.getConnection(deadAddress);
            if (destroyConnection && conn != null) {
                this.node.connectionManager.destroyConnection(conn);
            }
            if ((deadMember = this.getMember(deadAddress)) != null) {
                this.removeMember(deadMember);
                this.logger.info(this.membersString());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void assignNewMaster() {
        Address oldMasterAddress = this.node.getMasterAddress();
        if (this.node.joined()) {
            Collection<MemberImpl> members = this.getMemberList();
            MemberImpl newMaster = null;
            int size = members.size();
            if (size > 1) {
                Iterator<MemberImpl> iter = members.iterator();
                MemberImpl member = iter.next();
                if (member.getAddress().equals(oldMasterAddress)) {
                    newMaster = iter.next();
                } else {
                    this.logger.severe("Old master " + oldMasterAddress + " is dead but the first of member list is a different member " + member + "!");
                    newMaster = member;
                }
            } else {
                this.logger.warning("Old master is dead and this node is not master but member list contains only " + size + " members! -> " + members);
            }
            this.logger.info("Master " + oldMasterAddress + " left the cluster. Assigning new master " + newMaster);
            if (newMaster != null) {
                this.node.setMasterAddress(newMaster.getAddress());
            } else {
                this.node.setMasterAddress(null);
            }
        } else {
            this.node.setMasterAddress(null);
        }
        this.logger.finest("Now Master " + this.node.getMasterAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void handleJoinRequest(JoinRequestOperation joinRequest) {
        this.lock.lock();
        try {
            boolean validJoinRequest;
            JoinRequest joinMessage = joinRequest.getMessage();
            long now = Clock.currentTimeMillis();
            String msg = "Handling join from " + joinMessage.getAddress() + ", inProgress: " + this.joinInProgress + (this.timeToStartJoin > 0L ? ", timeToStart: " + (this.timeToStartJoin - now) : "");
            this.logger.finest(msg);
            try {
                validJoinRequest = this.validateJoinMessage(joinMessage);
            }
            catch (Exception e) {
                validJoinRequest = false;
            }
            Connection conn = joinRequest.getConnection();
            if (validJoinRequest) {
                boolean multicastEnabled;
                MemberImpl member = this.getMember(joinMessage.getAddress());
                if (member != null) {
                    if (joinMessage.getUuid().equals(member.getUuid())) {
                        String message = "Ignoring join request, member already exists.. => " + joinMessage;
                        this.logger.finest(message);
                        this.nodeEngine.getOperationService().send((Operation)new MemberInfoUpdateOperation(ClusterServiceImpl.createMemberInfos(this.getMemberList()), this.getClusterTime(), false), member.getAddress());
                        return;
                    }
                    if (this.node.isMaster() || member.getAddress().equals(this.node.getMasterAddress())) {
                        this.logger.warning("New join request has been received from an existing endpoint! => " + member + " Removing old member and processing join request...");
                        this.doRemoveAddress(member.getAddress(), false);
                    }
                }
                if (!(multicastEnabled = this.node.getConfig().getNetworkConfig().getJoin().getMulticastConfig().isEnabled()) && this.node.isActive() && this.node.joined() && this.node.getMasterAddress() != null && !this.node.isMaster()) {
                    this.sendMasterAnswer(joinMessage);
                }
                if (!this.node.isMaster() || !this.node.joined() || !this.node.isActive()) return;
                MemberInfo newMemberInfo = new MemberInfo(joinMessage.getAddress(), joinMessage.getUuid());
                if (this.node.securityContext != null && !this.setJoins.contains(newMemberInfo)) {
                    Credentials cr = joinMessage.getCredentials();
                    ILogger securityLogger = this.node.loggingService.getLogger("com.hazelcast.security");
                    if (cr == null) {
                        securityLogger.severe("Expecting security credentials but credentials could not be found in JoinRequest!");
                        this.nodeEngine.getOperationService().send((Operation)new AuthenticationFailureOperation(), joinMessage.getAddress());
                        return;
                    }
                    try {
                        LoginContext lc = this.node.securityContext.createMemberLoginContext(cr);
                        lc.login();
                    }
                    catch (LoginException e) {
                        securityLogger.severe("Authentication has failed for " + cr.getPrincipal() + '@' + cr.getEndpoint() + " => (" + e.getMessage() + ")");
                        securityLogger.finest(e);
                        this.nodeEngine.getOperationService().send((Operation)new AuthenticationFailureOperation(), joinMessage.getAddress());
                        this.lock.unlock();
                        return;
                    }
                }
                if (this.joinInProgress) return;
                if (this.firstJoinRequest != 0L && now - this.firstJoinRequest >= this.maxWaitSecondsBeforeJoin * 1000L) {
                    this.startJoin();
                    return;
                } else {
                    if (this.setJoins.add(newMemberInfo)) {
                        this.sendMasterAnswer(joinMessage);
                        if (this.firstJoinRequest == 0L) {
                            this.firstJoinRequest = now;
                        }
                        if (now - this.firstJoinRequest < this.maxWaitSecondsBeforeJoin * 1000L) {
                            this.timeToStartJoin = now + this.waitMillisBeforeJoin;
                        }
                    }
                    if (now <= this.timeToStartJoin) return;
                    this.startJoin();
                }
                return;
            }
            conn.close();
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void sendMasterAnswer(JoinRequest joinRequest) {
        this.nodeEngine.getOperationService().send((Operation)new SetMasterOperation(this.node.getMasterAddress()), joinRequest.getAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleMaster(Address masterAddress) {
        this.lock.lock();
        try {
            if (!this.node.joined() && !this.node.getThisAddress().equals(masterAddress)) {
                Connection conn;
                this.logger.finest("Handling master response: " + this);
                Address currentMaster = this.node.getMasterAddress();
                if (currentMaster != null && !currentMaster.equals(masterAddress) && (conn = this.node.connectionManager.getConnection(currentMaster)) != null && conn.live()) {
                    this.logger.warning("Ignoring master response from " + masterAddress + ", since this node has an active master: " + currentMaster);
                    return;
                }
                this.node.setMasterAddress(masterAddress);
                this.node.connectionManager.getOrConnect(masterAddress);
                if (!this.sendJoinRequest(masterAddress, true)) {
                    this.logger.warning("Could not create connection to possible master " + masterAddress);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    void acceptMasterConfirmation(MemberImpl member) {
        if (member != null) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("MasterConfirmation has been received from " + member);
            }
            this.masterConfirmationTimes.put(member, Clock.currentTimeMillis());
        }
    }

    void prepareToMerge(final Address newTargetAddress) {
        this.preparingToMerge.set(true);
        this.node.getJoiner().setTargetAddress(newTargetAddress);
        this.nodeEngine.getExecutionService().schedule(new Runnable(){

            @Override
            public void run() {
                ClusterServiceImpl.this.merge(newTargetAddress);
            }
        }, 10L, TimeUnit.SECONDS);
    }

    void merge(Address newTargetAddress) {
        if (this.preparingToMerge.compareAndSet(true, false)) {
            this.node.getJoiner().setTargetAddress(newTargetAddress);
            final LifecycleServiceImpl lifecycleService = this.node.hazelcastInstance.getLifecycleService();
            lifecycleService.runUnderLifecycleLock(new Runnable(){

                @Override
                public void run() {
                    lifecycleService.fireLifecycleEvent(LifecycleEvent.LifecycleState.MERGING);
                    NodeEngineImpl nodeEngine = ((ClusterServiceImpl)ClusterServiceImpl.this).node.nodeEngine;
                    Collection<SplitBrainHandlerService> services = nodeEngine.getServices(SplitBrainHandlerService.class);
                    LinkedList<Runnable> tasks = new LinkedList<Runnable>();
                    for (SplitBrainHandlerService service : services) {
                        Runnable runnable = service.prepareMergeRunnable();
                        if (runnable == null) continue;
                        tasks.add(runnable);
                    }
                    Collection<ManagedService> managedServices = nodeEngine.getServices(ManagedService.class);
                    for (ManagedService service : managedServices) {
                        service.reset();
                    }
                    ClusterServiceImpl.this.node.onRestart();
                    ((ClusterServiceImpl)ClusterServiceImpl.this).node.connectionManager.restart();
                    ClusterServiceImpl.this.node.rejoin();
                    LinkedList futures = new LinkedList();
                    for (Runnable runnable : tasks) {
                        Future<?> f = nodeEngine.getExecutionService().submit("hz:system", runnable);
                        futures.add(f);
                    }
                    for (Future future : futures) {
                        try {
                            future.get();
                        }
                        catch (Exception e) {
                            ClusterServiceImpl.this.logger.severe("While merging...", e);
                        }
                    }
                    lifecycleService.fireLifecycleEvent(LifecycleEvent.LifecycleState.MERGED);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void joinReset() {
        this.lock.lock();
        try {
            this.joinInProgress = false;
            this.setJoins.clear();
            this.timeToStartJoin = Clock.currentTimeMillis() + this.waitMillisBeforeJoin;
            this.firstJoinRequest = 0L;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this.lock.lock();
        try {
            this.joinInProgress = false;
            this.setJoins.clear();
            this.timeToStartJoin = 0L;
            this.setMembersRef(Collections.singletonMap(this.thisAddress, this.thisMember));
            this.masterConfirmationTimes.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startJoin() {
        this.logger.finest("Starting Join.");
        this.lock.lock();
        try {
            this.joinInProgress = true;
            this.node.getPartitionService().pauseMigration();
            Collection<MemberImpl> members = this.getMemberList();
            Collection<MemberInfo> memberInfos = ClusterServiceImpl.createMemberInfos(members);
            for (MemberInfo memberJoining : this.setJoins) {
                memberInfos.add(memberJoining);
            }
            long time = this.getClusterTime();
            Operation[] postJoinOps = this.nodeEngine.getPostJoinOperations();
            PostJoinOperation postJoinOp = postJoinOps != null && postJoinOps.length > 0 ? new PostJoinOperation(postJoinOps) : null;
            int count = members.size() - 1 + this.setJoins.size();
            ArrayList<Future> calls = new ArrayList<Future>(count);
            for (MemberInfo memberInfo : this.setJoins) {
                calls.add(this.invokeClusterOperation(new FinalizeJoinOperation(memberInfos, postJoinOp, time), memberInfo.getAddress()));
            }
            for (MemberImpl memberImpl : members) {
                if (memberImpl.getAddress().equals(this.thisAddress)) continue;
                calls.add(this.invokeClusterOperation(new MemberInfoUpdateOperation(memberInfos, time, true), memberImpl.getAddress()));
            }
            this.updateMembers(memberInfos);
            for (Future future : calls) {
                try {
                    future.get(10L, TimeUnit.SECONDS);
                }
                catch (TimeoutException ignored) {
                    this.logger.finest("Finalize join call timed-out: " + future);
                }
                catch (Exception e) {
                    this.logger.warning("While waiting finalize join calls...", e);
                }
            }
        }
        finally {
            this.node.getPartitionService().resumeMigration();
            this.lock.unlock();
        }
    }

    private static Collection<MemberInfo> createMemberInfos(Collection<MemberImpl> members) {
        LinkedList<MemberInfo> memberInfos = new LinkedList<MemberInfo>();
        for (MemberImpl member : members) {
            memberInfos.add(new MemberInfo(member.getAddress(), member.getUuid()));
        }
        return memberInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateMembers(Collection<MemberInfo> members) {
        this.lock.lock();
        try {
            Map<Address, MemberImpl> oldMemberMap = this.membersRef.get();
            if (oldMemberMap == null) {
                oldMemberMap = Collections.emptyMap();
            }
            if (oldMemberMap.size() == members.size()) {
                boolean same = true;
                for (MemberInfo memberInfo : members) {
                    MemberImpl member = oldMemberMap.get(memberInfo.getAddress());
                    if (member != null && member.getUuid().equals(memberInfo.uuid)) continue;
                    same = false;
                    break;
                }
                if (same) {
                    this.logger.finest("No need to process member update...");
                    return;
                }
            }
            MemberImpl[] newMembers = new MemberImpl[members.size()];
            int k = 0;
            for (MemberInfo memberInfo : members) {
                MemberImpl member = oldMemberMap.get(memberInfo.address);
                if (member == null) {
                    member = this.createMember(memberInfo.address, memberInfo.uuid, this.thisAddress.getScopeId());
                }
                newMembers[k++] = member;
                member.didRead();
            }
            this.setMembers(newMembers);
            if (!this.getMemberList().contains(this.thisMember)) {
                throw new HazelcastException("Member list doesn't contain local member!");
            }
            this.joinReset();
            this.heartBeater();
            this.node.setJoined();
            this.logger.info(this.membersString());
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean sendJoinRequest(Address toAddress, boolean withCredentials) {
        if (toAddress == null) {
            toAddress = this.node.getMasterAddress();
        }
        JoinRequestOperation joinRequest = new JoinRequestOperation(this.node.createJoinRequest(withCredentials));
        this.nodeEngine.getOperationService().send((Operation)joinRequest, toAddress);
        return true;
    }

    @Override
    public void connectionAdded(Connection connection) {
        MemberImpl member = this.getMember(connection.getEndPoint());
        if (member != null) {
            member.didRead();
        }
    }

    @Override
    public void connectionRemoved(Connection connection) {
        Address masterAddress;
        this.logger.finest("Connection is removed " + connection.getEndPoint());
        if (!this.node.joined() && (masterAddress = this.node.getMasterAddress()) != null && masterAddress.equals(connection.getEndPoint())) {
            this.node.setMasterAddress(null);
        }
    }

    private Future invokeClusterOperation(Operation op, Address target) {
        return this.nodeEngine.getOperationService().createInvocationBuilder(SERVICE_NAME, op, target).setTryCount(50).build().invoke();
    }

    public NodeEngineImpl getNodeEngine() {
        return this.nodeEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMembers(MemberImpl ... members) {
        if (members == null || members.length == 0) {
            return;
        }
        this.logger.finest("Updating members -> " + Arrays.toString(members));
        this.lock.lock();
        try {
            Map<Address, MemberImpl> oldMemberMap = this.membersRef.get();
            if (oldMemberMap == null) {
                oldMemberMap = Collections.emptyMap();
            }
            LinkedHashMap<Address, MemberImpl> memberMap = new LinkedHashMap<Address, MemberImpl>();
            LinkedList<MemberImpl> newMembers = new LinkedList<MemberImpl>();
            for (MemberImpl member : members) {
                MemberImpl currentMember = oldMemberMap.get(member.getAddress());
                if (currentMember == null) {
                    newMembers.add(member);
                    this.masterConfirmationTimes.put(member, Clock.currentTimeMillis());
                }
                memberMap.put(member.getAddress(), member);
            }
            this.setMembersRef(memberMap);
            if (!newMembers.isEmpty()) {
                LinkedHashSet<MemberImpl> eventMembers = new LinkedHashSet<MemberImpl>(oldMemberMap.values());
                if (newMembers.size() == 1) {
                    MemberImpl newMember = (MemberImpl)newMembers.iterator().next();
                    this.node.getPartitionService().memberAdded(newMember);
                    eventMembers.add(newMember);
                    this.sendMembershipEventNotifications(newMember, Collections.unmodifiableSet(eventMembers), true);
                } else {
                    for (MemberImpl newMember : newMembers) {
                        this.node.getPartitionService().memberAdded(newMember);
                        eventMembers.add(newMember);
                        this.sendMembershipEventNotifications(newMember, Collections.unmodifiableSet(new LinkedHashSet<MemberImpl>(eventMembers)), true);
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMember(MemberImpl deadMember) {
        this.logger.info("Removing " + deadMember);
        this.lock.lock();
        try {
            Map<Address, MemberImpl> members = this.membersRef.get();
            if (members != null && members.containsKey(deadMember.getAddress())) {
                LinkedHashMap<Address, MemberImpl> newMembers = new LinkedHashMap<Address, MemberImpl>(members);
                newMembers.remove(deadMember.getAddress());
                this.masterConfirmationTimes.remove(deadMember);
                this.setMembersRef(newMembers);
                this.node.getPartitionService().memberRemoved(deadMember);
                this.nodeEngine.onMemberLeft(deadMember);
                this.sendMembershipEventNotifications(deadMember, Collections.unmodifiableSet(new LinkedHashSet(newMembers.values())), false);
                if (this.node.isMaster()) {
                    this.logger.finest(deadMember + " is dead. Sending remove to all other members.");
                    this.invokeMemberRemoveOperation(deadMember.getAddress());
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void invokeMemberRemoveOperation(Address deadAddress) {
        for (MemberImpl member : this.getMemberList()) {
            Address address = member.getAddress();
            if (this.thisAddress.equals(address) || address.equals(deadAddress)) continue;
            this.nodeEngine.getOperationService().send((Operation)new MemberRemoveOperation(deadAddress), address);
        }
    }

    public void sendShutdownMessage() {
        this.invokeMemberRemoveOperation(this.thisAddress);
    }

    private void sendMembershipEventNotifications(MemberImpl member, Set<Member> members, final boolean added) {
        int eventType = added ? 1 : 2;
        MembershipEvent membershipEvent = new MembershipEvent(this.getClusterProxy(), member, eventType, members);
        Collection<MembershipAwareService> membershipAwareServices = this.nodeEngine.getServices(MembershipAwareService.class);
        if (membershipAwareServices != null && !membershipAwareServices.isEmpty()) {
            final MembershipServiceEvent event = new MembershipServiceEvent(membershipEvent);
            for (final MembershipAwareService service : membershipAwareServices) {
                this.nodeEngine.getExecutionService().execute("hz:system", new Runnable(){

                    @Override
                    public void run() {
                        if (added) {
                            service.memberAdded(event);
                        } else {
                            service.memberRemoved(event);
                        }
                    }
                });
            }
        }
        EventService eventService = this.nodeEngine.getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations(SERVICE_NAME, SERVICE_NAME);
        for (EventRegistration reg : registrations) {
            eventService.publishEvent(SERVICE_NAME, reg, (Object)membershipEvent, reg.getId().hashCode());
        }
    }

    protected MemberImpl createMember(Address address, String nodeUuid, String ipV6ScopeId) {
        address.setScopeId(ipV6ScopeId);
        return new MemberImpl(address, this.thisAddress.equals(address), nodeUuid);
    }

    @Override
    public MemberImpl getMember(Address address) {
        if (address == null) {
            return null;
        }
        Map<Address, MemberImpl> memberMap = this.membersRef.get();
        return memberMap != null ? memberMap.get(address) : null;
    }

    @Override
    public MemberImpl getMember(String uuid) {
        if (uuid == null) {
            return null;
        }
        Map<Address, MemberImpl> memberMap = this.membersRef.get();
        if (memberMap == null) {
            return null;
        }
        for (MemberImpl member : memberMap.values()) {
            if (!uuid.equals(member.getUuid())) continue;
            return member;
        }
        return null;
    }

    private void setMembersRef(Map<Address, MemberImpl> memberMap) {
        Map<Address, MemberImpl> members = Collections.unmodifiableMap(memberMap);
        members.values();
        members.keySet();
        members.entrySet();
        this.membersRef.set(members);
    }

    @Override
    public Collection<MemberImpl> getMemberList() {
        Map<Address, MemberImpl> map = this.membersRef.get();
        return map != null ? Collections.unmodifiableCollection(map.values()) : Collections.emptySet();
    }

    @Override
    public void shutdown() {
        this.reset();
    }

    @Override
    public Address getMasterAddress() {
        return this.node.getMasterAddress();
    }

    @Override
    public boolean isMaster() {
        return this.node.isMaster();
    }

    @Override
    public Address getThisAddress() {
        return this.thisAddress;
    }

    public Member getLocalMember() {
        return this.node.getLocalMember();
    }

    public Set<Member> getMembers() {
        Collection<MemberImpl> members = this.getMemberList();
        return members != null ? new LinkedHashSet<MemberImpl>(members) : new HashSet(0);
    }

    @Override
    public int getSize() {
        Collection<MemberImpl> members = this.getMemberList();
        return members != null ? members.size() : 0;
    }

    @Override
    public long getClusterTime() {
        return Clock.currentTimeMillis() + (this.clusterTimeDiff == Long.MAX_VALUE ? 0L : this.clusterTimeDiff);
    }

    public void setMasterTime(long masterTime) {
        long diff = masterTime - Clock.currentTimeMillis();
        if (Math.abs(diff) < Math.abs(this.clusterTimeDiff)) {
            this.clusterTimeDiff = diff;
        }
    }

    public long getClusterTimeFor(long localTime) {
        return localTime + (this.clusterTimeDiff == Long.MAX_VALUE ? 0L : this.clusterTimeDiff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addMembershipListener(MembershipListener listener) {
        if (listener instanceof InitialMembershipListener) {
            this.lock.lock();
            try {
                ((InitialMembershipListener)listener).init(new InitialMembershipEvent(this.getClusterProxy(), (Set<Member>)this.getMembers()));
                EventRegistration registration = this.nodeEngine.getEventService().registerLocalListener(SERVICE_NAME, SERVICE_NAME, listener);
                String string = registration.getId();
                return string;
            }
            finally {
                this.lock.unlock();
            }
        }
        EventRegistration registration = this.nodeEngine.getEventService().registerLocalListener(SERVICE_NAME, SERVICE_NAME, listener);
        return registration.getId();
    }

    public boolean removeMembershipListener(String registrationId) {
        return this.nodeEngine.getEventService().deregisterListener(SERVICE_NAME, SERVICE_NAME, registrationId);
    }

    @Override
    public void dispatchEvent(MembershipEvent event, MembershipListener listener) {
        if (event.getEventType() == 1) {
            listener.memberAdded(event);
        } else {
            listener.memberRemoved(event);
        }
    }

    public Cluster getClusterProxy() {
        return new ClusterProxy(this);
    }

    public String membersString() {
        StringBuilder sb = new StringBuilder("\n\nMembers [");
        Collection<MemberImpl> members = this.getMemberList();
        sb.append(members != null ? members.size() : 0);
        sb.append("] {");
        if (members != null) {
            for (Member member : members) {
                sb.append("\n\t").append(member);
            }
        }
        sb.append("\n}\n");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClusterService");
        sb.append("{address=").append(this.thisAddress);
        sb.append('}');
        return sb.toString();
    }
}

