/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.AuthenticationRequest;
import com.hazelcast.client.ClientDisconnectionOperation;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEngine;
import com.hazelcast.client.ClientExceptionConverters;
import com.hazelcast.client.ClientPortableHook;
import com.hazelcast.client.ClientRequest;
import com.hazelcast.client.ClientServiceProxy;
import com.hazelcast.client.InitializingObjectRequest;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.cluster.ClusterService;
import com.hazelcast.config.Config;
import com.hazelcast.core.Client;
import com.hazelcast.core.ClientListener;
import com.hazelcast.core.ClientService;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ClientPacket;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.nio.TcpIpConnection;
import com.hazelcast.nio.TcpIpConnectionManager;
import com.hazelcast.nio.serialization.ClassDefinitionBuilder;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataAdapter;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.spi.CoreService;
import com.hazelcast.spi.EventPublishingService;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.InvocationBuilder;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MembershipAwareService;
import com.hazelcast.spi.MembershipServiceEvent;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationFactory;
import com.hazelcast.spi.ProxyService;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.ResponseHandlerFactory;
import com.hazelcast.transaction.TransactionManagerService;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.UuidUtil;
import java.security.Permission;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.security.auth.login.LoginException;

public class ClientEngineImpl
implements ClientEngine,
ConnectionListener,
CoreService,
ManagedService,
MembershipAwareService,
EventPublishingService<ClientEndpoint, ClientListener> {
    public static final String SERVICE_NAME = "hz:core:clientEngine";
    private final Node node;
    private final NodeEngineImpl nodeEngine;
    private final Executor executor;
    private final SerializationService serializationService;
    private final ConcurrentMap<Connection, ClientEndpoint> endpoints = new ConcurrentHashMap<Connection, ClientEndpoint>();
    private final ILogger logger;
    private static final Data NULL = new Data();
    private final ConstructorFunction<Connection, ClientEndpoint> endpointConstructor = new ConstructorFunction<Connection, ClientEndpoint>(){

        @Override
        public ClientEndpoint createNew(Connection conn) {
            return new ClientEndpoint(ClientEngineImpl.this, conn, UuidUtil.createClientUuid(conn.getEndPoint()));
        }
    };

    public ClientEngineImpl(Node node) {
        this.node = node;
        this.serializationService = node.getSerializationService();
        this.nodeEngine = node.nodeEngine;
        this.executor = this.nodeEngine.getExecutionService().getExecutor("hz:client");
        this.logger = node.getLogger(ClientEngine.class);
    }

    @Override
    public int getClientEndpointCount() {
        return this.endpoints.size();
    }

    public void handlePacket(ClientPacket packet) {
        this.executor.execute(new ClientPacketProcessor(packet));
    }

    @Override
    public Object toObject(Data data) {
        return this.serializationService.toObject(data);
    }

    @Override
    public Data toData(Object obj) {
        return this.serializationService.toData(obj);
    }

    @Override
    public PartitionService getPartitionService() {
        return this.nodeEngine.getPartitionService();
    }

    @Override
    public ClusterService getClusterService() {
        return this.nodeEngine.getClusterService();
    }

    @Override
    public SerializationService getSerializationService() {
        return this.serializationService;
    }

    @Override
    public EventService getEventService() {
        return this.nodeEngine.getEventService();
    }

    @Override
    public ProxyService getProxyService() {
        return this.nodeEngine.getProxyService();
    }

    void sendOperation(Operation op, Address target) {
        this.nodeEngine.getOperationService().send(op, target);
    }

    InvocationBuilder createInvocationBuilder(String serviceName, Operation op, int partitionId) {
        return this.nodeEngine.getOperationService().createInvocationBuilder(serviceName, op, partitionId);
    }

    InvocationBuilder createInvocationBuilder(String serviceName, Operation op, Address target) {
        return this.nodeEngine.getOperationService().createInvocationBuilder(serviceName, op, target);
    }

    Map<Integer, Object> invokeOnAllPartitions(String serviceName, OperationFactory operationFactory) throws Exception {
        return this.nodeEngine.getOperationService().invokeOnAllPartitions(serviceName, operationFactory);
    }

    Map<Integer, Object> invokeOnPartitions(String serviceName, OperationFactory operationFactory, Collection<Integer> partitions) throws Exception {
        return this.nodeEngine.getOperationService().invokeOnPartitions(serviceName, operationFactory, partitions);
    }

    @Override
    public void sendResponse(ClientEndpoint endpoint, Object response) {
        if (response instanceof Throwable) {
            response = ClientExceptionConverters.get(endpoint.getClientType()).convert((Throwable)response);
        }
        Data resultData = response != null ? this.serializationService.toData(response) : NULL;
        Connection conn = endpoint.getConnection();
        conn.write(new DataAdapter(resultData, this.serializationService.getSerializationContext()));
    }

    @Override
    public TransactionManagerService getTransactionManagerService() {
        return this.nodeEngine.getTransactionManagerService();
    }

    @Override
    public Address getMasterAddress() {
        return this.node.getMasterAddress();
    }

    @Override
    public Address getThisAddress() {
        return this.node.getThisAddress();
    }

    @Override
    public MemberImpl getLocalMember() {
        return this.node.getLocalMember();
    }

    @Override
    public Config getConfig() {
        return this.node.getConfig();
    }

    @Override
    public ILogger getLogger(Class clazz) {
        return this.node.getLogger(clazz);
    }

    @Override
    public ILogger getLogger(String className) {
        return this.node.getLogger(className);
    }

    Set<ClientEndpoint> getEndpoints(String uuid) {
        HashSet<ClientEndpoint> endpointSet = new HashSet<ClientEndpoint>();
        for (ClientEndpoint endpoint : this.endpoints.values()) {
            if (!uuid.equals(endpoint.getUuid())) continue;
            endpointSet.add(endpoint);
        }
        return endpointSet;
    }

    ClientEndpoint getEndpoint(Connection conn) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.endpoints, conn, this.endpointConstructor);
    }

    ClientEndpoint removeEndpoint(Connection connection) {
        return this.removeEndpoint(connection, false);
    }

    ClientEndpoint removeEndpoint(Connection connection, boolean closeImmediately) {
        ClientEndpoint endpoint = (ClientEndpoint)this.endpoints.remove(connection);
        this.destroyEndpoint(endpoint, closeImmediately);
        return endpoint;
    }

    private void destroyEndpoint(ClientEndpoint endpoint, boolean closeImmediately) {
        if (endpoint != null) {
            this.logger.info("Destroying " + endpoint);
            try {
                endpoint.destroy();
            }
            catch (LoginException e) {
                this.logger.warning(e);
            }
            final Connection connection = endpoint.getConnection();
            if (closeImmediately) {
                try {
                    connection.close();
                }
                catch (Throwable e) {
                    this.logger.warning("While closing client connection: " + connection, e);
                }
            } else {
                this.nodeEngine.getExecutionService().schedule(new Runnable(){

                    @Override
                    public void run() {
                        if (connection.live()) {
                            try {
                                connection.close();
                            }
                            catch (Throwable e) {
                                ClientEngineImpl.this.logger.warning("While closing client connection: " + e.toString());
                            }
                        }
                    }
                }, 1111L, TimeUnit.MILLISECONDS);
            }
            this.sendClientEvent(endpoint);
        }
    }

    @Override
    public void connectionAdded(Connection connection) {
    }

    @Override
    public void connectionRemoved(Connection connection) {
        ClientEndpoint endpoint;
        if (connection.isClient() && connection instanceof TcpIpConnection && this.nodeEngine.isActive() && (endpoint = (ClientEndpoint)this.endpoints.get(connection)) != null && this.node.getLocalMember().getUuid().equals(endpoint.getPrincipal().getOwnerUuid())) {
            this.removeEndpoint(connection, true);
            if (!endpoint.isFirstConnection()) {
                return;
            }
            NodeEngineImpl nodeEngine = this.node.nodeEngine;
            Collection<MemberImpl> memberList = nodeEngine.getClusterService().getMemberList();
            for (MemberImpl member : memberList) {
                ClientDisconnectionOperation op = new ClientDisconnectionOperation(endpoint.getUuid());
                op.setNodeEngine(nodeEngine).setServiceName(SERVICE_NAME).setService(this).setResponseHandler(ResponseHandlerFactory.createEmptyResponseHandler());
                if (member.localMember()) {
                    nodeEngine.getOperationService().runOperation(op);
                    continue;
                }
                nodeEngine.getOperationService().send((Operation)op, member.getAddress());
            }
        }
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.node.securityContext;
    }

    void bind(ClientEndpoint endpoint) {
        Connection conn = endpoint.getConnection();
        if (conn instanceof TcpIpConnection) {
            Address address = new Address(conn.getRemoteSocketAddress());
            TcpIpConnectionManager connectionManager = (TcpIpConnectionManager)this.node.getConnectionManager();
            connectionManager.bind((TcpIpConnection)conn, address, null, false);
        }
        this.sendClientEvent(endpoint);
    }

    private void sendClientEvent(ClientEndpoint endpoint) {
        EventService eventService = this.nodeEngine.getEventService();
        Collection<EventRegistration> regs = eventService.getRegistrations(SERVICE_NAME, SERVICE_NAME);
        eventService.publishEvent(SERVICE_NAME, regs, (Object)endpoint, endpoint.getUuid().hashCode());
    }

    @Override
    public void dispatchEvent(ClientEndpoint event, ClientListener listener) {
        if (event.isAuthenticated()) {
            listener.clientConnected(event);
        } else {
            listener.clientDisconnected(event);
        }
    }

    @Override
    public void memberAdded(MembershipServiceEvent event) {
    }

    @Override
    public void memberRemoved(MembershipServiceEvent event) {
        if (event.getMember().localMember()) {
            return;
        }
        final String uuid = event.getMember().getUuid();
        try {
            this.nodeEngine.getExecutionService().schedule(new Runnable(){

                @Override
                public void run() {
                    Iterator iter = ClientEngineImpl.this.endpoints.values().iterator();
                    while (iter.hasNext()) {
                        ClientEndpoint endpoint = (ClientEndpoint)iter.next();
                        if (!uuid.equals(endpoint.getPrincipal().getOwnerUuid())) continue;
                        iter.remove();
                        ClientEngineImpl.this.destroyEndpoint(endpoint, true);
                    }
                }
            }, 10L, TimeUnit.SECONDS);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    String addClientListener(ClientListener clientListener) {
        EventRegistration registration = this.nodeEngine.getEventService().registerLocalListener(SERVICE_NAME, SERVICE_NAME, clientListener);
        return registration.getId();
    }

    boolean removeClientListener(String registrationId) {
        return this.nodeEngine.getEventService().deregisterListener(SERVICE_NAME, SERVICE_NAME, registrationId);
    }

    public ClientService getClientService() {
        return new ClientServiceProxy(this);
    }

    public Collection<Client> getEndpoints() {
        return new HashSet<Client>(this.endpoints.values());
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        ClassDefinitionBuilder builder = new ClassDefinitionBuilder(ClientPortableHook.ID, 3);
        builder.addUTFField("uuid").addUTFField("ownerUuid");
        this.serializationService.getSerializationContext().registerClassDefinition(builder.build());
        this.node.getConnectionManager().addConnectionListener(this);
    }

    @Override
    public void reset() {
    }

    @Override
    public void shutdown() {
        for (ClientEndpoint endpoint : this.endpoints.values()) {
            try {
                endpoint.destroy();
            }
            catch (LoginException e) {
                this.logger.finest(e.getMessage());
            }
            try {
                Connection conn = endpoint.getConnection();
                if (!conn.live()) continue;
                conn.close();
            }
            catch (Exception e) {
                this.logger.finest(e);
            }
        }
        this.endpoints.clear();
    }

    private class ClientPacketProcessor
    implements Runnable {
        final ClientPacket packet;

        private ClientPacketProcessor(ClientPacket packet) {
            this.packet = packet;
        }

        @Override
        public void run() {
            Connection conn = this.packet.getConn();
            ClientEndpoint endpoint = ClientEngineImpl.this.getEndpoint(conn);
            ClientRequest request = null;
            try {
                Data data = this.packet.getData();
                request = (ClientRequest)ClientEngineImpl.this.serializationService.toObject(data);
                if (endpoint.isAuthenticated() || request instanceof AuthenticationRequest) {
                    Permission permission;
                    request.setEndpoint(endpoint);
                    String serviceName = request.getServiceName();
                    if (serviceName != null) {
                        Object service = ClientEngineImpl.this.nodeEngine.getService(serviceName);
                        if (service == null) {
                            if (ClientEngineImpl.this.nodeEngine.isActive()) {
                                throw new IllegalArgumentException("No service registered with name: " + serviceName);
                            }
                            throw new HazelcastInstanceNotActiveException();
                        }
                        request.setService(service);
                        if (request instanceof InitializingObjectRequest) {
                            String objectName = ((InitializingObjectRequest)((Object)request)).getObjectName();
                            ClientEngineImpl.this.nodeEngine.getProxyService().initializeDistributedObject(serviceName, objectName);
                        }
                    }
                    request.setClientEngine(ClientEngineImpl.this);
                    SecurityContext securityContext = ClientEngineImpl.this.getSecurityContext();
                    if (securityContext != null && request instanceof SecureRequest && (permission = ((SecureRequest)((Object)request)).getRequiredPermission()) != null) {
                        securityContext.checkPermission(endpoint.getSubject(), permission);
                    }
                    request.process();
                } else {
                    RuntimeException exception;
                    if (ClientEngineImpl.this.nodeEngine.isActive()) {
                        String message = "Client " + conn + " must authenticate before any operation.";
                        ClientEngineImpl.this.logger.severe(message);
                        exception = new AuthenticationException(message);
                    } else {
                        exception = new HazelcastInstanceNotActiveException();
                    }
                    ClientEngineImpl.this.sendResponse(endpoint, exception);
                    ClientEngineImpl.this.removeEndpoint(conn);
                }
            }
            catch (Throwable e) {
                Level level = ClientEngineImpl.this.nodeEngine.isActive() ? Level.SEVERE : Level.FINEST;
                String message = request != null ? "While executing request: " + request + " -> " + e.getMessage() : e.getMessage();
                ClientEngineImpl.this.logger.log(level, message, e);
                ClientEngineImpl.this.sendResponse(endpoint, e);
            }
        }
    }
}

