/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapService;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.record.Record;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.IndexService;
import com.hazelcast.query.impl.QueryEntry;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.impl.AbstractNamedOperation;
import java.io.IOException;
import java.util.Map;

public class AddIndexOperation
extends AbstractNamedOperation
implements PartitionAwareOperation {
    String attributeName;
    boolean ordered;

    public AddIndexOperation(String name, String attributeName, boolean ordered) {
        super(name);
        this.attributeName = attributeName;
        this.ordered = ordered;
    }

    public AddIndexOperation() {
    }

    @Override
    public void run() throws Exception {
        MapService mapService = (MapService)this.getService();
        MapContainer mapContainer = mapService.getMapContainer(this.name);
        RecordStore rs = mapService.getPartitionContainer(this.getPartitionId()).getRecordStore(this.name);
        Map<Data, Record> records = rs.getReadonlyRecordMap();
        IndexService indexService = mapContainer.getIndexService();
        SerializationService ss = this.getNodeEngine().getSerializationService();
        Index index = indexService.addOrGetIndex(this.attributeName, this.ordered);
        for (Record record : records.values()) {
            Data key = record.getKey();
            Object value = record.getValue();
            if (value == null) continue;
            index.saveEntryIndex(new QueryEntry(ss, key, key, value));
        }
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.attributeName);
        out.writeBoolean(this.ordered);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.attributeName = in.readUTF();
        this.ordered = in.readBoolean();
    }
}

