/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.operations.client;

import com.hazelcast.client.CallableClientRequest;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEngine;
import com.hazelcast.client.InitializingObjectRequest;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.multimap.MultiMapPortableHook;
import com.hazelcast.multimap.MultiMapService;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MultiMapPermission;
import com.hazelcast.spi.impl.PortableEntryEvent;
import java.io.IOException;
import java.security.Permission;

public class AddEntryListenerRequest
extends CallableClientRequest
implements Portable,
InitializingObjectRequest,
SecureRequest {
    String name;
    Data key;
    boolean includeValue;

    public AddEntryListenerRequest() {
    }

    public AddEntryListenerRequest(String name, Data key, boolean includeValue) {
        this.name = name;
        this.key = key;
        this.includeValue = includeValue;
    }

    public Object call() throws Exception {
        final ClientEndpoint endpoint = this.getEndpoint();
        final ClientEngine clientEngine = this.getClientEngine();
        MultiMapService service = (MultiMapService)this.getService();
        EntryListener listener = new EntryListener(){

            public void entryAdded(EntryEvent event) {
                this.send(event);
            }

            public void entryRemoved(EntryEvent event) {
                this.send(event);
            }

            public void entryUpdated(EntryEvent event) {
                this.send(event);
            }

            public void entryEvicted(EntryEvent event) {
                this.send(event);
            }

            private void send(EntryEvent event) {
                if (endpoint.live()) {
                    Data key = clientEngine.toData(event.getKey());
                    Data value = clientEngine.toData(event.getValue());
                    Data oldValue = clientEngine.toData(event.getOldValue());
                    PortableEntryEvent portableEntryEvent = new PortableEntryEvent(key, value, oldValue, event.getEventType(), event.getMember().getUuid());
                    clientEngine.sendResponse(endpoint, portableEntryEvent);
                }
            }
        };
        String registrationId = service.addListener(this.name, listener, this.key, this.includeValue, false);
        endpoint.setListenerRegistration("hz:impl:multiMapService", this.name, registrationId);
        return null;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:multiMapService";
    }

    @Override
    public String getObjectName() {
        return this.name;
    }

    @Override
    public int getFactoryId() {
        return MultiMapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 14;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeBoolean("i", this.includeValue);
        writer.writeUTF("n", this.name);
        ObjectDataOutput out = writer.getRawDataOutput();
        IOUtil.writeNullableData(out, this.key);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.includeValue = reader.readBoolean("i");
        this.name = reader.readUTF("n");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = IOUtil.readNullableData(in);
    }

    @Override
    public Permission getRequiredPermission() {
        return new MultiMapPermission(this.name, "listen");
    }
}

