/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cardinality.impl;

import com.hazelcast.cardinality.impl.CardinalityEstimatorContainer;
import com.hazelcast.cardinality.impl.CardinalityEstimatorProxy;
import com.hazelcast.cardinality.impl.operations.MergeOperation;
import com.hazelcast.cardinality.impl.operations.ReplicationOperation;
import com.hazelcast.config.CardinalityEstimatorConfig;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.logging.ILogger;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.QuorumAwareService;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.spi.SplitBrainHandlerService;
import com.hazelcast.spi.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.DiscardMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergePolicyProvider;
import com.hazelcast.spi.partition.IPartitionService;
import com.hazelcast.spi.partition.MigrationEndpoint;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.ContextMutexFactory;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.MapUtil;
import com.hazelcast.util.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class CardinalityEstimatorService
implements ManagedService,
RemoteService,
MigrationAwareService,
QuorumAwareService,
SplitBrainHandlerService {
    public static final String SERVICE_NAME = "hz:impl:cardinalityEstimatorService";
    private static final double SIZING_FUDGE_FACTOR = 1.3;
    private static final Object NULL_OBJECT = new Object();
    private NodeEngine nodeEngine;
    private SplitBrainMergePolicyProvider mergePolicyProvider;
    private final ConcurrentMap<String, CardinalityEstimatorContainer> containers = new ConcurrentHashMap<String, CardinalityEstimatorContainer>();
    private final ConstructorFunction<String, CardinalityEstimatorContainer> cardinalityEstimatorContainerConstructorFunction = new ConstructorFunction<String, CardinalityEstimatorContainer>(){

        @Override
        public CardinalityEstimatorContainer createNew(String name) {
            CardinalityEstimatorConfig config = CardinalityEstimatorService.this.nodeEngine.getConfig().findCardinalityEstimatorConfig(name);
            return new CardinalityEstimatorContainer(config.getBackupCount(), config.getAsyncBackupCount());
        }
    };
    private final ConcurrentMap<String, Object> quorumConfigCache = new ConcurrentHashMap<String, Object>();
    private final ContextMutexFactory quorumConfigCacheMutexFactory = new ContextMutexFactory();
    private final ConstructorFunction<String, Object> quorumConfigConstructor = new ConstructorFunction<String, Object>(){

        @Override
        public Object createNew(String name) {
            CardinalityEstimatorConfig config = CardinalityEstimatorService.this.nodeEngine.getConfig().findCardinalityEstimatorConfig(name);
            String quorumName = config.getQuorumName();
            return quorumName == null ? NULL_OBJECT : quorumName;
        }
    };

    public void addCardinalityEstimator(String name, CardinalityEstimatorContainer container) {
        Preconditions.checkNotNull(name, "Name can't be null");
        Preconditions.checkNotNull(container, "Container can't be null");
        this.containers.put(name, container);
    }

    public CardinalityEstimatorContainer getCardinalityEstimatorContainer(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.containers, name, this.cardinalityEstimatorContainerConstructorFunction);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.nodeEngine = nodeEngine;
        this.mergePolicyProvider = nodeEngine.getSplitBrainMergePolicyProvider();
    }

    @Override
    public void reset() {
        this.containers.clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    @Override
    public CardinalityEstimatorProxy createDistributedObject(String objectName) {
        return new CardinalityEstimatorProxy(objectName, this.nodeEngine, this);
    }

    @Override
    public void destroyDistributedObject(String objectName) {
        this.containers.remove(objectName);
        this.quorumConfigCache.remove(objectName);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        IPartitionService partitionService = this.nodeEngine.getPartitionService();
        int roughSize = (int)((double)this.containers.size() * 1.3 / (double)partitionService.getPartitionCount());
        Map<String, CardinalityEstimatorContainer> data = MapUtil.createHashMap(roughSize);
        int partitionId = event.getPartitionId();
        for (Map.Entry containerEntry : this.containers.entrySet()) {
            String name = (String)containerEntry.getKey();
            CardinalityEstimatorContainer container = (CardinalityEstimatorContainer)containerEntry.getValue();
            if (partitionId != this.getPartitionId(name) || event.getReplicaIndex() > container.getTotalBackupCount()) continue;
            data.put(name, (CardinalityEstimatorContainer)containerEntry.getValue());
        }
        return data.isEmpty() ? null : new ReplicationOperation(data);
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearPartitionReplica(event.getPartitionId(), event.getNewReplicaIndex());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearPartitionReplica(event.getPartitionId(), event.getCurrentReplicaIndex());
        }
    }

    @Override
    public Runnable prepareMergeRunnable() {
        HashMap<String, CardinalityEstimatorContainer> state = new HashMap<String, CardinalityEstimatorContainer>();
        for (Map.Entry entry : this.containers.entrySet()) {
            SplitBrainMergePolicy mergePolicy = this.getMergePolicy((String)entry.getKey());
            int partition = this.getPartitionId((String)entry.getKey());
            if (!this.nodeEngine.getPartitionService().isPartitionOwner(partition) || mergePolicy instanceof DiscardMergePolicy) continue;
            state.put((String)entry.getKey(), (CardinalityEstimatorContainer)entry.getValue());
        }
        return new Merger(state);
    }

    private void clearPartitionReplica(int partitionId, int durabilityThreshold) {
        Iterator iterator = this.containers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (this.getPartitionId((String)entry.getKey()) != partitionId || durabilityThreshold != -1 && durabilityThreshold <= ((CardinalityEstimatorContainer)entry.getValue()).getTotalBackupCount()) continue;
            iterator.remove();
        }
    }

    private int getPartitionId(String name) {
        IPartitionService partitionService = this.nodeEngine.getPartitionService();
        String partitionKey = StringPartitioningStrategy.getPartitionKey(name);
        return partitionService.getPartitionId(partitionKey);
    }

    @Override
    public String getQuorumName(String name) {
        if (this.nodeEngine.getClusterService().getClusterVersion().isLessThan(Versions.V3_10)) {
            return null;
        }
        Object quorumName = ConcurrencyUtil.getOrPutSynchronized(this.quorumConfigCache, name, this.quorumConfigCacheMutexFactory, this.quorumConfigConstructor);
        return quorumName == NULL_OBJECT ? null : (String)quorumName;
    }

    private SplitBrainMergePolicy getMergePolicy(String name) {
        String mergePolicyName = this.nodeEngine.getConfig().findCardinalityEstimatorConfig(name).getMergePolicyConfig().getPolicy();
        return this.mergePolicyProvider.getMergePolicy(mergePolicyName);
    }

    private class Merger
    implements Runnable {
        private static final long TIMEOUT_FACTOR = 500L;
        private final ILogger logger;
        private final Semaphore semaphore;
        private final ExecutionCallback<Object> mergeCallback;
        private final Map<String, CardinalityEstimatorContainer> snapshot;

        Merger(Map<String, CardinalityEstimatorContainer> snapshot) {
            this.logger = CardinalityEstimatorService.this.nodeEngine.getLogger(CardinalityEstimatorService.class);
            this.semaphore = new Semaphore(0);
            this.mergeCallback = new ExecutionCallback<Object>(){

                @Override
                public void onResponse(Object response) {
                    Merger.this.semaphore.release(1);
                }

                @Override
                public void onFailure(Throwable t) {
                    Merger.this.logger.warning("Error while running cardinality estimator merge operation: " + t.getMessage());
                    Merger.this.semaphore.release(1);
                }
            };
            this.snapshot = snapshot;
        }

        @Override
        public void run() {
            if (CardinalityEstimatorService.this.nodeEngine.getClusterService().getClusterVersion().isLessThan(Versions.V3_10)) {
                this.logger.info("Cluster needs to run version " + Versions.V3_10 + " to merge cardinality estimator instances");
                return;
            }
            int size = 0;
            int operationCount = 0;
            try {
                for (Map.Entry<String, CardinalityEstimatorContainer> entry : this.snapshot.entrySet()) {
                    String containerName = entry.getKey();
                    CardinalityEstimatorContainer container = entry.getValue();
                    int partitionId = CardinalityEstimatorService.this.getPartitionId(containerName);
                    ++operationCount;
                    SplitBrainMergePolicy mergePolicy = CardinalityEstimatorService.this.getMergePolicy(containerName);
                    MergeOperation operation = new MergeOperation(containerName, mergePolicy, container.hll);
                    try {
                        CardinalityEstimatorService.this.nodeEngine.getOperationService().invokeOnPartition(CardinalityEstimatorService.SERVICE_NAME, operation, partitionId).andThen(this.mergeCallback);
                    }
                    catch (Throwable t) {
                        throw ExceptionUtil.rethrow(t);
                    }
                    ++size;
                }
                this.snapshot.clear();
            }
            catch (Exception e) {
                this.logger.warning("Split-brain healing of cardinality estimators didn't complete successfully...", e);
                throw ExceptionUtil.rethrow(e);
            }
            try {
                if (!this.semaphore.tryAcquire(operationCount, (long)size * 500L, TimeUnit.MILLISECONDS)) {
                    this.logger.warning("Split-brain healing for cardinality estimators didn't finish within the timeout...");
                }
            }
            catch (InterruptedException e) {
                this.logger.finest("Interrupted while waiting for split-brain healing of cardinality estimators...");
                Thread.currentThread().interrupt();
            }
        }
    }
}

