/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cardinality.impl.hyperloglog.impl;

import com.hazelcast.cardinality.impl.CardinalityEstimatorDataSerializerHook;
import com.hazelcast.cardinality.impl.hyperloglog.impl.DenseHyperLogLogEncoder;
import com.hazelcast.cardinality.impl.hyperloglog.impl.HyperLogLogEncoder;
import com.hazelcast.cardinality.impl.hyperloglog.impl.HyperLogLogEncoding;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.Arrays;

public class SparseHyperLogLogEncoder
implements HyperLogLogEncoder {
    private static final long P_PRIME_FENCE_MASK = 0x8000000000L;
    private static final int DEFAULT_TEMP_CAPACITY = 200;
    private int p;
    private int pMask;
    private int pFenseMask;
    private int pPrime;
    private int pPrimeMask;
    private long pDiffMask;
    private VariableLengthDiffArray register;
    private int[] temp;
    private int mPrime;
    private int tempIdx;

    public SparseHyperLogLogEncoder() {
    }

    SparseHyperLogLogEncoder(int p, int pPrime) {
        this.init(p, pPrime, new VariableLengthDiffArray());
    }

    public void init(int p, int pPrime, VariableLengthDiffArray register) {
        this.p = p;
        this.pFenseMask = 1 << 64 - p - 1;
        this.pPrime = pPrime;
        this.pPrimeMask = (1 << pPrime) - 1;
        this.mPrime = 1 << pPrime;
        this.temp = new int[200];
        this.pMask = (1 << p) - 1;
        this.pDiffMask = this.pPrimeMask ^ this.pMask;
        this.register = register;
    }

    @Override
    public boolean add(long hash) {
        boolean isTempAtCapacity;
        int encoded = this.encodeHash(hash);
        this.temp[this.tempIdx++] = encoded;
        boolean bl = isTempAtCapacity = this.tempIdx == 200;
        if (isTempAtCapacity) {
            this.mergeAndResetTmp();
        }
        return true;
    }

    @Override
    public long estimate() {
        this.mergeAndResetTmp();
        return this.linearCounting(this.mPrime, this.mPrime - this.register.total);
    }

    @Override
    public HyperLogLogEncoder merge(HyperLogLogEncoder encoder) {
        HyperLogLogEncoder dense = this.asDense();
        return dense.merge(encoder);
    }

    @Override
    public int getFactoryId() {
        return CardinalityEstimatorDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 7;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        this.mergeAndResetTmp();
        out.writeInt(this.p);
        out.writeInt(this.pPrime);
        out.writeInt(this.register.total);
        out.writeInt(this.register.mark);
        out.writeInt(this.register.prev);
        out.writeByteArray(this.register.elements);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int p = in.readInt();
        int pPrime = in.readInt();
        int total = in.readInt();
        int mark = in.readInt();
        int prev = in.readInt();
        byte[] bytes = in.readByteArray();
        this.init(p, pPrime, new VariableLengthDiffArray(bytes, total, mark, prev));
    }

    @Override
    public HyperLogLogEncoding getEncodingType() {
        return HyperLogLogEncoding.SPARSE;
    }

    @Override
    public int getMemoryFootprint() {
        return this.register.mark + 800;
    }

    HyperLogLogEncoder asDense() {
        this.mergeAndResetTmp();
        byte[] dense = new byte[1 << this.p];
        for (int hash : this.register.explode()) {
            int index = this.decodeHashPIndex(hash);
            dense[index] = (byte)Math.max(dense[index], this.decodeHashRunOfZeros(hash));
        }
        return new DenseHyperLogLogEncoder(this.p, dense);
    }

    private int encodeHash(long hash) {
        int index = (int)(hash & (long)this.pPrimeMask) << 32 - this.pPrime;
        if ((hash & this.pDiffMask) == 0L) {
            return index | Long.numberOfTrailingZeros(hash >>> this.pPrime | 0x8000000000L) << 1 | 1;
        }
        return (index >>> 32 - this.pPrime & this.pPrimeMask) << 1;
    }

    private int decodeHashPPrimeIndex(int hash) {
        if (!this.hasRunOfZerosEncoded(hash)) {
            return hash >> 1 & this.pPrimeMask & this.mPrime - 1;
        }
        return hash >> 32 - this.pPrime & this.pPrimeMask & this.mPrime - 1;
    }

    private int decodeHashPIndex(long hash) {
        if (!this.hasRunOfZerosEncoded(hash)) {
            return (int)(hash >>> 1) & this.pMask;
        }
        return (int)(hash >>> 32 - this.pPrime) & this.pMask;
    }

    private byte decodeHashRunOfZeros(int hash) {
        if (!this.hasRunOfZerosEncoded(hash)) {
            int stripFlag = hash >>> 1;
            int pShifted = stripFlag >>> this.p;
            return (byte)Integer.numberOfTrailingZeros(pShifted | this.pFenseMask);
        }
        int pW = (hash & (1 << 32 - this.pPrime) - 1) >>> 1;
        return (byte)(pW + (this.pPrime - this.p) + 1);
    }

    private boolean hasRunOfZerosEncoded(long hash) {
        return (hash & 1L) == 1L;
    }

    private long linearCounting(int total, int empty) {
        return (long)((double)total * Math.log((double)total / (double)empty));
    }

    private void mergeAndResetTmp() {
        if (this.tempIdx == 0) {
            return;
        }
        int[] old = this.register.explode();
        int[] all = Arrays.copyOf(old, old.length + this.tempIdx);
        System.arraycopy(this.temp, 0, all, old.length, this.tempIdx);
        Arrays.sort(all);
        this.register.clear();
        int previousHash = all[0];
        for (int i = 1; i < all.length; ++i) {
            boolean conflictingIndex;
            int hash = all[i];
            boolean bl = conflictingIndex = this.decodeHashPPrimeIndex(hash) == this.decodeHashPPrimeIndex(previousHash);
            if (!conflictingIndex) {
                this.register.add(previousHash);
            }
            previousHash = hash;
        }
        this.register.add(previousHash);
        Arrays.fill(this.temp, 0);
        this.tempIdx = 0;
    }

    private static class VariableLengthDiffArray {
        private static final int INITIAL_CAPACITY = 32;
        private byte[] elements = new byte[32];
        private int prev;
        private int total;
        private int mark;

        VariableLengthDiffArray() {
        }

        VariableLengthDiffArray(byte[] elements, int total, int mark, int prev) {
            this.elements = elements;
            this.total = total;
            this.mark = mark;
            this.prev = prev;
        }

        void add(int value) {
            this.append(value - this.prev);
            this.prev = value;
        }

        void clear() {
            Arrays.fill(this.elements, (byte)0);
            this.mark = 0;
            this.total = 0;
            this.prev = 0;
        }

        int[] explode() {
            int[] exploded = new int[this.total];
            int counter = 0;
            int last = 0;
            for (int i = 0; i < this.mark; ++i) {
                byte element;
                int noOfBytes = 0;
                do {
                    element = this.elements[i++];
                    int n = counter;
                    exploded[n] = exploded[n] | (element & 0x7F) << 7 * noOfBytes++;
                } while (this.needsMoreBytes(element));
                int n = counter;
                exploded[n] = exploded[n] + last;
                last = exploded[counter];
                --i;
                ++counter;
            }
            return exploded;
        }

        private void append(int diff) {
            while (diff > 127) {
                this.ensureCapacity();
                this.elements[this.mark++] = (byte)(diff & 0x7F | 0x80);
                diff >>>= 7;
            }
            this.ensureCapacity();
            this.elements[this.mark++] = (byte)(diff & 0x7F);
            ++this.total;
        }

        private void ensureCapacity() {
            if (this.elements.length == this.mark) {
                int newCapacity = this.elements.length << 1;
                this.elements = Arrays.copyOf(this.elements, newCapacity);
            }
        }

        private boolean needsMoreBytes(byte val) {
            return (val & 0x80) != 0;
        }
    }
}

