/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.collection;

import com.hazelcast.collection.impl.collection.CollectionContainer;
import com.hazelcast.collection.impl.collection.CollectionEvent;
import com.hazelcast.collection.impl.collection.CollectionItem;
import com.hazelcast.collection.impl.collection.operations.CollectionMergeOperation;
import com.hazelcast.collection.impl.common.DataAwareItemEvent;
import com.hazelcast.collection.impl.txncollection.operations.CollectionTransactionRollbackOperation;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.core.ItemListener;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.spi.EventPublishingService;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.QuorumAwareService;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.spi.SplitBrainHandlerService;
import com.hazelcast.spi.SplitBrainMergePolicy;
import com.hazelcast.spi.TransactionalService;
import com.hazelcast.spi.impl.merge.MergingHolders;
import com.hazelcast.spi.merge.DiscardMergePolicy;
import com.hazelcast.spi.merge.MergingValueHolder;
import com.hazelcast.spi.merge.SplitBrainMergePolicyProvider;
import com.hazelcast.spi.partition.IPartitionService;
import com.hazelcast.spi.partition.MigrationEndpoint;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.MapUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public abstract class CollectionService
implements ManagedService,
RemoteService,
EventPublishingService<CollectionEvent, ItemListener<Data>>,
TransactionalService,
MigrationAwareService,
QuorumAwareService,
SplitBrainHandlerService {
    protected final NodeEngine nodeEngine;
    protected final SerializationService serializationService;
    protected final IPartitionService partitionService;
    protected final SplitBrainMergePolicyProvider mergePolicyProvider;
    private final ILogger logger;

    protected CollectionService(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.serializationService = nodeEngine.getSerializationService();
        this.partitionService = nodeEngine.getPartitionService();
        this.mergePolicyProvider = nodeEngine.getSplitBrainMergePolicyProvider();
        this.logger = nodeEngine.getLogger(this.getClass());
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
    }

    @Override
    public void reset() {
        this.getContainerMap().clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    @Override
    public void destroyDistributedObject(String name) {
        this.getContainerMap().remove(name);
        this.nodeEngine.getEventService().deregisterAllListeners(this.getServiceName(), name);
    }

    public abstract CollectionContainer getOrCreateContainer(String var1, boolean var2);

    public abstract Map<String, ? extends CollectionContainer> getContainerMap();

    public abstract String getServiceName();

    @Override
    public void dispatchEvent(CollectionEvent event, ItemListener<Data> listener) {
        MemberImpl member = this.nodeEngine.getClusterService().getMember(event.getCaller());
        DataAwareItemEvent itemEvent = new DataAwareItemEvent(event.getName(), event.getEventType(), event.getData(), member, this.serializationService);
        if (member == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Dropping event " + itemEvent + " from unknown address:" + event.getCaller());
            }
            return;
        }
        if (event.getEventType().equals((Object)ItemEventType.ADDED)) {
            listener.itemAdded(itemEvent);
        } else {
            listener.itemRemoved(itemEvent);
        }
    }

    @Override
    public void rollbackTransaction(String transactionId) {
        Set<String> collectionNames = this.getContainerMap().keySet();
        OperationService operationService = this.nodeEngine.getOperationService();
        for (String name : collectionNames) {
            int partitionId = this.partitionService.getPartitionId(StringPartitioningStrategy.getPartitionKey(name));
            Operation operation = new CollectionTransactionRollbackOperation(name, transactionId).setPartitionId(partitionId).setService(this).setNodeEngine(this.nodeEngine);
            operationService.invokeOnPartition(operation);
        }
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
    }

    protected Map<String, CollectionContainer> getMigrationData(PartitionReplicationEvent event) {
        HashMap<String, CollectionContainer> migrationData = new HashMap<String, CollectionContainer>();
        for (Map.Entry<String, ? extends CollectionContainer> entry : this.getContainerMap().entrySet()) {
            String name = entry.getKey();
            int partitionId = this.partitionService.getPartitionId(StringPartitioningStrategy.getPartitionKey(name));
            CollectionContainer container = entry.getValue();
            if (partitionId != event.getPartitionId() || container.getConfig().getTotalBackupCount() < event.getReplicaIndex()) continue;
            migrationData.put(name, container);
        }
        return migrationData;
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearCollectionsHavingLesserBackupCountThan(event.getPartitionId(), event.getNewReplicaIndex());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearCollectionsHavingLesserBackupCountThan(event.getPartitionId(), event.getCurrentReplicaIndex());
        }
    }

    private void clearCollectionsHavingLesserBackupCountThan(int partitionId, int thresholdReplicaIndex) {
        Set<Map.Entry<String, ? extends CollectionContainer>> entrySet = this.getContainerMap().entrySet();
        Iterator<Map.Entry<String, ? extends CollectionContainer>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends CollectionContainer> entry = iterator.next();
            String name = entry.getKey();
            CollectionContainer container = entry.getValue();
            int containerPartitionId = this.partitionService.getPartitionId(StringPartitioningStrategy.getPartitionKey(name));
            if (containerPartitionId != partitionId || thresholdReplicaIndex >= 0 && thresholdReplicaIndex <= container.getConfig().getTotalBackupCount()) continue;
            container.destroy();
            iterator.remove();
        }
    }

    public void addContainer(String name, CollectionContainer container) {
        Map<String, ? extends CollectionContainer> map = this.getContainerMap();
        map.put(name, container);
    }

    @Override
    public Runnable prepareMergeRunnable() {
        Map<String, ? extends CollectionContainer> containers = this.getContainerMap();
        Map<Integer, Map<CollectionContainer, List<CollectionItem>>> itemMap = MapUtil.createHashMap(this.partitionService.getPartitionCount());
        for (CollectionContainer collectionContainer : containers.values()) {
            String name = collectionContainer.getName();
            Object partitionAwareName = this.serializationService.toData(name, StringPartitioningStrategy.INSTANCE);
            int partitionId = this.partitionService.getPartitionId((Data)partitionAwareName);
            if (this.partitionService.isPartitionOwner(partitionId) && !(this.getMergePolicy(collectionContainer) instanceof DiscardMergePolicy)) {
                Map<CollectionContainer, List<CollectionItem>> containerMap = itemMap.get(partitionId);
                if (containerMap == null) {
                    containerMap = new HashMap<CollectionContainer, List<CollectionItem>>();
                    itemMap.put(partitionId, containerMap);
                }
                containerMap.put(collectionContainer, new ArrayList<CollectionItem>(collectionContainer.getCollection()));
            }
            collectionContainer.clear();
        }
        containers.clear();
        return new Merger(itemMap);
    }

    private SplitBrainMergePolicy getMergePolicy(CollectionContainer container) {
        String mergePolicyName = container.getConfig().getMergePolicyConfig().getPolicy();
        return this.mergePolicyProvider.getMergePolicy(mergePolicyName);
    }

    private class Merger
    implements Runnable {
        private static final long TIMEOUT_FACTOR = 500L;
        private final ILogger logger;
        private final Semaphore semaphore;
        private final ExecutionCallback<Object> mergeCallback;
        private final Map<Integer, Map<CollectionContainer, List<CollectionItem>>> itemMap;

        Merger(Map<Integer, Map<CollectionContainer, List<CollectionItem>>> itemMap) {
            this.logger = CollectionService.this.nodeEngine.getLogger(CollectionService.class);
            this.semaphore = new Semaphore(0);
            this.mergeCallback = new ExecutionCallback<Object>(){

                @Override
                public void onResponse(Object response) {
                    Merger.this.semaphore.release(1);
                }

                @Override
                public void onFailure(Throwable t) {
                    Merger.this.logger.warning("Error while running collection merge operation: " + t.getMessage());
                    Merger.this.semaphore.release(1);
                }
            };
            this.itemMap = itemMap;
        }

        @Override
        public void run() {
            if (CollectionService.this.nodeEngine.getClusterService().getClusterVersion().isLessThan(Versions.V3_10)) {
                this.logger.info("Cluster needs to run version " + Versions.V3_10 + " to merge collection instances");
                return;
            }
            int itemCount = 0;
            int operationCount = 0;
            for (Map.Entry<Integer, Map<CollectionContainer, List<CollectionItem>>> partitionEntry : this.itemMap.entrySet()) {
                int partitionId = partitionEntry.getKey();
                Map<CollectionContainer, List<CollectionItem>> containerMap = partitionEntry.getValue();
                for (Map.Entry<CollectionContainer, List<CollectionItem>> containerEntry : containerMap.entrySet()) {
                    CollectionContainer container = containerEntry.getKey();
                    Collection itemList = containerEntry.getValue();
                    String name = container.getName();
                    int batchSize = container.getConfig().getMergePolicyConfig().getBatchSize();
                    SplitBrainMergePolicy mergePolicy = CollectionService.this.getMergePolicy(container);
                    ArrayList<MergingValueHolder<Data>> mergingValues = new ArrayList<MergingValueHolder<Data>>();
                    for (CollectionItem item : itemList) {
                        MergingValueHolder<Data> mergingValue = MergingHolders.createMergeHolder(item);
                        mergingValues.add(mergingValue);
                        ++itemCount;
                        if (mergingValues.size() != batchSize) continue;
                        this.sendBatch(partitionId, name, mergePolicy, mergingValues, this.mergeCallback);
                        mergingValues = new ArrayList(batchSize);
                        ++operationCount;
                    }
                    itemList.clear();
                    if (mergingValues.size() <= 0) continue;
                    this.sendBatch(partitionId, name, mergePolicy, mergingValues, this.mergeCallback);
                    ++operationCount;
                }
            }
            this.itemMap.clear();
            try {
                if (!this.semaphore.tryAcquire(operationCount, (long)itemCount * 500L, TimeUnit.MILLISECONDS)) {
                    this.logger.warning("Split-brain healing for collections didn't finish within the timeout...");
                }
            }
            catch (InterruptedException e) {
                this.logger.finest("Interrupted while waiting for split-brain healing of collections...");
                Thread.currentThread().interrupt();
            }
        }

        private void sendBatch(int partitionId, String name, SplitBrainMergePolicy mergePolicy, List<MergingValueHolder<Data>> mergingValues, ExecutionCallback<Object> mergeCallback) {
            CollectionMergeOperation operation = new CollectionMergeOperation(name, mergePolicy, mergingValues);
            try {
                CollectionService.this.nodeEngine.getOperationService().invokeOnPartition(CollectionService.this.getServiceName(), operation, partitionId).andThen(mergeCallback);
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        }
    }
}

