/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.queue.operations;

import com.hazelcast.collection.impl.queue.QueueContainer;
import com.hazelcast.collection.impl.queue.QueueItem;
import com.hazelcast.collection.impl.queue.operations.AddAllBackupOperation;
import com.hazelcast.collection.impl.queue.operations.QueueBackupAwareOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.SplitBrainMergePolicy;
import com.hazelcast.spi.impl.MutatingOperation;
import com.hazelcast.spi.merge.MergingValueHolder;
import com.hazelcast.util.MapUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class QueueMergeOperation
extends QueueBackupAwareOperation
implements MutatingOperation {
    private SplitBrainMergePolicy mergePolicy;
    private List<MergingValueHolder<Data>> mergingValues;
    private transient Map<Long, Data> valueMap;

    public QueueMergeOperation() {
    }

    public QueueMergeOperation(String name, SplitBrainMergePolicy mergePolicy, List<MergingValueHolder<Data>> mergingValues) {
        super(name);
        this.mergePolicy = mergePolicy;
        this.mergingValues = mergingValues;
    }

    @Override
    public void run() {
        QueueContainer queueContainer = this.getContainer();
        this.valueMap = MapUtil.createHashMap(this.mergingValues.size());
        for (MergingValueHolder<Data> mergingValue : this.mergingValues) {
            QueueItem mergedItem = queueContainer.merge(mergingValue, this.mergePolicy);
            if (mergedItem == null) continue;
            this.valueMap.put(mergedItem.getItemId(), mergedItem.getData());
        }
    }

    @Override
    public void afterRun() {
        this.getQueueService().getLocalQueueStatsImpl(this.name).incrementOtherOperations();
    }

    @Override
    public boolean shouldBackup() {
        return this.valueMap != null && !this.valueMap.isEmpty();
    }

    @Override
    public Operation getBackupOperation() {
        return new AddAllBackupOperation(this.name, this.valueMap);
    }

    @Override
    public int getId() {
        return 44;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.mergePolicy);
        out.writeInt(this.mergingValues.size());
        for (MergingValueHolder<Data> mergingValue : this.mergingValues) {
            out.writeObject(mergingValue);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mergePolicy = (SplitBrainMergePolicy)in.readObject();
        int size = in.readInt();
        this.mergingValues = new ArrayList<MergingValueHolder<Data>>(size);
        for (int i = 0; i < size; ++i) {
            MergingValueHolder mergingValue = (MergingValueHolder)in.readObject();
            this.mergingValues.add(mergingValue);
        }
    }
}

