/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.atomiclong;

import com.hazelcast.config.AtomicLongConfig;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.SplitBrainMergePolicy;
import com.hazelcast.spi.impl.merge.MergingHolders;
import com.hazelcast.spi.merge.MergingValueHolder;
import com.hazelcast.spi.serialization.SerializationService;

public class AtomicLongContainer {
    private final String name;
    private final AtomicLongConfig config;
    private final SerializationService serializationService;
    private long value;

    public AtomicLongContainer(String name, NodeEngine nodeEngine) {
        this.name = name;
        this.config = nodeEngine.getConfig().findAtomicLongConfig(name);
        this.serializationService = nodeEngine.getSerializationService();
    }

    public String getName() {
        return this.name;
    }

    public AtomicLongConfig getConfig() {
        return this.config;
    }

    public long get() {
        return this.value;
    }

    public long addAndGet(long delta) {
        this.value += delta;
        return this.value;
    }

    public void set(long value) {
        this.value = value;
    }

    public boolean compareAndSet(long expect, long value) {
        if (this.value != expect) {
            return false;
        }
        this.value = value;
        return true;
    }

    public long getAndAdd(long delta) {
        long tempValue = this.value;
        this.value += delta;
        return tempValue;
    }

    public long getAndSet(long value) {
        long tempValue = this.value;
        this.value = value;
        return tempValue;
    }

    public Long merge(MergingValueHolder<Long> mergingValue, SplitBrainMergePolicy mergePolicy, boolean isExistingContainer) {
        this.serializationService.getManagedContext().initialize(mergePolicy);
        mergingValue.setSerializationService(this.serializationService);
        if (isExistingContainer) {
            MergingValueHolder<Long> existingValue = MergingHolders.createMergeHolder(this.value);
            existingValue.setSerializationService(this.serializationService);
            Long newValue = mergePolicy.merge(mergingValue, existingValue);
            if (newValue != null && !newValue.equals(this.value)) {
                this.value = newValue;
                return newValue;
            }
        } else {
            Long newValue = mergePolicy.merge(mergingValue, null);
            if (newValue != null) {
                this.value = newValue;
                return newValue;
            }
        }
        return null;
    }
}

