/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.atomiclong;

import com.hazelcast.concurrent.atomiclong.AtomicLongContainer;
import com.hazelcast.concurrent.atomiclong.AtomicLongProxy;
import com.hazelcast.concurrent.atomiclong.operations.AtomicLongReplicationOperation;
import com.hazelcast.concurrent.atomiclong.operations.MergeOperation;
import com.hazelcast.config.AtomicLongConfig;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.config.ConfigValidator;
import com.hazelcast.logging.ILogger;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.QuorumAwareService;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.spi.SplitBrainHandlerService;
import com.hazelcast.spi.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.DiscardMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergePolicyProvider;
import com.hazelcast.spi.partition.IPartitionService;
import com.hazelcast.spi.partition.MigrationEndpoint;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.ContextMutexFactory;
import com.hazelcast.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class AtomicLongService
implements ManagedService,
RemoteService,
MigrationAwareService,
QuorumAwareService,
SplitBrainHandlerService {
    public static final String SERVICE_NAME = "hz:impl:atomicLongService";
    private static final Object NULL_OBJECT = new Object();
    private final ConcurrentMap<String, AtomicLongContainer> containers = new ConcurrentHashMap<String, AtomicLongContainer>();
    private final ConstructorFunction<String, AtomicLongContainer> atomicLongConstructorFunction = new ConstructorFunction<String, AtomicLongContainer>(){

        @Override
        public AtomicLongContainer createNew(String key) {
            return new AtomicLongContainer(key, AtomicLongService.this.nodeEngine);
        }
    };
    private final ConcurrentMap<String, Object> quorumConfigCache = new ConcurrentHashMap<String, Object>();
    private final ContextMutexFactory quorumConfigCacheMutexFactory = new ContextMutexFactory();
    private final ConstructorFunction<String, Object> quorumConfigConstructor = new ConstructorFunction<String, Object>(){

        @Override
        public Object createNew(String name) {
            AtomicLongConfig config = AtomicLongService.this.nodeEngine.getConfig().findAtomicLongConfig(name);
            String quorumName = config.getQuorumName();
            return quorumName == null ? NULL_OBJECT : quorumName;
        }
    };
    private NodeEngine nodeEngine;
    private SplitBrainMergePolicyProvider mergePolicyProvider;

    public AtomicLongContainer getLongContainer(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.containers, name, this.atomicLongConstructorFunction);
    }

    public boolean containsAtomicLong(String name) {
        return this.containers.containsKey(name);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.nodeEngine = nodeEngine;
        this.mergePolicyProvider = nodeEngine.getSplitBrainMergePolicyProvider();
    }

    @Override
    public void reset() {
        this.containers.clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    @Override
    public AtomicLongProxy createDistributedObject(String name) {
        AtomicLongConfig atomicLongConfig = this.nodeEngine.getConfig().findAtomicLongConfig(name);
        ConfigValidator.checkBasicConfig(atomicLongConfig);
        return new AtomicLongProxy(name, this.nodeEngine, this);
    }

    @Override
    public void destroyDistributedObject(String name) {
        this.containers.remove(name);
        this.quorumConfigCache.remove(name);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent partitionMigrationEvent) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        if (event.getReplicaIndex() > 1) {
            return null;
        }
        HashMap<String, Long> data = new HashMap<String, Long>();
        int partitionId = event.getPartitionId();
        for (Map.Entry containerEntry : this.containers.entrySet()) {
            String name = (String)containerEntry.getKey();
            if (partitionId != this.getPartitionId(name)) continue;
            AtomicLongContainer container = (AtomicLongContainer)containerEntry.getValue();
            data.put(name, container.get());
        }
        return data.isEmpty() ? null : new AtomicLongReplicationOperation(data);
    }

    private int getPartitionId(String name) {
        IPartitionService partitionService = this.nodeEngine.getPartitionService();
        String partitionKey = StringPartitioningStrategy.getPartitionKey(name);
        return partitionService.getPartitionId(partitionKey);
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        int thresholdReplicaIndex;
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE && ((thresholdReplicaIndex = event.getNewReplicaIndex()) == -1 || thresholdReplicaIndex > 1)) {
            this.clearPartitionReplica(event.getPartitionId());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        int thresholdReplicaIndex;
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION && ((thresholdReplicaIndex = event.getCurrentReplicaIndex()) == -1 || thresholdReplicaIndex > 1)) {
            this.clearPartitionReplica(event.getPartitionId());
        }
    }

    private void clearPartitionReplica(int partitionId) {
        Iterator iterator = this.containers.keySet().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (this.getPartitionId(name) != partitionId) continue;
            iterator.remove();
        }
    }

    @Override
    public String getQuorumName(String name) {
        if (this.nodeEngine.getClusterService().getClusterVersion().isLessThan(Versions.V3_10)) {
            return null;
        }
        Object quorumName = ConcurrencyUtil.getOrPutSynchronized(this.quorumConfigCache, name, this.quorumConfigCacheMutexFactory, this.quorumConfigConstructor);
        return quorumName == NULL_OBJECT ? null : (String)quorumName;
    }

    @Override
    public Runnable prepareMergeRunnable() {
        IPartitionService partitionService = this.nodeEngine.getPartitionService();
        HashMap<Integer, List<AtomicLongContainer>> containerMap = new HashMap<Integer, List<AtomicLongContainer>>();
        for (Map.Entry entry : this.containers.entrySet()) {
            String name;
            int partitionId;
            AtomicLongContainer container = (AtomicLongContainer)entry.getValue();
            if (this.getMergePolicy(container) instanceof DiscardMergePolicy || !partitionService.isPartitionOwner(partitionId = partitionService.getPartitionId(StringPartitioningStrategy.getPartitionKey(name = (String)entry.getKey())))) continue;
            ArrayList<AtomicLongContainer> containerList = (ArrayList<AtomicLongContainer>)containerMap.get(partitionId);
            if (containerList == null) {
                containerList = new ArrayList<AtomicLongContainer>(this.containers.size());
                containerMap.put(partitionId, containerList);
            }
            containerList.add(container);
        }
        this.containers.clear();
        return new Merger(containerMap);
    }

    private SplitBrainMergePolicy getMergePolicy(AtomicLongContainer container) {
        String mergePolicyName = container.getConfig().getMergePolicyConfig().getPolicy();
        return this.mergePolicyProvider.getMergePolicy(mergePolicyName);
    }

    private class Merger
    implements Runnable {
        private static final long TIMEOUT_FACTOR = 500L;
        private final ILogger logger;
        private final Semaphore semaphore;
        private final ExecutionCallback<Object> mergeCallback;
        private final Map<Integer, List<AtomicLongContainer>> containerMap;

        Merger(Map<Integer, List<AtomicLongContainer>> containerMap) {
            this.logger = AtomicLongService.this.nodeEngine.getLogger(AtomicLongService.class);
            this.semaphore = new Semaphore(0);
            this.mergeCallback = new ExecutionCallback<Object>(){

                @Override
                public void onResponse(Object response) {
                    Merger.this.semaphore.release(1);
                }

                @Override
                public void onFailure(Throwable t) {
                    Merger.this.logger.warning("Error while running AtomicLong merge operation: " + t.getMessage());
                    Merger.this.semaphore.release(1);
                }
            };
            this.containerMap = containerMap;
        }

        @Override
        public void run() {
            if (AtomicLongService.this.nodeEngine.getClusterService().getClusterVersion().isLessThan(Versions.V3_10)) {
                this.logger.info("Cluster needs to run version " + Versions.V3_10 + " to merge AtomicLong instances");
                return;
            }
            int valueCount = 0;
            for (Map.Entry<Integer, List<AtomicLongContainer>> entry : this.containerMap.entrySet()) {
                int partitionId = entry.getKey();
                List<AtomicLongContainer> containerList = entry.getValue();
                for (AtomicLongContainer container : containerList) {
                    String name = container.getName();
                    ++valueCount;
                    MergeOperation operation = new MergeOperation(name, AtomicLongService.this.getMergePolicy(container), container.get());
                    try {
                        AtomicLongService.this.nodeEngine.getOperationService().invokeOnPartition(AtomicLongService.SERVICE_NAME, operation, partitionId).andThen(this.mergeCallback);
                    }
                    catch (Throwable t) {
                        throw ExceptionUtil.rethrow(t);
                    }
                }
            }
            this.containerMap.clear();
            try {
                if (!this.semaphore.tryAcquire(valueCount, (long)valueCount * 500L, TimeUnit.MILLISECONDS)) {
                    this.logger.warning("Split-brain healing for AtomicLong instances didn't finish within the timeout...");
                }
            }
            catch (InterruptedException e) {
                this.logger.finest("Interrupted while waiting for split-brain healing of AtomicLong instances...");
                Thread.currentThread().interrupt();
            }
        }
    }
}

