/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.atomiclong.operations;

import com.hazelcast.concurrent.atomiclong.AtomicLongService;
import com.hazelcast.concurrent.atomiclong.operations.AtomicLongBackupAwareOperation;
import com.hazelcast.concurrent.atomiclong.operations.SetBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.SplitBrainMergePolicy;
import com.hazelcast.spi.impl.merge.MergingHolders;
import com.hazelcast.spi.merge.MergingValueHolder;
import java.io.IOException;

public class MergeOperation
extends AtomicLongBackupAwareOperation {
    private SplitBrainMergePolicy mergePolicy;
    private long mergingValue;
    private transient Long backupValue;

    public MergeOperation() {
    }

    public MergeOperation(String name, SplitBrainMergePolicy mergePolicy, long mergingValue) {
        super(name);
        this.mergePolicy = mergePolicy;
        this.mergingValue = mergingValue;
    }

    @Override
    public void run() throws Exception {
        AtomicLongService service = (AtomicLongService)this.getService();
        boolean isExistingContainer = service.containsAtomicLong(this.name);
        MergingValueHolder<Long> mergingValue = MergingHolders.createMergeHolder(this.mergingValue);
        this.backupValue = this.getLongContainer().merge(mergingValue, this.mergePolicy, isExistingContainer);
    }

    @Override
    public boolean shouldBackup() {
        return this.backupValue != null;
    }

    @Override
    public Operation getBackupOperation() {
        return new SetBackupOperation(this.name, this.backupValue);
    }

    @Override
    public int getId() {
        return 13;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.mergePolicy);
        out.writeLong(this.mergingValue);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mergePolicy = (SplitBrainMergePolicy)in.readObject();
        this.mergingValue = in.readLong();
    }
}

