/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.atomicreference;

import com.hazelcast.config.AtomicReferenceConfig;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.SplitBrainMergePolicy;
import com.hazelcast.spi.impl.merge.MergingHolders;
import com.hazelcast.spi.merge.MergingValueHolder;
import com.hazelcast.spi.serialization.SerializationService;

public class AtomicReferenceContainer {
    private final String name;
    private final AtomicReferenceConfig config;
    private final SerializationService serializationService;
    private Data value;

    public AtomicReferenceContainer(NodeEngine nodeEngine, String name) {
        this.name = name;
        this.config = nodeEngine.getConfig().findAtomicReferenceConfig(name);
        this.serializationService = nodeEngine.getSerializationService();
    }

    public String getName() {
        return this.name;
    }

    public AtomicReferenceConfig getConfig() {
        return this.config;
    }

    public Data get() {
        return this.value;
    }

    public void set(Data value) {
        this.value = value;
    }

    public boolean compareAndSet(Data expect, Data value) {
        if (!this.contains(expect)) {
            return false;
        }
        this.value = value;
        return true;
    }

    public boolean contains(Data expected) {
        if (this.value == null) {
            return expected == null;
        }
        return this.value.equals(expected);
    }

    public Data getAndSet(Data value) {
        Data tempValue = this.value;
        this.value = value;
        return tempValue;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public Data merge(MergingValueHolder<Data> mergingValue, SplitBrainMergePolicy mergePolicy, boolean isExistingContainer) {
        this.serializationService.getManagedContext().initialize(mergePolicy);
        mergingValue.setSerializationService(this.serializationService);
        if (isExistingContainer) {
            MergingValueHolder<Data> existingValue = MergingHolders.createMergeHolder(this.value);
            existingValue.setSerializationService(this.serializationService);
            Data newValue = mergePolicy.merge(mergingValue, existingValue);
            if (newValue != null && !newValue.equals(this.value)) {
                this.value = newValue;
                return newValue;
            }
        } else {
            Data newValue = mergePolicy.merge(mergingValue, null);
            if (newValue != null) {
                this.value = newValue;
                return newValue;
            }
        }
        return null;
    }
}

