/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.networking.nio;

import com.hazelcast.internal.networking.AbstractChannel;
import com.hazelcast.internal.networking.OutboundFrame;
import com.hazelcast.internal.networking.nio.NioInboundPipeline;
import com.hazelcast.internal.networking.nio.NioOutboundPipeline;
import com.hazelcast.nio.IOUtil;
import java.nio.channels.SocketChannel;

public class NioChannel
extends AbstractChannel {
    private NioInboundPipeline inboundPipeline;
    private NioOutboundPipeline outboundPipeline;

    public NioChannel(SocketChannel socketChannel, boolean clientMode) {
        super(socketChannel, clientMode);
    }

    public void setInboundPipeline(NioInboundPipeline inboundPipeline) {
        this.inboundPipeline = inboundPipeline;
    }

    public void setOutboundPipeline(NioOutboundPipeline outboundPipeline) {
        this.outboundPipeline = outboundPipeline;
    }

    public NioInboundPipeline getInboundPipeline() {
        return this.inboundPipeline;
    }

    public NioOutboundPipeline getOutboundPipeline() {
        return this.outboundPipeline;
    }

    @Override
    public boolean write(OutboundFrame frame) {
        if (this.isClosed()) {
            return false;
        }
        this.outboundPipeline.write(frame);
        return true;
    }

    @Override
    public long lastReadTimeMillis() {
        return this.inboundPipeline.lastReadTimeMillis();
    }

    @Override
    public long lastWriteTimeMillis() {
        return this.outboundPipeline.lastWriteTimeMillis();
    }

    @Override
    public void flush() {
        this.outboundPipeline.flush();
    }

    @Override
    protected void onClose() {
        IOUtil.closeResource(this.inboundPipeline);
        IOUtil.closeResource(this.outboundPipeline);
    }

    public String toString() {
        return "NioChannel{" + this.getLocalSocketAddress() + "->" + this.getRemoteSocketAddress() + '}';
    }
}

