/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.map.impl.operation.MergeOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.SplitBrainMergePolicy;
import com.hazelcast.spi.impl.operationservice.impl.operations.PartitionAwareOperationFactory;
import com.hazelcast.spi.merge.MergingEntryHolder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MergeOperationFactory
extends PartitionAwareOperationFactory {
    protected String name;
    protected List<MergingEntryHolder<Data, Data>>[] mergingEntries;
    protected SplitBrainMergePolicy mergePolicy;

    public MergeOperationFactory() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public MergeOperationFactory(String name, int[] partitions, List<MergingEntryHolder<Data, Data>>[] mergingEntries, SplitBrainMergePolicy mergePolicy) {
        this.name = name;
        this.partitions = partitions;
        this.mergingEntries = mergingEntries;
        this.mergePolicy = mergePolicy;
    }

    @Override
    public Operation createPartitionOperation(int partitionId) {
        for (int i = 0; i < this.partitions.length; ++i) {
            if (this.partitions[i] != partitionId) continue;
            return new MergeOperation(this.name, this.mergingEntries[i], this.mergePolicy, false);
        }
        throw new IllegalArgumentException("Unknown partitionId " + partitionId + " (" + Arrays.toString(this.partitions) + ")");
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeIntArray(this.partitions);
        for (List<MergingEntryHolder<Data, Data>> list : this.mergingEntries) {
            out.writeInt(list.size());
            for (MergingEntryHolder<Data, Data> mergingEntry : list) {
                out.writeObject(mergingEntry);
            }
        }
        out.writeObject(this.mergePolicy);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.partitions = in.readIntArray();
        this.mergingEntries = new List[this.partitions.length];
        for (int partitionIndex = 0; partitionIndex < this.partitions.length; ++partitionIndex) {
            int size = in.readInt();
            ArrayList<MergingEntryHolder<Data, Data>> list = new ArrayList<MergingEntryHolder<Data, Data>>(size);
            for (int i = 0; i < size; ++i) {
                MergingEntryHolder mergingEntry = (MergingEntryHolder)in.readObject();
                list.add(mergingEntry);
            }
            this.mergingEntries[partitionIndex] = list;
        }
        this.mergePolicy = (SplitBrainMergePolicy)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 146;
    }
}

