/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor.impl;

import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.monitor.LocalFlakeIdGeneratorStats;
import com.hazelcast.util.Clock;
import com.hazelcast.util.JsonUtil;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class LocalFlakeIdGeneratorStatsImpl
implements LocalFlakeIdGeneratorStats {
    private static final AtomicLongFieldUpdater<LocalFlakeIdGeneratorStatsImpl> USAGE_COUNT = AtomicLongFieldUpdater.newUpdater(LocalFlakeIdGeneratorStatsImpl.class, "usageCount");
    @Probe
    private volatile long creationTime = Clock.currentTimeMillis();
    @Probe
    private volatile long usageCount;

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getUsageCount() {
        return this.usageCount;
    }

    public void incrementUsage() {
        USAGE_COUNT.incrementAndGet(this);
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("creationTime", this.creationTime);
        root.add("usageCount", this.usageCount);
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.creationTime = JsonUtil.getLong(json, "creationTime", -1L);
        this.usageCount = JsonUtil.getLong(json, "usageCount", -1L);
    }

    public String toString() {
        return "LocalFlakeIdStatsImpl{creationTime=" + this.creationTime + ", usageCount=" + this.usageCount + '}';
    }
}

