/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl;

import com.hazelcast.concurrent.lock.LockService;
import com.hazelcast.concurrent.lock.LockStore;
import com.hazelcast.multimap.impl.MultiMapContainerSupport;
import com.hazelcast.multimap.impl.MultiMapMergeContainer;
import com.hazelcast.multimap.impl.MultiMapRecord;
import com.hazelcast.multimap.impl.MultiMapService;
import com.hazelcast.multimap.impl.MultiMapValue;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.DistributedObjectNamespace;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.SplitBrainMergePolicy;
import com.hazelcast.spi.impl.merge.MergingHolders;
import com.hazelcast.spi.merge.MergingEntryHolder;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.MapUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class MultiMapContainer
extends MultiMapContainerSupport {
    private static final int ID_PROMOTION_OFFSET = 100000;
    private final DistributedObjectNamespace lockNamespace;
    private final LockStore lockStore;
    private final int partitionId;
    private final long creationTime;
    private final ObjectNamespace objectNamespace;
    private long idGen;
    private volatile long lastAccessTime;
    private volatile long lastUpdateTime;

    public MultiMapContainer(String name, MultiMapService service, int partitionId) {
        super(name, service.getNodeEngine());
        this.partitionId = partitionId;
        this.lockNamespace = new DistributedObjectNamespace("hz:impl:multiMapService", name);
        LockService lockService = (LockService)this.nodeEngine.getSharedService("hz:impl:lockService");
        this.lockStore = lockService == null ? null : lockService.createLockStore(partitionId, this.lockNamespace);
        this.creationTime = Clock.currentTimeMillis();
        this.objectNamespace = new DistributedObjectNamespace("hz:impl:multiMapService", name);
    }

    public boolean canAcquireLock(Data dataKey, String caller, long threadId) {
        return this.lockStore != null && this.lockStore.canAcquireLock(dataKey, caller, threadId);
    }

    public boolean isLocked(Data dataKey) {
        return this.lockStore != null && this.lockStore.isLocked(dataKey);
    }

    public boolean isTransactionallyLocked(Data key) {
        return this.lockStore != null && this.lockStore.shouldBlockReads(key);
    }

    public boolean txnLock(Data key, String caller, long threadId, long referenceId, long ttl, boolean blockReads) {
        return this.lockStore != null && this.lockStore.txnLock(key, caller, threadId, referenceId, ttl, blockReads);
    }

    public boolean unlock(Data key, String caller, long threadId, long referenceId) {
        return this.lockStore != null && this.lockStore.unlock(key, caller, threadId, referenceId);
    }

    public boolean forceUnlock(Data key) {
        return this.lockStore != null && this.lockStore.forceUnlock(key);
    }

    public boolean extendLock(Data key, String caller, long threadId, long ttl) {
        return this.lockStore != null && this.lockStore.extendLeaseTime(key, caller, threadId, ttl);
    }

    public String getLockOwnerInfo(Data dataKey) {
        return this.lockStore != null ? this.lockStore.getOwnerInfo(dataKey) : null;
    }

    public long nextId() {
        return this.idGen++;
    }

    public void setId(long newValue) {
        this.idGen = newValue + 100000L;
    }

    public void delete(Data dataKey) {
        this.multiMapValues.remove(dataKey);
    }

    public Collection<MultiMapRecord> remove(Data dataKey, boolean copyOf) {
        MultiMapValue multiMapValue = (MultiMapValue)this.multiMapValues.remove(dataKey);
        return multiMapValue != null ? multiMapValue.getCollection(copyOf) : null;
    }

    public Set<Data> keySet() {
        Set keySet = this.multiMapValues.keySet();
        return new HashSet<Data>(keySet);
    }

    public Collection<MultiMapRecord> values() {
        LinkedList<MultiMapRecord> valueCollection = new LinkedList<MultiMapRecord>();
        for (MultiMapValue multiMapValue : this.multiMapValues.values()) {
            valueCollection.addAll(multiMapValue.getCollection(false));
        }
        return valueCollection;
    }

    public boolean containsKey(Data key) {
        return this.multiMapValues.containsKey(key);
    }

    public boolean containsEntry(boolean binary, Data key, Data value) {
        MultiMapValue multiMapValue = (MultiMapValue)this.multiMapValues.get(key);
        if (multiMapValue == null) {
            return false;
        }
        MultiMapRecord record = new MultiMapRecord(binary ? value : this.nodeEngine.toObject(value));
        return multiMapValue.getCollection(false).contains(record);
    }

    public boolean containsValue(boolean binary, Data value) {
        for (Data key : this.multiMapValues.keySet()) {
            if (!this.containsEntry(binary, key, value)) continue;
            return true;
        }
        return false;
    }

    public Map<Data, Collection<MultiMapRecord>> copyCollections() {
        Map<Data, Collection<MultiMapRecord>> map = MapUtil.createHashMap(this.multiMapValues.size());
        for (Map.Entry entry : this.multiMapValues.entrySet()) {
            Data key = (Data)entry.getKey();
            Collection<MultiMapRecord> col = ((MultiMapValue)entry.getValue()).getCollection(true);
            map.put(key, col);
        }
        return map;
    }

    public int size() {
        int size = 0;
        for (MultiMapValue multiMapValue : this.multiMapValues.values()) {
            size += multiMapValue.getCollection(false).size();
        }
        return size;
    }

    public int clear() {
        Set<Data> locks = this.lockStore != null ? this.lockStore.getLockedKeys() : Collections.emptySet();
        Map<Data, MultiMapValue> lockedKeys = MapUtil.createHashMap(locks.size());
        for (Data key : locks) {
            MultiMapValue multiMapValue = (MultiMapValue)this.multiMapValues.get(key);
            if (multiMapValue == null) continue;
            lockedKeys.put(key, multiMapValue);
        }
        int numberOfAffectedEntries = this.multiMapValues.size() - lockedKeys.size();
        this.multiMapValues.clear();
        this.multiMapValues.putAll(lockedKeys);
        return numberOfAffectedEntries;
    }

    public void destroy() {
        LockService lockService = (LockService)this.nodeEngine.getSharedService("hz:impl:lockService");
        if (lockService != null) {
            lockService.clearLockStore(this.partitionId, this.lockNamespace);
        }
        this.multiMapValues.clear();
    }

    public void access() {
        this.lastAccessTime = Clock.currentTimeMillis();
    }

    public void update() {
        this.lastUpdateTime = Clock.currentTimeMillis();
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLockedCount() {
        return this.lockStore.getLockedKeys().size();
    }

    public ObjectNamespace getObjectNamespace() {
        return this.objectNamespace;
    }

    public MultiMapValue merge(MergingEntryHolder<Data, MultiMapMergeContainer> mergingEntry, SplitBrainMergePolicy mergePolicy) {
        SerializationService serializationService = this.nodeEngine.getSerializationService();
        serializationService.getManagedContext().initialize(mergePolicy);
        mergingEntry.setSerializationService(serializationService);
        Data key = mergingEntry.getKey();
        MultiMapMergeContainer mergingContainer = (MultiMapMergeContainer)mergingEntry.getValue();
        MultiMapValue existingValue = this.getMultiMapValueOrNull(key);
        if (existingValue == null) {
            return this.mergeNewValue(serializationService, mergePolicy, key, mergingContainer);
        }
        return this.mergeExistingValue(serializationService, mergePolicy, key, mergingContainer, existingValue);
    }

    private MultiMapValue mergeNewValue(SerializationService ss, SplitBrainMergePolicy mergePolicy, Data key, MultiMapMergeContainer mergingContainer) {
        boolean isBinary = this.getConfig().isBinary();
        MultiMapValue mergedValue = null;
        for (MultiMapRecord mergeRecord : mergingContainer.getRecords()) {
            MergingEntryHolder<Data, Object> mergingEntry = MergingHolders.createMergeHolder(mergingContainer, mergeRecord);
            Object newValue = mergePolicy.merge(mergingEntry, null);
            if (newValue == null) continue;
            MultiMapRecord newRecord = new MultiMapRecord(this.nextId(), isBinary ? newValue : ss.toObject(newValue));
            if (mergedValue == null) {
                mergedValue = this.getOrCreateMultiMapValue(key);
            }
            Collection<MultiMapRecord> collection = mergedValue.getCollection(false);
            collection.add(newRecord);
        }
        return mergedValue;
    }

    private MultiMapValue mergeExistingValue(SerializationService ss, SplitBrainMergePolicy mergePolicy, Data key, MultiMapMergeContainer mergingContainer, MultiMapValue existingValue) {
        boolean isBinary = this.getConfig().isBinary();
        Collection<MultiMapRecord> existingRecords = existingValue.getCollection(false);
        int existingHits = existingValue.getHits();
        for (MultiMapRecord mergeRecord : mergingContainer.getRecords()) {
            MergingEntryHolder<Data, Object> mergingEntry = MergingHolders.createMergeHolder(mergingContainer, mergeRecord);
            MergingEntryHolder<Data, Object> existingEntry = null;
            MultiMapRecord existingRecord = null;
            for (MultiMapRecord record : existingRecords) {
                if (!record.getObject().equals(mergeRecord.getObject())) continue;
                existingEntry = MergingHolders.createMergeHolder(this, key, record, existingHits);
                existingEntry.setSerializationService(ss);
                existingRecord = record;
            }
            Object newValue = mergePolicy.merge(mergingEntry, existingEntry);
            if (newValue == null || existingRecord != null && newValue.equals(existingRecord.getObject())) continue;
            MultiMapRecord newRecord = new MultiMapRecord(this.nextId(), isBinary ? newValue : ss.toObject(newValue));
            existingRecords.remove(existingRecord);
            existingRecords.add(newRecord);
        }
        return existingValue;
    }
}

