/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.operations;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.multimap.impl.MultiMapContainer;
import com.hazelcast.multimap.impl.MultiMapMergeContainer;
import com.hazelcast.multimap.impl.MultiMapRecord;
import com.hazelcast.multimap.impl.MultiMapValue;
import com.hazelcast.multimap.impl.operations.MergeBackupOperation;
import com.hazelcast.multimap.impl.operations.MultiMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.SplitBrainMergePolicy;
import com.hazelcast.spi.impl.merge.MergingHolders;
import com.hazelcast.spi.merge.MergingEntryHolder;
import com.hazelcast.util.MapUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class MergeOperation
extends MultiMapOperation
implements BackupAwareOperation {
    private List<MultiMapMergeContainer> mergingData;
    private SplitBrainMergePolicy mergePolicy;
    private transient Map<Data, Collection<MultiMapRecord>> resultMap;

    public MergeOperation() {
    }

    public MergeOperation(String name, List<MultiMapMergeContainer> mergingData, SplitBrainMergePolicy mergePolicy) {
        super(name);
        this.mergingData = mergingData;
        this.mergePolicy = mergePolicy;
    }

    @Override
    public void run() throws Exception {
        MultiMapContainer container = this.getOrCreateContainer();
        this.resultMap = MapUtil.createHashMap(this.mergingData.size());
        for (MultiMapMergeContainer mergeContainer : this.mergingData) {
            Data key = mergeContainer.getKey();
            if (!container.canAcquireLock(key, this.getCallerUuid(), -1L)) {
                Object valueKey = this.getNodeEngine().getSerializationService().toObject(key);
                this.getLogger().info("Skipped merging of locked key '" + valueKey + "' on MultiMap '" + this.name + "'");
                continue;
            }
            MergingEntryHolder<Data, MultiMapMergeContainer> dataHolder = MergingHolders.createMergeHolder(key, mergeContainer);
            MultiMapValue result = container.merge(dataHolder, this.mergePolicy);
            if (result == null) continue;
            this.resultMap.put(key, result.getCollection(false));
            this.publishEvent(EntryEventType.MERGED, key, result, null);
        }
        this.response = !this.resultMap.isEmpty();
    }

    @Override
    public Operation getBackupOperation() {
        return new MergeBackupOperation(this.name, this.resultMap);
    }

    @Override
    public boolean shouldBackup() {
        return !this.resultMap.isEmpty();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.mergingData.size());
        for (MultiMapMergeContainer container : this.mergingData) {
            out.writeObject(container);
        }
        out.writeObject(this.mergePolicy);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.mergingData = new ArrayList<MultiMapMergeContainer>(size);
        for (int i = 0; i < size; ++i) {
            MultiMapMergeContainer container = (MultiMapMergeContainer)in.readObject();
            this.mergingData.add(container);
        }
        this.mergePolicy = (SplitBrainMergePolicy)in.readObject();
    }

    @Override
    public int getId() {
        return 49;
    }
}

