/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ringbuffer.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.config.ConfigValidator;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.quorum.QuorumService;
import com.hazelcast.quorum.QuorumType;
import com.hazelcast.ringbuffer.impl.Ringbuffer;
import com.hazelcast.ringbuffer.impl.RingbufferContainer;
import com.hazelcast.ringbuffer.impl.RingbufferProxy;
import com.hazelcast.ringbuffer.impl.operations.MergeOperation;
import com.hazelcast.ringbuffer.impl.operations.ReplicationOperation;
import com.hazelcast.spi.DistributedObjectNamespace;
import com.hazelcast.spi.FragmentedMigrationAwareService;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.QuorumAwareService;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.spi.ServiceNamespace;
import com.hazelcast.spi.SplitBrainHandlerService;
import com.hazelcast.spi.SplitBrainMergePolicy;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.merge.MergingHolders;
import com.hazelcast.spi.merge.DiscardMergePolicy;
import com.hazelcast.spi.merge.MergingEntryHolder;
import com.hazelcast.spi.merge.MergingValueHolder;
import com.hazelcast.spi.merge.SplitBrainMergePolicyProvider;
import com.hazelcast.spi.partition.IPartitionService;
import com.hazelcast.spi.partition.MigrationEndpoint;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.ContextMutexFactory;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.MapUtil;
import com.hazelcast.util.Preconditions;
import com.hazelcast.version.Version;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class RingbufferService
implements ManagedService,
RemoteService,
FragmentedMigrationAwareService,
QuorumAwareService,
SplitBrainHandlerService {
    public static final String TOPIC_RB_PREFIX = "_hz_rb_";
    public static final String SERVICE_NAME = "hz:impl:ringbufferService";
    private static final Object NULL_OBJECT = new Object();
    private final ConcurrentMap<Integer, Map<ObjectNamespace, RingbufferContainer>> containers = new ConcurrentHashMap<Integer, Map<ObjectNamespace, RingbufferContainer>>();
    private final ConcurrentMap<String, Object> quorumConfigCache = new ConcurrentHashMap<String, Object>();
    private final ContextMutexFactory quorumConfigCacheMutexFactory = new ContextMutexFactory();
    private final ConstructorFunction<String, Object> quorumConfigConstructor = new ConstructorFunction<String, Object>(){

        @Override
        public Object createNew(String name) {
            RingbufferConfig config = RingbufferService.this.nodeEngine.getConfig().findRingbufferConfig(name);
            String quorumName = config.getQuorumName();
            return quorumName == null ? NULL_OBJECT : quorumName;
        }
    };
    private NodeEngine nodeEngine;
    private SerializationService serializationService;
    private IPartitionService partitionService;
    private QuorumService quorumService;
    private SplitBrainMergePolicyProvider mergePolicyProvider;

    public RingbufferService(NodeEngineImpl nodeEngine) {
        this.init(nodeEngine, null);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.nodeEngine = Preconditions.checkNotNull(nodeEngine, "nodeEngine can't be null");
        this.serializationService = nodeEngine.getSerializationService();
        this.partitionService = nodeEngine.getPartitionService();
        this.quorumService = nodeEngine.getQuorumService();
        this.mergePolicyProvider = nodeEngine.getSplitBrainMergePolicyProvider();
    }

    public ConcurrentMap<Integer, Map<ObjectNamespace, RingbufferContainer>> getContainers() {
        return this.containers;
    }

    @Override
    public DistributedObject createDistributedObject(String objectName) {
        RingbufferConfig ringbufferConfig = this.getRingbufferConfig(objectName);
        ConfigValidator.checkRingbufferConfig(ringbufferConfig);
        return new RingbufferProxy(this.nodeEngine, this, objectName, ringbufferConfig);
    }

    @Override
    public void destroyDistributedObject(String name) {
        this.destroyContainer(this.getRingbufferPartitionId(name), RingbufferService.getRingbufferNamespace(name));
        this.nodeEngine.getEventService().deregisterAllListeners(SERVICE_NAME, name);
        this.quorumConfigCache.remove(name);
    }

    public void destroyContainer(int partitionId, ObjectNamespace namespace) {
        Map partitionContainers = (Map)this.containers.get(partitionId);
        if (partitionContainers == null) {
            return;
        }
        partitionContainers.remove(namespace);
    }

    @Override
    public void reset() {
        this.containers.clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    public <T, E> RingbufferContainer<T, E> getOrCreateContainer(int partitionId, ObjectNamespace namespace, RingbufferConfig config) {
        if (config == null) {
            throw new NullPointerException("Ringbuffer config should not be null when ringbuffer is being created");
        }
        Version clusterVersion = this.nodeEngine.getClusterService().getClusterVersion();
        if (clusterVersion.isLessThan(Versions.V3_9) && !SERVICE_NAME.equals(namespace.getServiceName())) {
            throw new UnsupportedOperationException("Ringbuffer containers for service " + namespace.getServiceName() + " are not supported when cluster version is " + clusterVersion);
        }
        Map<ObjectNamespace, RingbufferContainer> partitionContainers = this.getOrCreateRingbufferContainers(partitionId);
        RingbufferContainer ringbuffer = partitionContainers.get(namespace);
        if (ringbuffer != null) {
            return ringbuffer;
        }
        ringbuffer = new RingbufferContainer(namespace, config, this.nodeEngine, partitionId);
        ringbuffer.getStore().instrument(this.nodeEngine);
        partitionContainers.put(namespace, ringbuffer);
        return ringbuffer;
    }

    public <T, E> RingbufferContainer<T, E> getContainerOrNull(int partitionId, ObjectNamespace namespace) {
        Map partitionContainers = (Map)this.containers.get(partitionId);
        return partitionContainers != null ? (RingbufferContainer)partitionContainers.get(namespace) : null;
    }

    private Map<ObjectNamespace, RingbufferContainer> getOrCreateRingbufferContainers(int partitionId) {
        Map partitionContainer = (Map)this.containers.get(partitionId);
        if (partitionContainer == null) {
            this.containers.putIfAbsent(partitionId, new HashMap());
        }
        return (Map)this.containers.get(partitionId);
    }

    public RingbufferConfig getRingbufferConfig(String name) {
        Config config = this.nodeEngine.getConfig();
        return config.findRingbufferConfig(RingbufferService.getConfigName(name));
    }

    public static ObjectNamespace getRingbufferNamespace(String name) {
        return new DistributedObjectNamespace(SERVICE_NAME, name);
    }

    public int getRingbufferPartitionId(String ringbufferName) {
        Object partitionAwareData = this.serializationService.toData(ringbufferName, StringPartitioningStrategy.INSTANCE);
        return this.partitionService.getPartitionId((Data)partitionAwareData);
    }

    public void addRingbuffer(int partitionId, RingbufferContainer ringbuffer, RingbufferConfig config) {
        Preconditions.checkNotNull(ringbuffer, "ringbuffer can't be null");
        ringbuffer.init(config, this.nodeEngine);
        ringbuffer.getStore().instrument(this.nodeEngine);
        this.getOrCreateRingbufferContainers(partitionId).put(ringbuffer.getNamespace(), ringbuffer);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent partitionMigrationEvent) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        return this.prepareReplicationOperation(event, this.getAllServiceNamespaces(event));
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        int partitionId = event.getPartitionId();
        Map partitionContainers = (Map)this.containers.get(partitionId);
        if (MapUtil.isNullOrEmpty(partitionContainers)) {
            return null;
        }
        HashMap<ObjectNamespace, RingbufferContainer> migrationData = new HashMap<ObjectNamespace, RingbufferContainer>();
        for (ServiceNamespace namespace : namespaces) {
            ObjectNamespace ns = (ObjectNamespace)namespace;
            RingbufferContainer container = (RingbufferContainer)partitionContainers.get(ns);
            if (container == null || container.getConfig().getTotalBackupCount() < event.getReplicaIndex()) continue;
            migrationData.put(ns, container);
        }
        if (migrationData.isEmpty()) {
            return null;
        }
        return new ReplicationOperation(migrationData, event.getPartitionId(), event.getReplicaIndex());
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearRingbuffersHavingLesserBackupCountThan(event.getPartitionId(), event.getNewReplicaIndex());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearRingbuffersHavingLesserBackupCountThan(event.getPartitionId(), event.getCurrentReplicaIndex());
        }
    }

    private void clearRingbuffersHavingLesserBackupCountThan(int partitionId, int thresholdReplicaIndex) {
        Map partitionContainers = (Map)this.containers.get(partitionId);
        if (partitionContainers == null || partitionContainers.isEmpty()) {
            return;
        }
        Iterator iterator = partitionContainers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            RingbufferContainer container = (RingbufferContainer)entry.getValue();
            if (thresholdReplicaIndex >= 0 && container.getConfig().getTotalBackupCount() >= thresholdReplicaIndex) continue;
            iterator.remove();
        }
    }

    @Override
    public Collection<ServiceNamespace> getAllServiceNamespaces(PartitionReplicationEvent event) {
        int partitionId = event.getPartitionId();
        Map partitionContainers = (Map)this.containers.get(partitionId);
        if (partitionContainers == null || partitionContainers.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<ServiceNamespace> namespaces = new HashSet<ServiceNamespace>();
        for (RingbufferContainer container : partitionContainers.values()) {
            if (container.getConfig().getTotalBackupCount() < event.getReplicaIndex()) continue;
            namespaces.add(container.getNamespace());
        }
        return namespaces;
    }

    @Override
    public boolean isKnownServiceNamespace(ServiceNamespace namespace) {
        return namespace instanceof ObjectNamespace;
    }

    @Override
    public String getQuorumName(String name) {
        if (this.nodeEngine.getClusterService().getClusterVersion().isLessThan(Versions.V3_10)) {
            return null;
        }
        Object quorumName = ConcurrencyUtil.getOrPutSynchronized(this.quorumConfigCache, name, this.quorumConfigCacheMutexFactory, this.quorumConfigConstructor);
        return quorumName == NULL_OBJECT ? null : (String)quorumName;
    }

    public void ensureQuorumPresent(String distributedObjectName, QuorumType requiredQuorumPermissionType) {
        this.quorumService.ensureQuorumPresent(this.getQuorumName(distributedObjectName), requiredQuorumPermissionType);
    }

    @Override
    public Runnable prepareMergeRunnable() {
        Map<Integer, List<RingbufferContainer>> partitionContainerMap = MapUtil.createHashMap(this.containers.size());
        for (Map.Entry entry : this.containers.entrySet()) {
            int partitionId = (Integer)entry.getKey();
            if (!this.partitionService.isPartitionOwner(partitionId)) continue;
            List<RingbufferContainer> containerList = partitionContainerMap.get(partitionId);
            if (containerList == null) {
                containerList = new LinkedList<RingbufferContainer>();
                partitionContainerMap.put(partitionId, containerList);
            }
            for (RingbufferContainer container : ((Map)entry.getValue()).values()) {
                String serviceName = container.getNamespace().getServiceName();
                if (SERVICE_NAME.equals(serviceName) && !(this.getMergePolicy(container) instanceof DiscardMergePolicy)) {
                    containerList.add(container);
                }
                container.cleanup();
            }
        }
        this.reset();
        return new Merger(partitionContainerMap);
    }

    private SplitBrainMergePolicy getMergePolicy(RingbufferContainer container) {
        String mergePolicyName = container.getConfig().getMergePolicyConfig().getPolicy();
        return this.mergePolicyProvider.getMergePolicy(mergePolicyName);
    }

    private static String getConfigName(String name) {
        if (name.startsWith(TOPIC_RB_PREFIX)) {
            name = name.substring(TOPIC_RB_PREFIX.length());
        }
        return name;
    }

    private class Merger
    implements Runnable {
        private static final long TIMEOUT_FACTOR = 500L;
        private final ILogger logger;
        private final Semaphore semaphore;
        private final ExecutionCallback<Object> mergeCallback;
        private final Map<Integer, List<RingbufferContainer>> partitionContainerMap;

        Merger(Map<Integer, List<RingbufferContainer>> partitionContainerMap) {
            this.logger = RingbufferService.this.nodeEngine.getLogger(RingbufferService.class);
            this.semaphore = new Semaphore(0);
            this.mergeCallback = new ExecutionCallback<Object>(){

                @Override
                public void onResponse(Object response) {
                    Merger.this.semaphore.release(1);
                }

                @Override
                public void onFailure(Throwable t) {
                    Merger.this.logger.warning("Error while running ringbuffer merge operation: " + t.getMessage());
                    Merger.this.semaphore.release(1);
                }
            };
            this.partitionContainerMap = partitionContainerMap;
        }

        @Override
        public void run() {
            if (RingbufferService.this.nodeEngine.getClusterService().getClusterVersion().isLessThan(Versions.V3_10)) {
                this.logger.info("Cluster needs to run version " + Versions.V3_10 + " to merge ringbuffer instances");
                return;
            }
            int itemCount = 0;
            int operationCount = 0;
            for (Map.Entry<Integer, List<RingbufferContainer>> entry : this.partitionContainerMap.entrySet()) {
                int partitionId = entry.getKey();
                List<RingbufferContainer> containerList = entry.getValue();
                for (RingbufferContainer container : containerList) {
                    Ringbuffer ringbuffer = container.getRingbuffer();
                    int batchSize = container.getConfig().getMergePolicyConfig().getBatchSize();
                    SplitBrainMergePolicy mergePolicy = RingbufferService.this.getMergePolicy(container);
                    ArrayList<MergingValueHolder<Object>> mergingValues = new ArrayList<MergingValueHolder<Object>>(batchSize);
                    for (long sequence = ringbuffer.headSequence(); sequence <= ringbuffer.tailSequence(); ++sequence) {
                        Object item = ringbuffer.read(sequence);
                        MergingEntryHolder mergingValue = MergingHolders.createMergeHolder(sequence, item);
                        mergingValues.add(mergingValue);
                        ++itemCount;
                        if (mergingValues.size() != batchSize) continue;
                        this.sendBatch(partitionId, container.getNamespace(), mergePolicy, mergingValues, this.mergeCallback);
                        mergingValues = new ArrayList(batchSize);
                        ++operationCount;
                    }
                    if (mergingValues.size() <= 0) continue;
                    this.sendBatch(partitionId, container.getNamespace(), mergePolicy, mergingValues, this.mergeCallback);
                    ++operationCount;
                }
            }
            this.partitionContainerMap.clear();
            try {
                if (!this.semaphore.tryAcquire(operationCount, (long)itemCount * 500L, TimeUnit.MILLISECONDS)) {
                    this.logger.warning("Split-brain healing for ringbuffers didn't finish within the timeout...");
                }
            }
            catch (InterruptedException e) {
                this.logger.finest("Interrupted while waiting for split-brain healing of ringbuffers...");
                Thread.currentThread().interrupt();
            }
        }

        private void sendBatch(int partitionId, ObjectNamespace namespace, SplitBrainMergePolicy mergePolicy, List<MergingValueHolder<Object>> mergingValues, ExecutionCallback<Object> mergeCallback) {
            MergeOperation operation = new MergeOperation(namespace, mergePolicy, mergingValues);
            try {
                RingbufferService.this.nodeEngine.getOperationService().invokeOnPartition(RingbufferService.SERVICE_NAME, operation, partitionId).andThen(mergeCallback);
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        }
    }
}

