/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.listener.AbstractClientListenerService;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.util.concurrent.MPSCQueue;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.impl.operationservice.impl.AsyncInboundResponseHandler;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public abstract class AbstractClientInvocationService
implements ClientInvocationService {
    private static final HazelcastProperty IDLE_STRATEGY = new HazelcastProperty("hazelcast.client.responsequeue.idlestrategy", "block");
    private static final HazelcastProperty CLEAN_RESOURCES_MILLIS = new HazelcastProperty("hazelcast.client.internal.clean.resources.millis", 100, TimeUnit.MILLISECONDS);
    protected final HazelcastClientInstanceImpl client;
    protected final ILogger invocationLogger;
    protected ClientConnectionManager connectionManager;
    protected ClientPartitionService partitionService;
    private AbstractClientListenerService clientListenerService;
    @Probe(name="pendingCalls", level=ProbeLevel.MANDATORY)
    private ConcurrentMap<Long, ClientInvocation> invocations = new ConcurrentHashMap<Long, ClientInvocation>();
    private ResponseThread responseThread;
    private volatile boolean isShutdown;
    private final long invocationTimeoutMillis;
    private final long invocationRetryPauseMillis;

    public AbstractClientInvocationService(HazelcastClientInstanceImpl client) {
        this.client = client;
        this.invocationLogger = client.getLoggingService().getLogger(ClientInvocationService.class);
        this.invocationTimeoutMillis = this.initInvocationTimeoutMillis();
        this.invocationRetryPauseMillis = this.initInvocationRetryPauseMillis();
        client.getMetricsRegistry().scanAndRegister(this, "invocations");
    }

    private long initInvocationRetryPauseMillis() {
        long pauseTime = this.client.getProperties().getMillis(ClientProperty.INVOCATION_RETRY_PAUSE_MILLIS);
        return pauseTime > 0L ? pauseTime : Long.parseLong(ClientProperty.INVOCATION_RETRY_PAUSE_MILLIS.getDefaultValue());
    }

    private long initInvocationTimeoutMillis() {
        long waitTime = this.client.getProperties().getMillis(ClientProperty.INVOCATION_TIMEOUT_SECONDS);
        return waitTime > 0L ? waitTime : (long)Integer.parseInt(ClientProperty.INVOCATION_TIMEOUT_SECONDS.getDefaultValue());
    }

    public void start() {
        this.connectionManager = this.client.getConnectionManager();
        this.clientListenerService = (AbstractClientListenerService)this.client.getListenerService();
        this.partitionService = this.client.getClientPartitionService();
        ClassLoader classLoader = this.client.getClientConfig().getClassLoader();
        this.responseThread = new ResponseThread(this.client.getName() + ".response-", classLoader);
        this.responseThread.start();
        ClientExecutionService executionService = this.client.getClientExecutionService();
        long cleanResourcesMillis = this.client.getProperties().getMillis(CLEAN_RESOURCES_MILLIS);
        if (cleanResourcesMillis <= 0L) {
            cleanResourcesMillis = Integer.parseInt(CLEAN_RESOURCES_MILLIS.getDefaultValue());
        }
        executionService.scheduleWithRepetition(new CleanResourcesTask(), cleanResourcesMillis, cleanResourcesMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean isRedoOperation() {
        return this.client.getClientConfig().getNetworkConfig().isRedoOperation();
    }

    protected void send(ClientInvocation invocation, ClientConnection connection) throws IOException {
        if (this.isShutdown) {
            throw new HazelcastClientNotActiveException("Client is shut down");
        }
        this.registerInvocation(invocation);
        ClientMessage clientMessage = invocation.getClientMessage();
        if (!this.isAllowedToSendRequest(connection, invocation) || !this.writeToConnection(connection, clientMessage)) {
            long callId = clientMessage.getCorrelationId();
            ClientInvocation clientInvocation = this.deRegisterCallId(callId);
            if (clientInvocation != null) {
                throw new IOException("Packet not sent to " + connection.getEndPoint());
            }
            if (this.invocationLogger.isFinestEnabled()) {
                this.invocationLogger.finest("Invocation not found to deregister for call ID " + callId);
            }
            return;
        }
        invocation.setSendConnection(connection);
    }

    private boolean writeToConnection(ClientConnection connection, ClientMessage clientMessage) {
        clientMessage.addFlag((short)192);
        return connection.write(clientMessage);
    }

    private boolean isAllowedToSendRequest(ClientConnection connection, ClientInvocation invocation) {
        if (!connection.isHeartBeating()) {
            if (invocation.shouldBypassHeartbeatCheck()) {
                return true;
            }
            if (this.invocationLogger.isFinestEnabled()) {
                this.invocationLogger.finest("Connection is not heart-beating, won't write client message -> " + invocation.getClientMessage());
            }
            return false;
        }
        return true;
    }

    private void registerInvocation(ClientInvocation clientInvocation) {
        short protocolVersion = this.client.getProtocolVersion();
        ClientMessage clientMessage = clientInvocation.getClientMessage();
        clientMessage.setVersion(protocolVersion);
        long correlationId = clientMessage.getCorrelationId();
        this.invocations.put(correlationId, clientInvocation);
        EventHandler handler = clientInvocation.getEventHandler();
        if (handler != null) {
            this.clientListenerService.addEventHandler(correlationId, handler);
        }
    }

    private ClientInvocation deRegisterCallId(long callId) {
        return (ClientInvocation)this.invocations.remove(callId);
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public void shutdown() {
        this.isShutdown = true;
        this.responseThread.interrupt();
        Iterator iterator = this.invocations.values().iterator();
        while (iterator.hasNext()) {
            ClientInvocation invocation = (ClientInvocation)iterator.next();
            iterator.remove();
            invocation.notifyException(new HazelcastClientNotActiveException("Client is shutting down"));
        }
    }

    @Override
    public void handleClientMessage(ClientMessage message, Connection connection) {
        this.responseThread.responseQueue.add(new ClientPacket((ClientConnection)connection, message));
    }

    public long getInvocationTimeoutMillis() {
        return this.invocationTimeoutMillis;
    }

    public long getInvocationRetryPauseMillis() {
        return this.invocationRetryPauseMillis;
    }

    private class ResponseThread
    extends Thread {
        private final BlockingQueue<ClientPacket> responseQueue;

        ResponseThread(String name, ClassLoader classLoader) {
            super(name);
            this.setContextClassLoader(classLoader);
            this.responseQueue = new MPSCQueue<ClientPacket>(this, AsyncInboundResponseHandler.getIdleStrategy(AbstractClientInvocationService.this.client.getProperties(), IDLE_STRATEGY));
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (OutOfMemoryError e) {
                OutOfMemoryErrorDispatcher.onOutOfMemory(e);
            }
            catch (Throwable t) {
                AbstractClientInvocationService.this.invocationLogger.severe(t);
            }
        }

        private void doRun() {
            while (!AbstractClientInvocationService.this.isShutdown) {
                ClientPacket task;
                try {
                    task = this.responseQueue.take();
                }
                catch (InterruptedException e) {
                    continue;
                }
                this.process(task);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void process(ClientPacket packet) {
            ClientConnection conn = packet.getClientConnection();
            try {
                this.handleClientMessage(packet.getClientMessage());
            }
            catch (Exception e) {
                AbstractClientInvocationService.this.invocationLogger.severe("Failed to process task: " + packet + " on responseThread: " + this.getName(), e);
            }
            finally {
                conn.decrementPendingPacketCount();
            }
        }

        private void handleClientMessage(ClientMessage clientMessage) {
            long correlationId = clientMessage.getCorrelationId();
            ClientInvocation future = AbstractClientInvocationService.this.deRegisterCallId(correlationId);
            if (future == null) {
                AbstractClientInvocationService.this.invocationLogger.warning("No call for callId: " + correlationId + ", response: " + clientMessage);
                return;
            }
            if (109 == clientMessage.getMessageType()) {
                Throwable exception = AbstractClientInvocationService.this.client.getClientExceptionFactory().createException(clientMessage);
                future.notifyException(exception);
            } else {
                future.notify(clientMessage);
            }
        }
    }

    private static class ClientPacket {
        private final ClientConnection clientConnection;
        private final ClientMessage clientMessage;

        ClientPacket(ClientConnection clientConnection, ClientMessage clientMessage) {
            this.clientConnection = clientConnection;
            this.clientMessage = clientMessage;
        }

        private ClientConnection getClientConnection() {
            return this.clientConnection;
        }

        private ClientMessage getClientMessage() {
            return this.clientMessage;
        }
    }

    private class CleanResourcesTask
    implements Runnable {
        private CleanResourcesTask() {
        }

        @Override
        public void run() {
            Iterator iter = AbstractClientInvocationService.this.invocations.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                ClientInvocation invocation = (ClientInvocation)entry.getValue();
                ClientConnection connection = invocation.getSendConnection();
                if (connection == null || connection.isHeartBeating()) continue;
                iter.remove();
                this.notifyException(invocation, connection);
            }
        }

        private void notifyException(ClientInvocation invocation, ClientConnection connection) {
            TargetDisconnectedException ex = !connection.isAlive() ? new TargetDisconnectedException(connection.getCloseReason(), connection.getCloseCause()) : new TargetDisconnectedException("Heartbeat timed out to " + connection);
            invocation.notifyException(ex);
        }
    }
}

