/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.atomicreference;

import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.merge.MergingValueFactory;
import com.hazelcast.spi.merge.MergingValue;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.serialization.SerializationService;

public class AtomicReferenceContainer {
    private Data value;

    public Data get() {
        return this.value;
    }

    public void set(Data value) {
        this.value = value;
    }

    public boolean compareAndSet(Data expect, Data value) {
        if (!this.contains(expect)) {
            return false;
        }
        this.value = value;
        return true;
    }

    public boolean contains(Data expected) {
        if (this.value == null) {
            return expected == null;
        }
        return this.value.equals(expected);
    }

    public Data getAndSet(Data value) {
        Data tempValue = this.value;
        this.value = value;
        return tempValue;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public Data merge(MergingValue<Data> mergingValue, SplitBrainMergePolicy mergePolicy, boolean isExistingContainer, SerializationService serializationService) {
        serializationService.getManagedContext().initialize(mergingValue);
        serializationService.getManagedContext().initialize(mergePolicy);
        if (isExistingContainer) {
            MergingValue<Data> existingValue = MergingValueFactory.createMergingValue(serializationService, this.value);
            Data newValue = mergePolicy.merge(mergingValue, existingValue);
            if (newValue != null && !newValue.equals(this.value)) {
                this.value = newValue;
                return newValue;
            }
        } else {
            Data newValue = mergePolicy.merge(mergingValue, null);
            if (newValue != null) {
                this.value = newValue;
                return newValue;
            }
        }
        return null;
    }
}

