/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.cluster.impl.TcpIpJoiner;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.instance.AddressPicker;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.util.AddressUtil;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.MapUtil;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class DefaultAddressPicker
implements AddressPicker {
    static final String PREFER_IPV4_STACK = "java.net.preferIPv4Stack";
    private static final int SOCKET_BACKLOG_LENGTH = 100;
    private static final int SOCKET_TIMEOUT_MILLIS = (int)TimeUnit.SECONDS.toMillis(1L);
    private final ILogger logger;
    private final HazelcastProperties hazelcastProperties;
    private final Config config;
    private ServerSocketChannel serverSocketChannel;
    private Address publicAddress;
    private Address bindAddress;

    DefaultAddressPicker(Config config, HazelcastProperties hazelcastProperties, ILogger logger) {
        this.config = config;
        this.hazelcastProperties = hazelcastProperties;
        this.logger = logger;
    }

    @Override
    public void pickAddress() throws Exception {
        if (this.publicAddress != null || this.bindAddress != null) {
            return;
        }
        try {
            AddressDefinition publicAddressDef = this.getPublicAddressByPortSearch();
            if (publicAddressDef != null) {
                this.publicAddress = DefaultAddressPicker.createAddress(publicAddressDef, publicAddressDef.port);
                this.logger.info("Using public address: " + this.publicAddress);
            } else {
                this.publicAddress = this.bindAddress;
                this.logger.finest("Using public address the same as the bind address: " + this.publicAddress);
            }
        }
        catch (Exception e) {
            if (this.serverSocketChannel != null) {
                this.serverSocketChannel.close();
            }
            this.logger.severe(e);
            throw e;
        }
    }

    private AddressDefinition getPublicAddressByPortSearch() throws IOException {
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        boolean bindAny = this.hazelcastProperties.getBoolean(GroupProperty.SOCKET_SERVER_BIND_ANY);
        Exception error = null;
        ServerSocket serverSocket = null;
        boolean reuseAddress = networkConfig.isReuseAddress();
        this.logger.finest("inet reuseAddress:" + reuseAddress);
        int port = networkConfig.getPort();
        int portTrialCount = port > 0 && networkConfig.isPortAutoIncrement() ? networkConfig.getPortCount() : 1;
        AddressDefinition bindAddressDef = this.pickAddressDef();
        if (port == 0) {
            this.logger.info("No explicit port is given, system will pick up an ephemeral port.");
        }
        for (int i = 0; i < portTrialCount; ++i) {
            this.serverSocketChannel = ServerSocketChannel.open();
            serverSocket = this.serverSocketChannel.socket();
            serverSocket.setReuseAddress(reuseAddress);
            serverSocket.setSoTimeout(SOCKET_TIMEOUT_MILLIS);
            try {
                InetSocketAddress inetSocketAddress = bindAny ? new InetSocketAddress(port + i) : new InetSocketAddress(bindAddressDef.inetAddress, port + i);
                this.logger.fine("Trying to bind inet socket address: " + inetSocketAddress);
                serverSocket.bind(inetSocketAddress, 100);
                this.logger.fine("Bind successful to inet socket address: " + serverSocket.getLocalSocketAddress());
                break;
            }
            catch (Exception e) {
                serverSocket.close();
                this.serverSocketChannel.close();
                error = e;
                continue;
            }
        }
        if (serverSocket == null || !serverSocket.isBound()) {
            String message = networkConfig.isPortAutoIncrement() ? "ServerSocket bind has failed. Hazelcast cannot start. config-port: " + networkConfig.getPort() + ", latest-port: " + (port + portTrialCount - 1) : "Port [" + port + "] is already in use and auto-increment is disabled." + " Hazelcast cannot start.";
            throw new HazelcastException(message, error);
        }
        port = serverSocket.getLocalPort();
        this.serverSocketChannel.configureBlocking(false);
        this.bindAddress = DefaultAddressPicker.createAddress(bindAddressDef, port);
        this.logger.info("Picked " + this.bindAddress + ", using socket " + serverSocket + ", bind any local is " + bindAny);
        return this.getPublicAddress(port);
    }

    private static Address createAddress(AddressDefinition addressDef, int port) throws UnknownHostException {
        if (addressDef.host == null) {
            return new Address(addressDef.inetAddress, port);
        }
        return new Address(addressDef.host, port);
    }

    private AddressDefinition pickAddressDef() throws UnknownHostException, SocketException {
        AddressDefinition addressDef = this.getSystemConfiguredAddress();
        if (addressDef == null) {
            addressDef = this.pickInterfaceAddressDef();
        }
        if (addressDef != null) {
            addressDef.inetAddress = AddressUtil.fixScopeIdAndGetInetAddress(addressDef.inetAddress);
        }
        if (addressDef == null) {
            addressDef = DefaultAddressPicker.pickLoopbackAddress();
        }
        return addressDef;
    }

    private AddressDefinition pickInterfaceAddressDef() throws UnknownHostException, SocketException {
        AddressDefinition addressDef;
        Collection<InterfaceDefinition> interfaces = this.getInterfaces();
        if (interfaces.contains(new InterfaceDefinition("127.0.0.1")) || interfaces.contains(new InterfaceDefinition("localhost"))) {
            return DefaultAddressPicker.pickLoopbackAddress();
        }
        if (this.preferIPv4Stack()) {
            this.logger.info("Prefer IPv4 stack is true.");
        }
        if (interfaces.size() > 0 && (addressDef = this.pickMatchingAddress(interfaces)) != null) {
            return addressDef;
        }
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        if (networkConfig.getInterfaces().isEnabled()) {
            String msg = "Hazelcast CANNOT start on this node. No matching network interface found.\nInterface matching must be either disabled or updated in the hazelcast.xml config file.";
            this.logger.severe(msg);
            throw new RuntimeException(msg);
        }
        if (networkConfig.getJoin().getTcpIpConfig().isEnabled()) {
            this.logger.warning("Could not find a matching address to start with! Picking one of non-loopback addresses.");
        }
        return this.pickMatchingAddress(null);
    }

    private Collection<InterfaceDefinition> getInterfaces() {
        Map<String, String> addressDomainMap;
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        TcpIpConfig tcpIpConfig = networkConfig.getJoin().getTcpIpConfig();
        if (tcpIpConfig.isEnabled()) {
            Collection<String> possibleAddresses = TcpIpJoiner.getConfigurationMembers(this.config);
            addressDomainMap = MapUtil.createLinkedHashMap(possibleAddresses.size());
            for (String string : possibleAddresses) {
                String addressHolder = AddressUtil.getAddressHolder(string).getAddress();
                if (AddressUtil.isIpAddress(addressHolder)) {
                    if (addressDomainMap.containsKey(addressHolder)) continue;
                    addressDomainMap.put(addressHolder, null);
                    continue;
                }
                try {
                    Collection<String> addresses = this.resolveDomainNames(addressHolder);
                    for (String address : addresses) {
                        addressDomainMap.put(address, addressHolder);
                    }
                }
                catch (UnknownHostException e) {
                    this.logger.warning("Cannot resolve hostname: '" + addressHolder + "'");
                }
            }
        } else {
            addressDomainMap = Collections.emptyMap();
        }
        HashSet<InterfaceDefinition> interfaces = new HashSet<InterfaceDefinition>();
        if (networkConfig.getInterfaces().isEnabled()) {
            Collection<String> configInterfaces = networkConfig.getInterfaces().getInterfaces();
            for (String configInterface : configInterfaces) {
                if (AddressUtil.isIpAddress(configInterface)) {
                    String hostname = DefaultAddressPicker.findHostnameMatchingInterface(addressDomainMap, configInterface);
                    interfaces.add(new InterfaceDefinition(hostname, configInterface));
                    continue;
                }
                this.logger.info("'" + configInterface + "' is not an IP address! Removing from interface list.");
            }
            this.logger.info("Interfaces is enabled, trying to pick one address matching to one of: " + interfaces);
        } else if (tcpIpConfig.isEnabled()) {
            for (Map.Entry entry : addressDomainMap.entrySet()) {
                interfaces.add(new InterfaceDefinition((String)entry.getValue(), (String)entry.getKey()));
            }
            this.logger.info("Interfaces is disabled, trying to pick one address from TCP-IP config addresses: " + interfaces);
        }
        return interfaces;
    }

    private static String findHostnameMatchingInterface(Map<String, String> addressDomainMap, String configInterface) {
        String hostname = addressDomainMap.get(configInterface);
        if (hostname != null) {
            return hostname;
        }
        for (Map.Entry<String, String> entry : addressDomainMap.entrySet()) {
            String address = entry.getKey();
            if (!AddressUtil.matchInterface(address, configInterface)) continue;
            return entry.getValue();
        }
        return null;
    }

    private Collection<String> resolveDomainNames(String domainName) throws UnknownHostException {
        InetAddress[] inetAddresses = InetAddress.getAllByName(domainName);
        LinkedList<String> addresses = new LinkedList<String>();
        for (InetAddress inetAddress : inetAddresses) {
            addresses.add(inetAddress.getHostAddress());
        }
        this.logger.warning("You configured your member address as host name. Please be aware of that your dns can be spoofed. Make sure that your dns configurations are correct.");
        this.logger.info("Resolving domain name '" + domainName + "' to address(es): " + addresses);
        return addresses;
    }

    private AddressDefinition getSystemConfiguredAddress() throws UnknownHostException {
        String address = this.config.getProperty("hazelcast.local.localAddress");
        if (address != null) {
            if ("127.0.0.1".equals(address = address.trim()) || "localhost".equals(address)) {
                return DefaultAddressPicker.pickLoopbackAddress();
            }
            this.logger.info("Picking address configured by property 'hazelcast.local.localAddress'");
            return new AddressDefinition(address, InetAddress.getByName(address));
        }
        return null;
    }

    private AddressDefinition getPublicAddress(int port) throws UnknownHostException {
        String address = this.config.getProperty("hazelcast.local.publicAddress");
        if (address == null) {
            address = this.config.getNetworkConfig().getPublicAddress();
        }
        if (address != null) {
            if ("127.0.0.1".equals(address = address.trim()) || "localhost".equals(address)) {
                return DefaultAddressPicker.pickLoopbackAddress(address, port);
            }
            AddressUtil.AddressHolder holder = AddressUtil.getAddressHolder(address, port);
            return new AddressDefinition(holder.getAddress(), holder.getPort(), InetAddress.getByName(holder.getAddress()));
        }
        return null;
    }

    private static AddressDefinition pickLoopbackAddress() throws UnknownHostException {
        return new AddressDefinition(InetAddress.getByName("127.0.0.1"));
    }

    private static AddressDefinition pickLoopbackAddress(String host, int defaultPort) throws UnknownHostException {
        InetAddress address = InetAddress.getByName("127.0.0.1");
        return new AddressDefinition(host, defaultPort, address);
    }

    AddressDefinition pickMatchingAddress(Collection<InterfaceDefinition> interfaces) throws SocketException {
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        boolean preferIPv4Stack = this.preferIPv4Stack();
        boolean matchInterfaceDefinition = CollectionUtil.isNotEmpty(interfaces);
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface ni = networkInterfaces.nextElement();
            if (!matchInterfaceDefinition && this.skipInterface(ni)) continue;
            Enumeration<InetAddress> e = ni.getInetAddresses();
            while (e.hasMoreElements()) {
                InetAddress inetAddress = e.nextElement();
                if (preferIPv4Stack && inetAddress instanceof Inet6Address) continue;
                if (matchInterfaceDefinition) {
                    AddressDefinition address = this.match(inetAddress, interfaces);
                    if (address == null) continue;
                    return address;
                }
                if (inetAddress.isLoopbackAddress()) continue;
                return new AddressDefinition(inetAddress);
            }
        }
        return null;
    }

    private boolean skipInterface(NetworkInterface ni) throws SocketException {
        boolean skipInterface;
        boolean bl = skipInterface = !ni.isUp() || ni.isVirtual() || ni.isLoopback();
        if (skipInterface && this.logger.isFineEnabled()) {
            this.logger.fine("Skipping NetworkInterface '" + ni.getName() + "': isUp=" + ni.isUp() + ", isVirtual=" + ni.isVirtual() + ", isLoopback=" + ni.isLoopback());
        }
        return skipInterface;
    }

    private AddressDefinition match(InetAddress address, Collection<InterfaceDefinition> interfaces) {
        for (InterfaceDefinition inf : interfaces) {
            if (!AddressUtil.matchInterface(address.getHostAddress(), inf.address)) continue;
            return new AddressDefinition(inf.host, address);
        }
        return null;
    }

    private boolean preferIPv4Stack() {
        boolean preferIPv4Stack = Boolean.getBoolean(PREFER_IPV4_STACK) || this.hazelcastProperties.getBoolean(GroupProperty.PREFER_IPv4_STACK);
        JoinConfig join = this.config.getNetworkConfig().getJoin();
        AwsConfig awsConfig = join.getAwsConfig();
        boolean awsEnabled = awsConfig != null && awsConfig.isEnabled();
        return preferIPv4Stack || awsEnabled;
    }

    @Override
    public Address getBindAddress() {
        return this.bindAddress;
    }

    @Override
    public Address getPublicAddress() {
        return this.publicAddress;
    }

    @Override
    public ServerSocketChannel getServerSocketChannel() {
        return this.serverSocketChannel;
    }

    static class AddressDefinition
    extends InterfaceDefinition {
        InetAddress inetAddress;
        int port;

        AddressDefinition(InetAddress inetAddress) {
            super(inetAddress.getHostAddress());
            this.inetAddress = inetAddress;
        }

        AddressDefinition(String host, InetAddress inetAddress) {
            super(host, inetAddress.getHostAddress());
            this.inetAddress = inetAddress;
        }

        AddressDefinition(String host, int port, InetAddress inetAddress) {
            super(host, inetAddress.getHostAddress());
            this.inetAddress = inetAddress;
            this.port = port;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AddressDefinition that = (AddressDefinition)o;
            if (this.port != that.port) {
                return false;
            }
            return !(this.inetAddress != null ? !this.inetAddress.equals(that.inetAddress) : that.inetAddress != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.inetAddress != null ? this.inetAddress.hashCode() : 0);
            result = 31 * result + this.port;
            return result;
        }
    }

    static class InterfaceDefinition {
        String host;
        String address;

        InterfaceDefinition(String address) {
            this.host = null;
            this.address = address;
        }

        InterfaceDefinition(String host, String address) {
            this.host = host;
            this.address = address;
        }

        public String toString() {
            return this.host != null ? this.host + "/" + this.address : this.address;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InterfaceDefinition that = (InterfaceDefinition)o;
            if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
                return false;
            }
            return !(this.host != null ? !this.host.equals(that.host) : that.host != null);
        }

        public int hashCode() {
            int result = this.host != null ? this.host.hashCode() : 0;
            result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
            return result;
        }
    }
}

