/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.core.EntryView;
import com.hazelcast.map.impl.EntryViews;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.MapSplitBrainHandlerService;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.MapOperationProvider;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationFactory;
import com.hazelcast.spi.impl.merge.AbstractMergeRunnable;
import com.hazelcast.spi.impl.merge.MergingValueFactory;
import com.hazelcast.spi.merge.MergingEntry;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.function.BiConsumer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class MapMergeRunnable
extends AbstractMergeRunnable<RecordStore, MergingEntry<Data, Data>> {
    private final MapServiceContext mapServiceContext;
    private final MapSplitBrainHandlerService mapSplitBrainHandlerService;

    MapMergeRunnable(Map<String, Collection<RecordStore>> collectedStores, Map<String, Collection<RecordStore>> collectedStoresWithLegacyPolicies, Collection<RecordStore> backupStores, MapServiceContext mapServiceContext, MapSplitBrainHandlerService mapSplitBrainHandlerService) {
        super("hz:impl:mapService", collectedStores, collectedStoresWithLegacyPolicies, backupStores, mapServiceContext.getNodeEngine());
        this.mapServiceContext = mapServiceContext;
        this.mapSplitBrainHandlerService = mapSplitBrainHandlerService;
    }

    @Override
    protected void consumeStore(RecordStore store, BiConsumer<Integer, MergingEntry<Data, Data>> consumer) {
        long now = Clock.currentTimeMillis();
        int partitionId = store.getPartitionId();
        Iterator<Record> iterator = store.iterator(now, false);
        while (iterator.hasNext()) {
            Record record = iterator.next();
            Data dataValue = this.toData(record.getValue());
            MergingEntry<Data, Data> mergingEntry = MergingValueFactory.createMergingEntry((SerializationService)this.getSerializationService(), record, dataValue);
            consumer.accept(partitionId, mergingEntry);
        }
    }

    @Override
    protected void consumeStoreLegacy(RecordStore store, BiConsumer<Integer, Operation> consumer) {
        long now = Clock.currentTimeMillis();
        int partitionId = store.getPartitionId();
        String name = store.getName();
        MapOperationProvider operationProvider = this.mapServiceContext.getMapOperationProvider(name);
        MapMergePolicy mergePolicy = (MapMergePolicy)this.getMergePolicy(name);
        Iterator<Record> iterator = store.iterator(now, false);
        while (iterator.hasNext()) {
            Record record = iterator.next();
            Data key = record.getKey();
            Data value = this.toData(record.getValue());
            EntryView<Data, Data> entryView = EntryViews.createSimpleEntryView(key, value, record);
            MapOperation operation = operationProvider.createLegacyMergeOperation(name, entryView, mergePolicy, false);
            consumer.accept(partitionId, operation);
        }
    }

    @Override
    protected int getBatchSize(String dataStructureName) {
        MapConfig mapConfig = this.mapSplitBrainHandlerService.getMapConfig(dataStructureName);
        MergePolicyConfig mergePolicyConfig = mapConfig.getMergePolicyConfig();
        return mergePolicyConfig.getBatchSize();
    }

    @Override
    protected InMemoryFormat getInMemoryFormat(String dataStructureName) {
        MapConfig mapConfig = this.mapSplitBrainHandlerService.getMapConfig(dataStructureName);
        return mapConfig.getInMemoryFormat();
    }

    @Override
    protected Object getMergePolicy(String dataStructureName) {
        return this.mapSplitBrainHandlerService.getMergePolicy(dataStructureName);
    }

    @Override
    protected void destroyStores(Collection<RecordStore> stores) {
        this.mapSplitBrainHandlerService.destroyStores(stores);
    }

    @Override
    protected OperationFactory createMergeOperationFactory(String dataStructureName, SplitBrainMergePolicy mergePolicy, int[] partitions, List<MergingEntry<Data, Data>>[] entries) {
        MapOperationProvider operationProvider = this.mapServiceContext.getMapOperationProvider(dataStructureName);
        return operationProvider.createMergeOperationFactory(dataStructureName, partitions, entries, mergePolicy);
    }
}

