/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.query;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.query.Query;
import com.hazelcast.map.impl.query.QueryPartitionOperation;
import com.hazelcast.map.impl.query.QueryRunner;
import com.hazelcast.map.impl.query.Result;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.ReadonlyOperation;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.BinaryOperationFactory;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.operationservice.impl.operations.PartitionIteratingOperation;
import com.hazelcast.util.CollectionUtil;
import java.io.IOException;
import java.util.ArrayList;

public class QueryOperation
extends MapOperation
implements ReadonlyOperation {
    private Query query;
    private Result result;

    public QueryOperation() {
    }

    public QueryOperation(Query query) {
        super(query.getMapName());
        this.query = query;
    }

    @Override
    public void run() throws Exception {
        QueryRunner queryRunner = this.mapServiceContext.getMapQueryRunner(this.getName());
        if (this.isNativeInMemoryFormat()) {
            this.runAsyncPartitionThreadScanForNative(queryRunner);
        } else {
            this.result = queryRunner.runIndexOrPartitionScanQueryOnOwnedPartitions(this.query);
        }
    }

    private void runAsyncPartitionThreadScanForNative(QueryRunner queryRunner) {
        OperationServiceImpl ops = (OperationServiceImpl)this.getNodeEngine().getOperationService();
        ops.onStartAsyncOperation(this);
        this.runPartitionScanOnPartitionThreadsAsync(this.query, queryRunner);
    }

    void runPartitionScanOnPartitionThreadsAsync(final Query query, final QueryRunner queryRunner) {
        final ArrayList<Integer> initialPartitions = new ArrayList<Integer>(this.mapServiceContext.getOwnedPartitions());
        PartitionIteratingOperation opf = new PartitionIteratingOperation(new BinaryOperationFactory(new QueryPartitionOperation(query), this.getNodeEngine()), CollectionUtil.toIntArray(initialPartitions));
        final OperationServiceImpl ops = (OperationServiceImpl)this.getNodeEngine().getOperationService();
        ops.invokeOnTarget("hz:impl:mapService", opf, this.getNodeEngine().getThisAddress()).andThen(new ExecutionCallback<Object>(){

            @Override
            public void onResponse(Object response) {
                try {
                    Result modifiableResult = queryRunner.populateEmptyResult(query, initialPartitions);
                    QueryOperation.this.populateResult((PartitionIteratingOperation.PartitionResponse)response, modifiableResult);
                    QueryOperation.this.sendResponse(modifiableResult);
                }
                finally {
                    ops.onCompletionAsyncOperation(QueryOperation.this);
                }
            }

            @Override
            public void onFailure(Throwable t) {
                try {
                    QueryOperation.this.sendResponse(t);
                }
                finally {
                    ops.onCompletionAsyncOperation(QueryOperation.this);
                }
            }
        });
    }

    private Result populateResult(PartitionIteratingOperation.PartitionResponse response, Result result) {
        for (Object resultObject : response.getResults()) {
            if (!(resultObject instanceof Result)) continue;
            Result partitionResult = (Result)resultObject;
            result.combine(partitionResult);
        }
        return result;
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof MemberLeftException || throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    @Override
    public void onExecutionFailure(Throwable e) {
        if (this.isNativeInMemoryFormat()) {
            this.sendResponse(e);
        } else {
            super.onExecutionFailure(e);
        }
    }

    @Override
    public boolean returnsResponse() {
        return !this.isNativeInMemoryFormat();
    }

    @Override
    public Object getResponse() {
        if (this.isNativeInMemoryFormat()) {
            return null;
        }
        return this.result;
    }

    private boolean isNativeInMemoryFormat() {
        return this.mapContainer != null && this.mapContainer.getMapConfig().getInMemoryFormat().equals((Object)InMemoryFormat.NATIVE);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.query);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.query = (Query)in.readObject();
    }

    @Override
    public int getId() {
        return 60;
    }
}

