/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ringbuffer.impl;

import com.hazelcast.ringbuffer.StaleSequenceException;
import com.hazelcast.ringbuffer.impl.Ringbuffer;
import com.hazelcast.spi.impl.merge.MergingValueFactory;
import com.hazelcast.spi.merge.MergingEntry;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.serialization.SerializationService;

public class ArrayRingbuffer<E>
implements Ringbuffer<E> {
    E[] ringItems;
    private long tailSequence = -1L;
    private long headSequence = this.tailSequence + 1L;
    private int capacity;
    private SerializationService serializationService;

    public ArrayRingbuffer(int capacity) {
        this.capacity = capacity;
        this.ringItems = new Object[capacity];
    }

    @Override
    public long tailSequence() {
        return this.tailSequence;
    }

    @Override
    public long peekNextTailSequence() {
        return this.tailSequence + 1L;
    }

    @Override
    public void setTailSequence(long sequence) {
        this.tailSequence = sequence;
    }

    @Override
    public long headSequence() {
        return this.headSequence;
    }

    @Override
    public void setHeadSequence(long sequence) {
        this.headSequence = sequence;
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public long size() {
        return this.tailSequence - this.headSequence + 1L;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0L;
    }

    @Override
    public long add(E item) {
        ++this.tailSequence;
        if (this.tailSequence - (long)this.capacity == this.headSequence) {
            ++this.headSequence;
        }
        int index = this.toIndex(this.tailSequence);
        this.ringItems[index] = item;
        return this.tailSequence;
    }

    @Override
    public E read(long sequence) {
        this.checkReadSequence(sequence);
        return this.ringItems[this.toIndex(sequence)];
    }

    @Override
    public void checkBlockableReadSequence(long readSequence) {
        if (readSequence > this.tailSequence + 1L) {
            throw new IllegalArgumentException("sequence:" + readSequence + " is too large. The current tailSequence is:" + this.tailSequence);
        }
        if (readSequence < this.headSequence) {
            throw new StaleSequenceException("sequence:" + readSequence + " is too small. The current headSequence is:" + this.headSequence + " tailSequence is:" + this.tailSequence, this.headSequence);
        }
    }

    @Override
    public void checkReadSequence(long sequence) {
        if (sequence > this.tailSequence) {
            throw new IllegalArgumentException("sequence:" + sequence + " is too large. The current tailSequence is:" + this.tailSequence);
        }
        if (sequence < this.headSequence) {
            throw new StaleSequenceException("sequence:" + sequence + " is too small. The current headSequence is:" + this.headSequence + " tailSequence is:" + this.tailSequence, this.headSequence);
        }
    }

    private int toIndex(long sequence) {
        return (int)(sequence % (long)this.ringItems.length);
    }

    @Override
    public void set(long seq, E data) {
        this.ringItems[this.toIndex((long)seq)] = data;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.ringItems.length; ++i) {
            this.ringItems[i] = null;
        }
        this.tailSequence = -1L;
        this.headSequence = this.tailSequence + 1L;
    }

    @Override
    public void setSerializationService(SerializationService serializationService) {
        this.serializationService = serializationService;
    }

    @Override
    public long merge(MergingEntry<Long, E> mergingEntry, SplitBrainMergePolicy mergePolicy, long remainingCapacity) {
        this.serializationService.getManagedContext().initialize(mergingEntry);
        this.serializationService.getManagedContext().initialize(mergePolicy);
        Object existingItem = null;
        long existingSequence = -1L;
        for (long sequence = this.headSequence; sequence <= this.tailSequence; ++sequence) {
            E item = this.read(sequence);
            if (!mergingEntry.getValue().equals(item)) continue;
            existingItem = item;
            existingSequence = sequence;
            break;
        }
        if (existingItem == null) {
            if (remainingCapacity < 1L) {
                return -1L;
            }
            Object newValue = mergePolicy.merge(mergingEntry, null);
            if (newValue != null) {
                return this.add(newValue);
            }
        } else {
            MergingEntry<Long, Object> existingEntry = MergingValueFactory.createMergingEntry(this.serializationService, existingSequence, existingItem);
            Object newValue = mergePolicy.merge(mergingEntry, existingEntry);
            if (newValue != null && !newValue.equals(existingItem)) {
                this.set(existingSequence, newValue);
                return existingSequence;
            }
        }
        return -1L;
    }
}

