/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ringbuffer.impl.operations;

import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.journal.CacheEventJournal;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.journal.MapEventJournal;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.ringbuffer.impl.RingbufferContainer;
import com.hazelcast.ringbuffer.impl.RingbufferDataSerializerHook;
import com.hazelcast.ringbuffer.impl.RingbufferService;
import com.hazelcast.ringbuffer.impl.operations.MergeBackupOperation;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.ServiceNamespace;
import com.hazelcast.spi.ServiceNamespaceAware;
import com.hazelcast.spi.merge.MergingEntry;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.util.MapUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MergeOperation
extends Operation
implements IdentifiedDataSerializable,
BackupAwareOperation,
ServiceNamespaceAware {
    private ObjectNamespace namespace;
    private SplitBrainMergePolicy mergePolicy;
    private List<MergingEntry<Long, Object>> mergingEntries;
    private transient RingbufferConfig config;
    private transient RingbufferContainer<Object, Object> ringbuffer;
    private transient Map<Long, Data> valueMap;

    public MergeOperation() {
    }

    public MergeOperation(ObjectNamespace namespace, SplitBrainMergePolicy mergePolicy, List<MergingEntry<Long, Object>> mergingEntries) {
        this.namespace = namespace;
        this.mergePolicy = mergePolicy;
        this.mergingEntries = mergingEntries;
    }

    @Override
    public void beforeRun() throws Exception {
        RingbufferService service = (RingbufferService)this.getService();
        this.config = this.getRingbufferConfig(service, this.namespace);
        this.ringbuffer = service.getOrCreateContainer(this.getPartitionId(), this.namespace, this.config);
    }

    @Override
    public void run() throws Exception {
        this.valueMap = MapUtil.createHashMap(this.mergingEntries.size());
        for (MergingEntry<Long, Object> mergingEntry : this.mergingEntries) {
            long resultSequence = this.ringbuffer.merge(mergingEntry, this.mergePolicy);
            if (resultSequence == -1L) continue;
            this.valueMap.put(resultSequence, this.ringbuffer.readAsData(resultSequence));
        }
    }

    @Override
    public boolean shouldBackup() {
        return this.valueMap != null && !this.valueMap.isEmpty();
    }

    @Override
    public int getSyncBackupCount() {
        return this.config.getBackupCount();
    }

    @Override
    public int getAsyncBackupCount() {
        return this.config.getAsyncBackupCount();
    }

    @Override
    public Operation getBackupOperation() {
        return new MergeBackupOperation(this.namespace.getObjectName(), this.valueMap);
    }

    private RingbufferConfig getRingbufferConfig(RingbufferService service, ObjectNamespace ns) {
        String serviceName = ns.getServiceName();
        if ("hz:impl:ringbufferService".equals(serviceName)) {
            return service.getRingbufferConfig(ns.getObjectName());
        }
        if ("hz:impl:mapService".equals(serviceName)) {
            MapService mapService = (MapService)this.getNodeEngine().getService("hz:impl:mapService");
            MapEventJournal journal = mapService.getMapServiceContext().getEventJournal();
            EventJournalConfig journalConfig = journal.getEventJournalConfig(ns);
            return journal.toRingbufferConfig(journalConfig, this.namespace);
        }
        if ("hz:impl:cacheService".equals(serviceName)) {
            CacheService cacheService = (CacheService)this.getNodeEngine().getService("hz:impl:cacheService");
            CacheEventJournal journal = cacheService.getEventJournal();
            EventJournalConfig journalConfig = journal.getEventJournalConfig(ns);
            return journal.toRingbufferConfig(journalConfig, this.namespace);
        }
        throw new IllegalArgumentException("Unsupported ringbuffer service name: " + serviceName);
    }

    @Override
    public ServiceNamespace getServiceNamespace() {
        return this.namespace;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:ringbufferService";
    }

    @Override
    public int getFactoryId() {
        return RingbufferDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 11;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.namespace);
        out.writeObject(this.mergePolicy);
        out.writeInt(this.mergingEntries.size());
        for (MergingEntry<Long, Object> mergingEntry : this.mergingEntries) {
            out.writeObject(mergingEntry);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.namespace = (ObjectNamespace)in.readObject();
        this.mergePolicy = (SplitBrainMergePolicy)in.readObject();
        int size = in.readInt();
        this.mergingEntries = new ArrayList<MergingEntry<Long, Object>>(size);
        for (int i = 0; i < size; ++i) {
            MergingEntry mergingEntry = (MergingEntry)in.readObject();
            this.mergingEntries.add(mergingEntry);
        }
    }
}

