/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.executor.impl.operations;

import com.hazelcast.core.ManagedContext;
import com.hazelcast.executor.impl.DistributedExecutorService;
import com.hazelcast.executor.impl.ExecutorDataSerializerHook;
import com.hazelcast.executor.impl.RunnableAdapter;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.CallStatus;
import com.hazelcast.spi.NamedOperation;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.concurrent.Callable;

abstract class AbstractCallableTaskOperation
extends Operation
implements NamedOperation,
IdentifiedDataSerializable {
    protected String name;
    protected String uuid;
    private Data callableData;

    public AbstractCallableTaskOperation() {
    }

    public AbstractCallableTaskOperation(String name, String uuid, Data callableData) {
        this.name = name;
        this.uuid = uuid;
        this.callableData = callableData;
    }

    @Override
    public final CallStatus call() {
        Callable callable = this.loadCallable();
        DistributedExecutorService service = (DistributedExecutorService)this.getService();
        service.execute(this.name, this.uuid, callable, this);
        return CallStatus.OFFLOADED;
    }

    private Callable loadCallable() {
        ManagedContext managedContext = this.getManagedContext();
        Callable callable = (Callable)this.getNodeEngine().toObject(this.callableData);
        if (callable instanceof RunnableAdapter) {
            RunnableAdapter adapter = (RunnableAdapter)callable;
            Runnable runnable = (Runnable)managedContext.initialize(adapter.getRunnable());
            adapter.setRunnable(runnable);
        } else {
            callable = (Callable)managedContext.initialize(callable);
        }
        return callable;
    }

    private ManagedContext getManagedContext() {
        HazelcastInstanceImpl hazelcastInstance = (HazelcastInstanceImpl)this.getNodeEngine().getHazelcastInstance();
        InternalSerializationService serializationService = hazelcastInstance.getSerializationService();
        return serializationService.getManagedContext();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:executorService";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.uuid);
        out.writeData(this.callableData);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.uuid = in.readUTF();
        this.callableData = in.readData();
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", name=").append(this.name);
    }

    @Override
    public int getFactoryId() {
        return ExecutorDataSerializerHook.F_ID;
    }
}

