/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.config.ConfigurationException;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.instance.AddressPicker;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.spi.MemberAddressProvider;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.TimeUnit;

public class DelegatingAddressPicker
implements AddressPicker {
    private static final int SOCKET_TIMEOUT_MILLIS = (int)TimeUnit.SECONDS.toMillis(1L);
    private static final int SOCKET_BACKLOG_LENGTH = 100;
    private final ILogger logger;
    private final MemberAddressProvider memberAddressProvider;
    private final NetworkConfig networkConfig;
    private volatile InetSocketAddress bindAddress;
    private volatile InetSocketAddress publicAddress;
    private volatile ServerSocketChannel serverSocketChannel;

    public DelegatingAddressPicker(MemberAddressProvider memberAddressProvider, NetworkConfig networkConfig, ILogger logger) {
        this.memberAddressProvider = memberAddressProvider;
        this.networkConfig = networkConfig;
        this.logger = logger;
    }

    @Override
    public void pickAddress() throws Exception {
        try {
            this.bindAddress = this.memberAddressProvider.getBindAddress();
            this.logger.info("Using bind address: " + this.bindAddress);
            this.publicAddress = this.memberAddressProvider.getPublicAddress();
            this.validatePublicAddress(this.publicAddress);
            this.logger.info("Using public address: " + this.publicAddress);
            this.serverSocketChannel = this.createServerSocketChannelInternal();
            if (this.publicAddress.getPort() == 0) {
                this.publicAddress = new InetSocketAddress(this.publicAddress.getAddress(), this.serverSocketChannel.socket().getLocalPort());
            }
        }
        catch (Exception e) {
            this.logger.severe(e);
            throw e;
        }
    }

    private ServerSocketChannel createServerSocketChannelInternal() {
        int portTrialCount;
        int portCount = this.networkConfig.getPortCount();
        int port = this.bindAddress.getPort() == 0 ? this.networkConfig.getPort() : this.bindAddress.getPort();
        boolean portAutoIncrement = this.networkConfig.isPortAutoIncrement();
        int n = portTrialCount = port > 0 && portAutoIncrement ? portCount : 1;
        if (port == 0) {
            this.logger.info("No explicit port is given, system will pick up an ephemeral port.");
        }
        IOException error = null;
        for (int i = 0; i < portTrialCount; ++i) {
            InetSocketAddress tmpBindAddress = new InetSocketAddress(this.bindAddress.getAddress(), port + i);
            boolean reuseAddress = this.networkConfig.isReuseAddress();
            this.logger.finest("inet reuseAddress:" + reuseAddress);
            ServerSocket serverSocket = null;
            ServerSocketChannel serverSocketChannel = null;
            try {
                serverSocketChannel = ServerSocketChannel.open();
                serverSocket = serverSocketChannel.socket();
                serverSocket.setReuseAddress(reuseAddress);
                serverSocket.setSoTimeout(SOCKET_TIMEOUT_MILLIS);
                this.logger.fine("Trying to bind inet socket address: " + tmpBindAddress);
                serverSocket.bind(tmpBindAddress, 100);
                this.logger.fine("Bind successful to inet socket address: " + serverSocket.getLocalSocketAddress());
                serverSocketChannel.configureBlocking(false);
                this.bindAddress = tmpBindAddress;
                return serverSocketChannel;
            }
            catch (IOException e) {
                IOUtil.close(serverSocket);
                IOUtil.closeResource(serverSocketChannel);
                error = e;
                continue;
            }
        }
        String message = "Cannot bind to a given address: " + this.bindAddress + ". Hazelcast cannot start. ";
        message = this.networkConfig.isPortAutoIncrement() ? message + "Config-port: " + this.networkConfig.getPort() + ", latest-port: " + (port + portTrialCount) : message + "Port [" + port + "] is already in use and auto-increment is disabled.";
        throw new HazelcastException(message, error);
    }

    private void validatePublicAddress(InetSocketAddress inetSocketAddress) {
        InetAddress address = inetSocketAddress.getAddress();
        if (address == null) {
            throw new ConfigurationException("Cannot resolve address '" + inetSocketAddress + "'");
        }
        if (address.isAnyLocalAddress()) {
            throw new ConfigurationException("Member address provider has to return a specific public address to broadcast to other members.");
        }
    }

    @Override
    public Address getBindAddress() {
        return new Address(this.bindAddress);
    }

    @Override
    public Address getPublicAddress() {
        return new Address(this.publicAddress);
    }

    @Override
    public ServerSocketChannel getServerSocketChannel() {
        return this.serverSocketChannel;
    }
}

