/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.config.AtomicLongConfig;
import com.hazelcast.config.AtomicReferenceConfig;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.CRDTReplicationConfig;
import com.hazelcast.config.CachePartitionLostListenerConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CacheSimpleEntryListenerConfig;
import com.hazelcast.config.CardinalityEstimatorConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigurationException;
import com.hazelcast.config.CountDownLatchConfig;
import com.hazelcast.config.CredentialsFactoryConfig;
import com.hazelcast.config.DurableExecutorConfig;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.FlakeIdGeneratorConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.HotRestartConfig;
import com.hazelcast.config.HotRestartPersistenceConfig;
import com.hazelcast.config.IcmpFailureDetectorConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.ItemListenerConfig;
import com.hazelcast.config.JobTrackerConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.ListConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.LockConfig;
import com.hazelcast.config.LoginModuleConfig;
import com.hazelcast.config.MCMutualAuthConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.config.MapAttributeConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.MapPartitionLostListenerConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.config.MemberAddressProviderConfig;
import com.hazelcast.config.MemberAttributeConfig;
import com.hazelcast.config.MemberGroupConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.PNCounterConfig;
import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.config.PartitioningStrategyConfig;
import com.hazelcast.config.PermissionConfig;
import com.hazelcast.config.PermissionPolicyConfig;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.ProbabilisticQuorumConfigBuilder;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.QueueStoreConfig;
import com.hazelcast.config.QuorumConfig;
import com.hazelcast.config.QuorumConfigBuilder;
import com.hazelcast.config.QuorumListenerConfig;
import com.hazelcast.config.RecentlyActiveQuorumConfigBuilder;
import com.hazelcast.config.ReliableTopicConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.config.RingbufferStoreConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.config.SecurityInterceptorConfig;
import com.hazelcast.config.SemaphoreConfig;
import com.hazelcast.config.ServiceConfig;
import com.hazelcast.config.ServicesConfig;
import com.hazelcast.config.SetConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.WanConsumerConfig;
import com.hazelcast.config.WanPublisherConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.map.eviction.MapEvictionPolicy;
import com.hazelcast.memory.MemorySize;
import com.hazelcast.memory.MemoryUnit;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.quorum.QuorumType;
import com.hazelcast.spi.ServiceConfigurationParser;
import com.hazelcast.spring.AbstractHazelcastBeanDefinitionParser;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.StringUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HazelcastConfigBeanDefinitionParser
extends AbstractHazelcastBeanDefinitionParser {
    public AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        SpringXmlConfigBuilder springXmlConfigBuilder = new SpringXmlConfigBuilder(parserContext);
        springXmlConfigBuilder.handleConfig(element);
        return springXmlConfigBuilder.getBeanDefinition();
    }

    private class SpringXmlConfigBuilder
    extends AbstractHazelcastBeanDefinitionParser.SpringXmlBuilderHelper {
        private final ParserContext parserContext;
        private ManagedMap<String, AbstractBeanDefinition> mapConfigManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> cacheConfigManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> queueManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> lockManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> ringbufferManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> atomicLongManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> atomicReferenceManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> countDownLatchManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> reliableTopicManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> semaphoreManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> listManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> setManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> topicManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> multiMapManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> executorManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> durableExecutorManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> scheduledExecutorManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> mapEventJournalManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> cacheEventJournalManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> cardinalityEstimatorManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> wanReplicationManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> jobTrackerManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> replicatedMapManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> quorumManagedMap;
        private ManagedMap<String, AbstractBeanDefinition> flakeIdGeneratorConfigMap;
        private ManagedMap<String, AbstractBeanDefinition> pnCounterManagedMap;

        public SpringXmlConfigBuilder(ParserContext parserContext) {
            super(HazelcastConfigBeanDefinitionParser.this);
            this.parserContext = parserContext;
            this.configBuilder = BeanDefinitionBuilder.rootBeanDefinition(Config.class);
            this.mapConfigManagedMap = this.createManagedMap("mapConfigs");
            this.cacheConfigManagedMap = this.createManagedMap("cacheConfigs");
            this.queueManagedMap = this.createManagedMap("queueConfigs");
            this.lockManagedMap = this.createManagedMap("lockConfigs");
            this.ringbufferManagedMap = this.createManagedMap("ringbufferConfigs");
            this.atomicLongManagedMap = this.createManagedMap("atomicLongConfigs");
            this.atomicReferenceManagedMap = this.createManagedMap("atomicReferenceConfigs");
            this.countDownLatchManagedMap = this.createManagedMap("countDownLatchConfigs");
            this.reliableTopicManagedMap = this.createManagedMap("reliableTopicConfigs");
            this.semaphoreManagedMap = this.createManagedMap("semaphoreConfigs");
            this.listManagedMap = this.createManagedMap("listConfigs");
            this.setManagedMap = this.createManagedMap("setConfigs");
            this.topicManagedMap = this.createManagedMap("topicConfigs");
            this.multiMapManagedMap = this.createManagedMap("multiMapConfigs");
            this.executorManagedMap = this.createManagedMap("executorConfigs");
            this.durableExecutorManagedMap = this.createManagedMap("durableExecutorConfigs");
            this.scheduledExecutorManagedMap = this.createManagedMap("scheduledExecutorConfigs");
            this.mapEventJournalManagedMap = this.createManagedMap("mapEventJournalConfigs");
            this.cacheEventJournalManagedMap = this.createManagedMap("cacheEventJournalConfigs");
            this.cardinalityEstimatorManagedMap = this.createManagedMap("cardinalityEstimatorConfigs");
            this.wanReplicationManagedMap = this.createManagedMap("wanReplicationConfigs");
            this.jobTrackerManagedMap = this.createManagedMap("jobTrackerConfigs");
            this.replicatedMapManagedMap = this.createManagedMap("replicatedMapConfigs");
            this.quorumManagedMap = this.createManagedMap("quorumConfigs");
            this.flakeIdGeneratorConfigMap = this.createManagedMap("flakeIdGeneratorConfigs");
            this.pnCounterManagedMap = this.createManagedMap("PNCounterConfigs");
        }

        private ManagedMap<String, AbstractBeanDefinition> createManagedMap(String configName) {
            ManagedMap managedMap = new ManagedMap();
            this.configBuilder.addPropertyValue(configName, (Object)managedMap);
            return managedMap;
        }

        public AbstractBeanDefinition getBeanDefinition() {
            return this.configBuilder.getBeanDefinition();
        }

        public void handleConfig(Element element) {
            if (element != null) {
                this.handleCommonBeanAttributes(element, this.configBuilder, this.parserContext);
                for (Node node : SpringXmlConfigBuilder.childElements(element)) {
                    String nodeName = SpringXmlConfigBuilder.cleanNodeName(node);
                    if ("network".equals(nodeName)) {
                        this.handleNetwork(node);
                        continue;
                    }
                    if ("group".equals(nodeName)) {
                        this.handleGroup(node);
                        continue;
                    }
                    if ("properties".equals(nodeName)) {
                        this.handleProperties(node);
                        continue;
                    }
                    if ("executor-service".equals(nodeName)) {
                        this.handleExecutor(node);
                        continue;
                    }
                    if ("durable-executor-service".equals(nodeName)) {
                        this.handleDurableExecutor(node);
                        continue;
                    }
                    if ("scheduled-executor-service".equals(nodeName)) {
                        this.handleScheduledExecutor(node);
                        continue;
                    }
                    if ("event-journal".equals(nodeName)) {
                        this.handleEventJournal(node);
                        continue;
                    }
                    if ("cardinality-estimator".equals(nodeName)) {
                        this.handleCardinalityEstimator(node);
                        continue;
                    }
                    if ("queue".equals(nodeName)) {
                        this.handleQueue(node);
                        continue;
                    }
                    if ("lock".equals(nodeName)) {
                        this.handleLock(node);
                        continue;
                    }
                    if ("ringbuffer".equals(nodeName)) {
                        this.handleRingbuffer(node);
                        continue;
                    }
                    if ("atomic-long".equals(nodeName)) {
                        this.handleAtomicLong(node);
                        continue;
                    }
                    if ("atomic-reference".equals(nodeName)) {
                        this.handleAtomicReference(node);
                        continue;
                    }
                    if ("count-down-latch".equals(nodeName)) {
                        this.handleCountDownLatch(node);
                        continue;
                    }
                    if ("reliable-topic".equals(nodeName)) {
                        this.handleReliableTopic(node);
                        continue;
                    }
                    if ("semaphore".equals(nodeName)) {
                        this.handleSemaphore(node);
                        continue;
                    }
                    if ("map".equals(nodeName)) {
                        this.handleMap(node);
                        continue;
                    }
                    if ("cache".equals(nodeName)) {
                        this.handleCache(node);
                        continue;
                    }
                    if ("multimap".equals(nodeName)) {
                        this.handleMultiMap(node);
                        continue;
                    }
                    if ("list".equals(nodeName)) {
                        this.handleList(node);
                        continue;
                    }
                    if ("set".equals(nodeName)) {
                        this.handleSet(node);
                        continue;
                    }
                    if ("topic".equals(nodeName)) {
                        this.handleTopic(node);
                        continue;
                    }
                    if ("jobtracker".equals(nodeName)) {
                        this.handleJobTracker(node);
                        continue;
                    }
                    if ("replicatedmap".equals(nodeName)) {
                        this.handleReplicatedMap(node);
                        continue;
                    }
                    if ("wan-replication".equals(nodeName)) {
                        this.handleWanReplication(node);
                        continue;
                    }
                    if ("partition-group".equals(nodeName)) {
                        this.handlePartitionGroup(node);
                        continue;
                    }
                    if ("serialization".equals(nodeName)) {
                        this.handleSerialization(node);
                        continue;
                    }
                    if ("native-memory".equals(nodeName)) {
                        this.handleNativeMemory(node);
                        continue;
                    }
                    if ("security".equals(nodeName)) {
                        this.handleSecurity(node);
                        continue;
                    }
                    if ("member-attributes".equals(nodeName)) {
                        this.handleMemberAttributes(node);
                        continue;
                    }
                    if ("instance-name".equals(nodeName)) {
                        this.configBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)this.getTextContent(node));
                        continue;
                    }
                    if ("listeners".equals(nodeName)) {
                        ManagedList listeners = this.parseListeners(node, ListenerConfig.class);
                        this.configBuilder.addPropertyValue("listenerConfigs", (Object)listeners);
                        continue;
                    }
                    if ("lite-member".equals(nodeName)) {
                        this.handleLiteMember(node);
                        continue;
                    }
                    if ("license-key".equals(nodeName)) {
                        this.configBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)this.getTextContent(node));
                        continue;
                    }
                    if ("management-center".equals(nodeName)) {
                        this.handleManagementCenter(node);
                        continue;
                    }
                    if ("services".equals(nodeName)) {
                        this.handleServices(node);
                        continue;
                    }
                    if ("spring-aware".equals(nodeName)) {
                        this.handleSpringAware();
                        continue;
                    }
                    if ("quorum".equals(nodeName)) {
                        this.handleQuorum(node);
                        continue;
                    }
                    if ("hot-restart-persistence".equals(nodeName)) {
                        this.handleHotRestartPersistence(node);
                        continue;
                    }
                    if ("flake-id-generator".equals(nodeName)) {
                        this.handleFlakeIdGenerator(node);
                        continue;
                    }
                    if ("crdt-replication".equals(nodeName)) {
                        this.handleCRDTReplication(node);
                        continue;
                    }
                    if (!"pn-counter".equals(nodeName)) continue;
                    this.handlePNCounter(node);
                }
            }
        }

        private void handleHotRestartPersistence(Node node) {
            BeanDefinitionBuilder hotRestartConfigBuilder = this.createBeanBuilder(HotRestartPersistenceConfig.class);
            this.fillAttributeValues(node, hotRestartConfigBuilder, new String[0]);
            for (Node child : SpringXmlConfigBuilder.childElements(node)) {
                String name = SpringXmlConfigBuilder.cleanNodeName(child);
                if ("base-dir".equals(name)) {
                    String value = this.getTextContent(child);
                    hotRestartConfigBuilder.addPropertyValue("baseDir", (Object)value);
                    continue;
                }
                if (!"backup-dir".equals(name)) continue;
                hotRestartConfigBuilder.addPropertyValue("backupDir", (Object)this.getTextContent(child));
            }
            this.configBuilder.addPropertyValue("hotRestartPersistenceConfig", (Object)hotRestartConfigBuilder.getBeanDefinition());
        }

        private void handleFlakeIdGenerator(Node node) {
            BeanDefinitionBuilder configBuilder = this.createBeanBuilder(FlakeIdGeneratorConfig.class);
            this.fillAttributeValues(node, configBuilder, new String[0]);
            String name = this.getAttribute(node, "name");
            this.flakeIdGeneratorConfigMap.put((Object)name, (Object)configBuilder.getBeanDefinition());
        }

        private void handleCRDTReplication(Node node) {
            BeanDefinitionBuilder crdtReplicationConfigBuilder = this.createBeanBuilder(CRDTReplicationConfig.class);
            this.fillAttributeValues(node, crdtReplicationConfigBuilder, new String[0]);
            this.configBuilder.addPropertyValue("CRDTReplicationConfig", (Object)crdtReplicationConfigBuilder.getBeanDefinition());
        }

        private void handleQuorum(Node node) {
            BeanDefinitionBuilder quorumConfigBuilder = this.createBeanBuilder(QuorumConfig.class);
            AbstractBeanDefinition beanDefinition = quorumConfigBuilder.getBeanDefinition();
            String name = this.getAttribute(node, "name");
            quorumConfigBuilder.addPropertyValue("name", (Object)name);
            Node attrEnabled = node.getAttributes().getNamedItem("enabled");
            boolean enabled = attrEnabled != null && SpringXmlConfigBuilder.getBooleanValue(this.getTextContent(attrEnabled));
            quorumConfigBuilder.addPropertyValue("enabled", (Object)enabled);
            QuorumConfigBuilder configBuilder = null;
            int quorumSize = 3;
            String quorumClassName = null;
            for (Node n : SpringXmlConfigBuilder.childElements(node)) {
                String value = this.getTextContent(n).trim();
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(n);
                if ("quorum-size".equals(nodeName)) {
                    quorumConfigBuilder.addPropertyValue("size", (Object)SpringXmlConfigBuilder.getIntegerValue("quorum-size", value));
                    continue;
                }
                if ("quorum-listeners".equals(nodeName)) {
                    ManagedList listeners = this.parseListeners(n, QuorumListenerConfig.class);
                    quorumConfigBuilder.addPropertyValue("listenerConfigs", (Object)listeners);
                    continue;
                }
                if ("quorum-type".equals(nodeName)) {
                    quorumConfigBuilder.addPropertyValue("type", (Object)QuorumType.valueOf(value));
                    continue;
                }
                if ("quorum-function-class-name".equals(nodeName)) {
                    quorumClassName = value;
                    quorumConfigBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)value);
                    continue;
                }
                if ("recently-active-quorum".equals(nodeName)) {
                    configBuilder = this.handleRecentlyActiveQuorum(name, n, quorumSize);
                    continue;
                }
                if (!"probabilistic-quorum".equals(nodeName)) continue;
                configBuilder = this.handleProbabilisticQuorum(name, n, quorumSize);
            }
            if (configBuilder != null) {
                boolean quorumFunctionDefinedByClassName;
                boolean bl = quorumFunctionDefinedByClassName = !StringUtil.isNullOrEmpty(quorumClassName);
                if (quorumFunctionDefinedByClassName) {
                    throw new ConfigurationException("A quorum cannot simultaneously define probabilistic-quorum or recently-active-quorum and a quorum function class name.");
                }
                QuorumConfig constructedConfig = configBuilder.build();
                quorumConfigBuilder.addPropertyValue("quorumFunctionImplementation", (Object)constructedConfig.getQuorumFunctionImplementation());
            }
            this.quorumManagedMap.put((Object)name, (Object)beanDefinition);
        }

        private QuorumConfigBuilder handleRecentlyActiveQuorum(String name, Node node, int quorumSize) {
            int heartbeatToleranceMillis = SpringXmlConfigBuilder.getIntegerValue("heartbeat-tolerance-millis", this.getAttribute(node, "heartbeat-tolerance-millis"), RecentlyActiveQuorumConfigBuilder.DEFAULT_HEARTBEAT_TOLERANCE_MILLIS);
            RecentlyActiveQuorumConfigBuilder quorumConfigBuilder = QuorumConfig.newRecentlyActiveQuorumConfigBuilder(name, quorumSize, heartbeatToleranceMillis);
            return quorumConfigBuilder;
        }

        private QuorumConfigBuilder handleProbabilisticQuorum(String name, Node node, int quorumSize) {
            long acceptableHeartPause = SpringXmlConfigBuilder.getLongValue("acceptable-heartbeat-pause-millis", this.getAttribute(node, "acceptable-heartbeat-pause-millis"), ProbabilisticQuorumConfigBuilder.DEFAULT_HEARTBEAT_PAUSE_MILLIS);
            double threshold = SpringXmlConfigBuilder.getDoubleValue("suspicion-threshold", this.getAttribute(node, "suspicion-threshold"), ProbabilisticQuorumConfigBuilder.DEFAULT_PHI_THRESHOLD);
            int maxSampleSize = SpringXmlConfigBuilder.getIntegerValue("max-sample-size", this.getAttribute(node, "max-sample-size"), ProbabilisticQuorumConfigBuilder.DEFAULT_SAMPLE_SIZE);
            long minStdDeviation = SpringXmlConfigBuilder.getLongValue("min-std-deviation-millis", this.getAttribute(node, "min-std-deviation-millis"), ProbabilisticQuorumConfigBuilder.DEFAULT_MIN_STD_DEVIATION);
            long heartbeatIntervalMillis = SpringXmlConfigBuilder.getLongValue("heartbeat-interval-millis", this.getAttribute(node, "heartbeat-interval-millis"), ProbabilisticQuorumConfigBuilder.DEFAULT_HEARTBEAT_INTERVAL_MILLIS);
            ProbabilisticQuorumConfigBuilder quorumConfigBuilder = QuorumConfig.newProbabilisticQuorumConfigBuilder(name, quorumSize).withAcceptableHeartbeatPauseMillis(acceptableHeartPause).withSuspicionThreshold(threshold).withHeartbeatIntervalMillis(heartbeatIntervalMillis).withMinStdDeviationMillis(minStdDeviation).withMaxSampleSize(maxSampleSize);
            return quorumConfigBuilder;
        }

        private void handleMergePolicyConfig(Node node, BeanDefinitionBuilder builder) {
            BeanDefinitionBuilder mergePolicyConfigBuilder = this.createBeanBuilder(MergePolicyConfig.class);
            AbstractBeanDefinition beanDefinition = mergePolicyConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, mergePolicyConfigBuilder, new String[0]);
            mergePolicyConfigBuilder.addPropertyValue("policy", (Object)this.getTextContent(node).trim());
            builder.addPropertyValue("mergePolicyConfig", (Object)beanDefinition);
        }

        private void handleLiteMember(Node node) {
            Node attrEnabled = node.getAttributes().getNamedItem("enabled");
            this.configBuilder.addPropertyValue(this.xmlToJavaName(SpringXmlConfigBuilder.cleanNodeName(node)), (Object)this.getTextContent(attrEnabled));
        }

        public void handleServices(Node node) {
            BeanDefinitionBuilder servicesConfigBuilder = this.createBeanBuilder(ServicesConfig.class);
            AbstractBeanDefinition beanDefinition = servicesConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, servicesConfigBuilder, new String[0]);
            ManagedList serviceConfigManagedList = new ManagedList();
            for (Node child : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child);
                if (!"service".equals(nodeName)) continue;
                serviceConfigManagedList.add((Object)this.handleService(child));
            }
            servicesConfigBuilder.addPropertyValue("serviceConfigs", (Object)serviceConfigManagedList);
            this.configBuilder.addPropertyValue("servicesConfig", (Object)beanDefinition);
        }

        private AbstractBeanDefinition handleService(Node node) {
            Node implNode;
            BeanDefinitionBuilder serviceConfigBuilder = this.createBeanBuilder(ServiceConfig.class);
            AbstractBeanDefinition beanDefinition = serviceConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, serviceConfigBuilder, new String[0]);
            boolean classNameSet = false;
            for (Node child : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child);
                if ("name".equals(nodeName)) {
                    serviceConfigBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)this.getTextContent(child));
                    continue;
                }
                if ("class-name".equals(nodeName)) {
                    serviceConfigBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)this.getTextContent(child));
                    classNameSet = true;
                    continue;
                }
                if ("properties".equals(nodeName)) {
                    this.handleProperties(child, serviceConfigBuilder);
                    continue;
                }
                if (!"configuration".equals(nodeName)) continue;
                Node parser = child.getAttributes().getNamedItem("parser");
                String name = this.getTextContent(parser);
                try {
                    ServiceConfigurationParser serviceConfigurationParser = (ServiceConfigurationParser)ClassLoaderUtil.newInstance(this.getClass().getClassLoader(), name);
                    Object obj = serviceConfigurationParser.parse((Element)child);
                    serviceConfigBuilder.addPropertyValue(this.xmlToJavaName("config-object"), obj);
                }
                catch (Exception e) {
                    ExceptionUtil.sneakyThrow(e);
                }
            }
            NamedNodeMap attributes = node.getAttributes();
            Node classNameNode = attributes.getNamedItem("class-name");
            if (classNameNode != null) {
                serviceConfigBuilder.addPropertyValue("className", (Object)this.getTextContent(classNameNode));
            }
            if ((implNode = attributes.getNamedItem("implementation")) != null) {
                serviceConfigBuilder.addPropertyReference("implementation", this.getTextContent(implNode));
            }
            Assert.isTrue((classNameSet || classNameNode != null || implNode != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create ServiceConfig!");
            return beanDefinition;
        }

        public void handleReplicatedMap(Node node) {
            BeanDefinitionBuilder replicatedMapConfigBuilder = this.createBeanBuilder(ReplicatedMapConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, replicatedMapConfigBuilder, new String[0]);
            for (Node childNode : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(childNode);
                if ("entry-listeners".equals(nodeName)) {
                    ManagedList listeners = this.parseListeners(childNode, EntryListenerConfig.class);
                    replicatedMapConfigBuilder.addPropertyValue("listenerConfigs", (Object)listeners);
                    continue;
                }
                if ("quorum-ref".equals(nodeName)) {
                    replicatedMapConfigBuilder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
                    continue;
                }
                if (!"merge-policy".equals(nodeName)) continue;
                this.handleMergePolicyConfig(childNode, replicatedMapConfigBuilder);
            }
            this.replicatedMapManagedMap.put((Object)name, (Object)replicatedMapConfigBuilder.getBeanDefinition());
        }

        public void handleNetwork(Node node) {
            BeanDefinitionBuilder networkConfigBuilder = this.createBeanBuilder(NetworkConfig.class);
            AbstractBeanDefinition beanDefinition = networkConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, networkConfigBuilder, new String[0]);
            for (Node child : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child);
                if ("join".equals(nodeName)) {
                    this.handleJoin(child, networkConfigBuilder);
                    continue;
                }
                if ("interfaces".equals(nodeName)) {
                    this.handleInterfaces(child, networkConfigBuilder);
                    continue;
                }
                if ("symmetric-encryption".equals(nodeName)) {
                    this.handleSymmetricEncryption(child, networkConfigBuilder);
                    continue;
                }
                if ("ssl".equals(nodeName)) {
                    this.handleSSLConfig(child, networkConfigBuilder);
                    continue;
                }
                if ("socket-interceptor".equals(nodeName)) {
                    this.handleSocketInterceptorConfig(child, networkConfigBuilder);
                    continue;
                }
                if ("outbound-ports".equals(nodeName)) {
                    this.handleOutboundPorts(child, networkConfigBuilder);
                    continue;
                }
                if ("reuse-address".equals(nodeName)) {
                    this.handleReuseAddress(child, networkConfigBuilder);
                    continue;
                }
                if ("member-address-provider".equals(nodeName)) {
                    this.handleMemberAddressProvider(child, networkConfigBuilder);
                    continue;
                }
                if (!"failure-detector".equals(nodeName)) continue;
                this.handleFailureDetector(child, networkConfigBuilder);
            }
            this.configBuilder.addPropertyValue("networkConfig", (Object)beanDefinition);
        }

        public void handleGroup(Node node) {
            this.createAndFillBeanBuilder(node, GroupConfig.class, "groupConfig", this.configBuilder, new String[0]);
        }

        public void handleProperties(Node node) {
            this.handleProperties(node, this.configBuilder);
        }

        public void handleInterfaces(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(InterfacesConfig.class);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null) {
                for (int a = 0; a < attributes.getLength(); ++a) {
                    Node att = attributes.item(a);
                    String name = this.xmlToJavaName(att.getNodeName());
                    String value = att.getNodeValue();
                    builder.addPropertyValue(name, (Object)value);
                }
            }
            ManagedList interfacesSet = new ManagedList();
            for (Node n : SpringXmlConfigBuilder.childElements(node)) {
                String name = this.xmlToJavaName(SpringXmlConfigBuilder.cleanNodeName(n));
                String value = this.getTextContent(n);
                if (!"interface".equals(name)) continue;
                interfacesSet.add((Object)value);
            }
            builder.addPropertyValue("interfaces", (Object)interfacesSet);
            networkConfigBuilder.addPropertyValue("interfaces", (Object)beanDefinition);
        }

        public void handleJoin(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            BeanDefinitionBuilder joinConfigBuilder = this.createBeanBuilder(JoinConfig.class);
            AbstractBeanDefinition beanDefinition = joinConfigBuilder.getBeanDefinition();
            for (Node child : SpringXmlConfigBuilder.childElements(node)) {
                String name = SpringXmlConfigBuilder.cleanNodeName(child);
                if ("multicast".equals(name)) {
                    this.handleMulticast(child, joinConfigBuilder);
                    continue;
                }
                if ("tcp-ip".equals(name)) {
                    this.handleTcpIp(child, joinConfigBuilder);
                    continue;
                }
                if ("aws".equals(name)) {
                    this.handleAws(child, joinConfigBuilder);
                    continue;
                }
                if (!"discovery-strategies".equals(name)) continue;
                this.handleDiscoveryStrategies(child, joinConfigBuilder);
            }
            networkConfigBuilder.addPropertyValue("join", (Object)beanDefinition);
        }

        private void handleOutboundPorts(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            ManagedList outboundPorts = new ManagedList();
            for (Node child : SpringXmlConfigBuilder.childElements(node)) {
                String name = SpringXmlConfigBuilder.cleanNodeName(child);
                if (!"ports".equals(name)) continue;
                String value = this.getTextContent(child);
                outboundPorts.add((Object)value);
            }
            networkConfigBuilder.addPropertyValue("outboundPortDefinitions", (Object)outboundPorts);
        }

        private void handleReuseAddress(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            String value = node.getTextContent();
            networkConfigBuilder.addPropertyValue("reuseAddress", (Object)value);
        }

        private void handleMemberAddressProvider(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            BeanDefinitionBuilder memberAddressProviderConfigBuilder = this.createBeanBuilder(MemberAddressProviderConfig.class);
            for (Node child : SpringXmlConfigBuilder.childElements(node)) {
                if (!"properties".equals(SpringXmlConfigBuilder.cleanNodeName(child))) continue;
                this.handleProperties(child, memberAddressProviderConfigBuilder);
                break;
            }
            String implementationAttr = "implementation";
            String classNameAttr = "class-name";
            String implementationValue = this.getAttribute(node, implementationAttr);
            String classNameValue = this.getAttribute(node, classNameAttr);
            memberAddressProviderConfigBuilder.addPropertyValue("enabled", (Object)SpringXmlConfigBuilder.getBooleanValue(this.getAttribute(node, "enabled")));
            if (!StringUtil.isNullOrEmpty(implementationValue)) {
                memberAddressProviderConfigBuilder.addPropertyReference(implementationAttr, implementationValue);
            } else {
                if (StringUtil.isNullOrEmpty(classNameValue)) {
                    throw new InvalidConfigurationException("One of the \"class-name\" or \"implementation\" configuration is needed for member address provider configuration");
                }
                memberAddressProviderConfigBuilder.addPropertyValue("className", (Object)classNameValue);
            }
            networkConfigBuilder.addPropertyValue("memberAddressProviderConfig", (Object)memberAddressProviderConfigBuilder.getBeanDefinition());
        }

        private void handleFailureDetector(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            if (!node.hasChildNodes()) {
                return;
            }
            for (Node child : SpringXmlConfigBuilder.childElements(node)) {
                if (!SpringXmlConfigBuilder.cleanNodeName(child).equals("icmp")) {
                    throw new IllegalStateException("Unsupported child under Failure-Detector");
                }
                Node enabledNode = child.getAttributes().getNamedItem("enabled");
                boolean enabled = enabledNode != null && SpringXmlConfigBuilder.getBooleanValue(this.getTextContent(enabledNode));
                BeanDefinitionBuilder icmpFailureDetectorConfigBuilder = this.createBeanBuilder(IcmpFailureDetectorConfig.class);
                icmpFailureDetectorConfigBuilder.addPropertyValue("enabled", (Object)enabled);
                for (Node n : SpringXmlConfigBuilder.childElements(child)) {
                    String nodeName = SpringXmlConfigBuilder.cleanNodeName(n);
                    if (nodeName.equals("ttl")) {
                        int ttl = Integer.parseInt(this.getTextContent(n));
                        icmpFailureDetectorConfigBuilder.addPropertyValue("ttl", (Object)ttl);
                        continue;
                    }
                    if (nodeName.equals("timeout-milliseconds")) {
                        int timeout = Integer.parseInt(this.getTextContent(n));
                        icmpFailureDetectorConfigBuilder.addPropertyValue("timeoutMilliseconds", (Object)timeout);
                        continue;
                    }
                    if (nodeName.equals("parallel-mode")) {
                        boolean mode = Boolean.parseBoolean(this.getTextContent(n));
                        icmpFailureDetectorConfigBuilder.addPropertyValue("parallelMode", (Object)mode);
                        continue;
                    }
                    if (nodeName.equals("fail-fast-on-startup")) {
                        boolean failOnStartup = Boolean.parseBoolean(this.getTextContent(n));
                        icmpFailureDetectorConfigBuilder.addPropertyValue("failFastOnStartup", (Object)failOnStartup);
                        continue;
                    }
                    if (nodeName.equals("max-attempts")) {
                        int attempts = Integer.parseInt(this.getTextContent(n));
                        icmpFailureDetectorConfigBuilder.addPropertyValue("maxAttempts", (Object)attempts);
                        continue;
                    }
                    if (!nodeName.equals("interval-milliseconds")) continue;
                    int interval = Integer.parseInt(this.getTextContent(n));
                    icmpFailureDetectorConfigBuilder.addPropertyValue("intervalMilliseconds", (Object)interval);
                }
                networkConfigBuilder.addPropertyValue("icmpFailureDetectorConfig", (Object)icmpFailureDetectorConfigBuilder.getBeanDefinition());
            }
        }

        private void handleSSLConfig(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            String implementation;
            BeanDefinitionBuilder sslConfigBuilder = this.createBeanBuilder(SSLConfig.class);
            String implAttribute = "factory-implementation";
            this.fillAttributeValues(node, sslConfigBuilder, implAttribute);
            Node implNode = node.getAttributes().getNamedItem(implAttribute);
            String string = implementation = implNode != null ? this.getTextContent(implNode) : null;
            if (implementation != null) {
                sslConfigBuilder.addPropertyReference(this.xmlToJavaName(implAttribute), implementation);
            }
            for (Node child : SpringXmlConfigBuilder.childElements(node)) {
                String name = SpringXmlConfigBuilder.cleanNodeName(child);
                if (!"properties".equals(name)) continue;
                this.handleProperties(child, sslConfigBuilder);
            }
            networkConfigBuilder.addPropertyValue("SSLConfig", (Object)sslConfigBuilder.getBeanDefinition());
        }

        public void handleSymmetricEncryption(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            this.createAndFillBeanBuilder(node, SymmetricEncryptionConfig.class, "symmetricEncryptionConfig", networkConfigBuilder, new String[0]);
        }

        public void handleExecutor(Node node) {
            this.createAndFillListedBean(node, ExecutorConfig.class, "name", this.executorManagedMap, new String[0]);
        }

        public void handleDurableExecutor(Node node) {
            this.createAndFillListedBean(node, DurableExecutorConfig.class, "name", this.durableExecutorManagedMap, new String[0]);
        }

        public void handleScheduledExecutor(Node node) {
            BeanDefinitionBuilder builder = this.createAndFillListedBean(node, ScheduledExecutorConfig.class, "name", this.scheduledExecutorManagedMap, "mergePolicy");
            for (Node n : SpringXmlConfigBuilder.childElements(node)) {
                String name = SpringXmlConfigBuilder.cleanNodeName(n);
                if (!"merge-policy".equals(name)) continue;
                this.handleMergePolicyConfig(n, builder);
            }
        }

        public void handleCardinalityEstimator(Node node) {
            BeanDefinitionBuilder builder = this.createAndFillListedBean(node, CardinalityEstimatorConfig.class, "name", this.cardinalityEstimatorManagedMap, "mergePolicy");
            for (Node n : SpringXmlConfigBuilder.childElements(node)) {
                String name = SpringXmlConfigBuilder.cleanNodeName(n);
                if (!"merge-policy".equals(name)) continue;
                this.handleMergePolicyConfig(n, builder);
            }
        }

        public void handlePNCounter(Node node) {
            this.createAndFillListedBean(node, PNCounterConfig.class, "name", this.pnCounterManagedMap, new String[0]);
        }

        public void handleMulticast(Node node, BeanDefinitionBuilder joinConfigBuilder) {
            BeanDefinitionBuilder builder = this.createAndFillBeanBuilder(node, MulticastConfig.class, "multicastConfig", joinConfigBuilder, "trusted-interfaces", "interface");
            ManagedList interfaces = new ManagedList();
            for (Node n : SpringXmlConfigBuilder.childElements(node)) {
                String name = SpringXmlConfigBuilder.cleanNodeName(n);
                if (!"trusted-interfaces".equals(name)) continue;
                for (Node i : SpringXmlConfigBuilder.childElements(n)) {
                    name = SpringXmlConfigBuilder.cleanNodeName(i);
                    if (!"interface".equals(name)) continue;
                    String value = this.getTextContent(i);
                    interfaces.add((Object)value);
                }
            }
            builder.addPropertyValue("trustedInterfaces", (Object)interfaces);
        }

        public void handleTcpIp(Node node, BeanDefinitionBuilder joinConfigBuilder) {
            BeanDefinitionBuilder builder = this.createAndFillBeanBuilder(node, TcpIpConfig.class, "tcpIpConfig", joinConfigBuilder, "interface", "member", "members");
            ManagedList members = new ManagedList();
            for (Node n : SpringXmlConfigBuilder.childElements(node)) {
                String name = SpringXmlConfigBuilder.cleanNodeName(n);
                if (!"member".equals(name) && !"members".equals(name) && !"interface".equals(name)) continue;
                String value = this.getTextContent(n);
                members.add((Object)value);
            }
            builder.addPropertyValue("members", (Object)members);
        }

        public void handleAws(Node node, BeanDefinitionBuilder builder) {
            this.createAndFillBeanBuilder(node, AwsConfig.class, "awsConfig", builder, new String[0]);
        }

        public void handleReliableTopic(Node node) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(ReliableTopicConfig.class);
            this.fillAttributeValues(node, builder, new String[0]);
            for (Node childNode : SpringXmlConfigBuilder.childElements(node)) {
                if (!"message-listeners".equals(SpringXmlConfigBuilder.cleanNodeName(childNode))) continue;
                ManagedList listeners = this.parseListeners(childNode, ListenerConfig.class);
                builder.addPropertyValue("messageListenerConfigs", (Object)listeners);
            }
            this.reliableTopicManagedMap.put((Object)this.getAttribute(node, "name"), (Object)builder.getBeanDefinition());
        }

        public void handleSemaphore(Node node) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(SemaphoreConfig.class);
            this.fillAttributeValues(node, builder, new String[0]);
            for (Node childNode : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(childNode);
                if (!"quorum-ref".equals(nodeName)) continue;
                builder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
            }
            this.semaphoreManagedMap.put((Object)this.getAttribute(node, "name"), (Object)builder.getBeanDefinition());
        }

        public void handleLock(Node node) {
            BeanDefinitionBuilder lockConfigBuilder = this.createBeanBuilder(LockConfig.class);
            this.fillAttributeValues(node, lockConfigBuilder, new String[0]);
            for (Node childNode : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(childNode);
                if (!"quorum-ref".equals(nodeName)) continue;
                lockConfigBuilder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
            }
            this.lockManagedMap.put((Object)this.getAttribute(node, "name"), (Object)lockConfigBuilder.getBeanDefinition());
        }

        public void handleEventJournal(Node node) {
            BeanDefinitionBuilder eventJournalBuilder = this.createBeanBuilder(EventJournalConfig.class);
            this.fillAttributeValues(node, eventJournalBuilder, new String[0]);
            String mapName = this.getAttribute(node, "map-name");
            String cacheName = this.getAttribute(node, "cache-name");
            if (!StringUtil.isNullOrEmpty(mapName)) {
                this.mapEventJournalManagedMap.put((Object)mapName, (Object)eventJournalBuilder.getBeanDefinition());
            }
            if (!StringUtil.isNullOrEmpty(cacheName)) {
                this.cacheEventJournalManagedMap.put((Object)cacheName, (Object)eventJournalBuilder.getBeanDefinition());
            }
        }

        public void handleRingbuffer(Node node) {
            BeanDefinitionBuilder ringbufferConfigBuilder = this.createBeanBuilder(RingbufferConfig.class);
            this.fillAttributeValues(node, ringbufferConfigBuilder, new String[0]);
            for (Node childNode : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(childNode);
                if ("ringbuffer-store".equals(nodeName)) {
                    this.handleRingbufferStoreConfig(childNode, ringbufferConfigBuilder);
                    continue;
                }
                if ("quorum-ref".equals(nodeName)) {
                    ringbufferConfigBuilder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
                    continue;
                }
                if (!"merge-policy".equals(nodeName)) continue;
                this.handleMergePolicyConfig(childNode, ringbufferConfigBuilder);
            }
            this.ringbufferManagedMap.put((Object)this.getAttribute(node, "name"), (Object)ringbufferConfigBuilder.getBeanDefinition());
        }

        public void handleRingbufferStoreConfig(Node node, BeanDefinitionBuilder ringbufferConfigBuilder) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(RingbufferStoreConfig.class);
            for (Node child : SpringXmlConfigBuilder.childElements(node)) {
                if (!"properties".equals(SpringXmlConfigBuilder.cleanNodeName(child))) continue;
                this.handleProperties(child, builder);
                break;
            }
            this.extractBasicStoreConfig(node, builder);
            ringbufferConfigBuilder.addPropertyValue("ringbufferStoreConfig", (Object)builder.getBeanDefinition());
        }

        public void handleAtomicLong(Node node) {
            BeanDefinitionBuilder atomicLongConfigBuilder = this.createBeanBuilder(AtomicLongConfig.class);
            this.fillAttributeValues(node, atomicLongConfigBuilder, new String[0]);
            for (Node childNode : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(childNode);
                if ("merge-policy".equals(nodeName)) {
                    this.handleMergePolicyConfig(childNode, atomicLongConfigBuilder);
                    continue;
                }
                if (!"quorum-ref".equals(nodeName)) continue;
                atomicLongConfigBuilder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
            }
            this.atomicLongManagedMap.put((Object)this.getAttribute(node, "name"), (Object)atomicLongConfigBuilder.getBeanDefinition());
        }

        public void handleAtomicReference(Node node) {
            BeanDefinitionBuilder atomicReferenceConfigBuilder = this.createBeanBuilder(AtomicReferenceConfig.class);
            this.fillAttributeValues(node, atomicReferenceConfigBuilder, new String[0]);
            for (Node childNode : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(childNode);
                if ("merge-policy".equals(nodeName)) {
                    this.handleMergePolicyConfig(childNode, atomicReferenceConfigBuilder);
                    continue;
                }
                if (!"quorum-ref".equals(nodeName)) continue;
                atomicReferenceConfigBuilder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
            }
            this.atomicReferenceManagedMap.put((Object)this.getAttribute(node, "name"), (Object)atomicReferenceConfigBuilder.getBeanDefinition());
        }

        public void handleCountDownLatch(Node node) {
            BeanDefinitionBuilder countDownLatchConfigBuilder = this.createBeanBuilder(CountDownLatchConfig.class);
            this.fillAttributeValues(node, countDownLatchConfigBuilder, new String[0]);
            for (Node childNode : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(childNode);
                if (!"quorum-ref".equals(nodeName)) continue;
                countDownLatchConfigBuilder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
            }
            this.countDownLatchManagedMap.put((Object)this.getAttribute(node, "name"), (Object)countDownLatchConfigBuilder.getBeanDefinition());
        }

        public void handleQueue(Node node) {
            BeanDefinitionBuilder queueConfigBuilder = this.createBeanBuilder(QueueConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, queueConfigBuilder, new String[0]);
            for (Node childNode : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(childNode);
                if ("item-listeners".equals(nodeName)) {
                    ManagedList listeners = this.parseListeners(childNode, ItemListenerConfig.class);
                    queueConfigBuilder.addPropertyValue("itemListenerConfigs", (Object)listeners);
                    continue;
                }
                if ("queue-store".equals(nodeName)) {
                    this.handleQueueStoreConfig(childNode, queueConfigBuilder);
                    continue;
                }
                if ("quorum-ref".equals(nodeName)) {
                    queueConfigBuilder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
                    continue;
                }
                if (!"merge-policy".equals(nodeName)) continue;
                this.handleMergePolicyConfig(childNode, queueConfigBuilder);
            }
            this.queueManagedMap.put((Object)name, (Object)queueConfigBuilder.getBeanDefinition());
        }

        public void handleQueueStoreConfig(Node node, BeanDefinitionBuilder queueConfigBuilder) {
            BeanDefinitionBuilder queueStoreConfigBuilder = this.createBeanBuilder(QueueStoreConfig.class);
            AbstractBeanDefinition beanDefinition = queueStoreConfigBuilder.getBeanDefinition();
            for (Node child : SpringXmlConfigBuilder.childElements(node)) {
                if (!"properties".equals(SpringXmlConfigBuilder.cleanNodeName(child))) continue;
                this.handleProperties(child, queueStoreConfigBuilder);
                break;
            }
            String storeImplAttrName = "store-implementation";
            String factoryImplAttrName = "factory-implementation";
            this.fillAttributeValues(node, queueStoreConfigBuilder, storeImplAttrName, factoryImplAttrName);
            NamedNodeMap attributes = node.getAttributes();
            Node implRef = attributes.getNamedItem(storeImplAttrName);
            Node factoryImplRef = attributes.getNamedItem(factoryImplAttrName);
            if (factoryImplRef != null) {
                queueStoreConfigBuilder.addPropertyReference(this.xmlToJavaName(factoryImplAttrName), this.getTextContent(factoryImplRef));
            }
            if (implRef != null) {
                queueStoreConfigBuilder.addPropertyReference(this.xmlToJavaName(storeImplAttrName), this.getTextContent(implRef));
            }
            queueConfigBuilder.addPropertyValue("queueStoreConfig", (Object)beanDefinition);
        }

        private void extractBasicStoreConfig(Node node, BeanDefinitionBuilder builder) {
            String storeImplAttrName = "implementation";
            String factoryImplAttrName = "factory-implementation";
            this.fillAttributeValues(node, builder, storeImplAttrName, factoryImplAttrName);
            String implRef = this.getAttribute(node, storeImplAttrName);
            String factoryImplRef = this.getAttribute(node, factoryImplAttrName);
            if (factoryImplRef != null) {
                builder.addPropertyReference(this.xmlToJavaName(factoryImplAttrName), factoryImplRef);
            }
            if (implRef != null) {
                builder.addPropertyReference(this.xmlToJavaName("store-implementation"), implRef);
            }
        }

        public void handleList(Node node) {
            BeanDefinitionBuilder listConfigBuilder = this.createBeanBuilder(ListConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, listConfigBuilder, new String[0]);
            for (Node childNode : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(childNode);
                if ("item-listeners".equals(nodeName)) {
                    ManagedList listeners = this.parseListeners(childNode, ItemListenerConfig.class);
                    listConfigBuilder.addPropertyValue("itemListenerConfigs", (Object)listeners);
                    continue;
                }
                if ("quorum-ref".equals(nodeName)) {
                    listConfigBuilder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
                    continue;
                }
                if (!"merge-policy".equals(nodeName)) continue;
                this.handleMergePolicyConfig(childNode, listConfigBuilder);
            }
            this.listManagedMap.put((Object)name, (Object)listConfigBuilder.getBeanDefinition());
        }

        public void handleSet(Node node) {
            BeanDefinitionBuilder setConfigBuilder = this.createBeanBuilder(SetConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, setConfigBuilder, new String[0]);
            for (Node childNode : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(childNode);
                if ("item-listeners".equals(nodeName)) {
                    ManagedList listeners = this.parseListeners(childNode, ItemListenerConfig.class);
                    setConfigBuilder.addPropertyValue("itemListenerConfigs", (Object)listeners);
                    continue;
                }
                if ("quorum-ref".equals(nodeName)) {
                    setConfigBuilder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
                    continue;
                }
                if (!"merge-policy".equals(nodeName)) continue;
                this.handleMergePolicyConfig(childNode, setConfigBuilder);
            }
            this.setManagedMap.put((Object)name, (Object)setConfigBuilder.getBeanDefinition());
        }

        public void handleMap(Node node) {
            Node cacheDeserializedValueNode;
            Node maxSizePolicyNode;
            BeanDefinitionBuilder mapConfigBuilder = this.createBeanBuilder(MapConfig.class);
            AbstractBeanDefinition beanDefinition = mapConfigBuilder.getBeanDefinition();
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            mapConfigBuilder.addPropertyValue("name", (Object)name);
            this.fillAttributeValues(node, mapConfigBuilder, "maxSize", "maxSizePolicy");
            BeanDefinitionBuilder maxSizeConfigBuilder = this.createBeanBuilder(MaxSizeConfig.class);
            AbstractBeanDefinition maxSizeConfigBeanDefinition = maxSizeConfigBuilder.getBeanDefinition();
            mapConfigBuilder.addPropertyValue("maxSizeConfig", (Object)maxSizeConfigBeanDefinition);
            Node maxSizeNode = node.getAttributes().getNamedItem("max-size");
            if (maxSizeNode != null) {
                maxSizeConfigBuilder.addPropertyValue("size", (Object)this.getTextContent(maxSizeNode));
            }
            if ((maxSizePolicyNode = node.getAttributes().getNamedItem("max-size-policy")) != null) {
                maxSizeConfigBuilder.addPropertyValue(this.xmlToJavaName(SpringXmlConfigBuilder.cleanNodeName(maxSizePolicyNode)), (Object)MaxSizeConfig.MaxSizePolicy.valueOf(this.getTextContent(maxSizePolicyNode)));
            }
            if ((cacheDeserializedValueNode = node.getAttributes().getNamedItem("cache-deserialized-values")) != null) {
                mapConfigBuilder.addPropertyValue("cacheDeserializedValues", (Object)this.getTextContent(cacheDeserializedValueNode));
            }
            for (Node childNode : SpringXmlConfigBuilder.childElements(node)) {
                ManagedList listeners;
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(childNode);
                if ("map-store".equals(nodeName)) {
                    this.handleMapStoreConfig(childNode, mapConfigBuilder);
                    continue;
                }
                if ("near-cache".equals(nodeName)) {
                    this.handleNearCacheConfig(childNode, mapConfigBuilder);
                    continue;
                }
                if ("wan-replication-ref".equals(nodeName)) {
                    this.handleWanReplicationRef(mapConfigBuilder, childNode);
                    continue;
                }
                if ("indexes".equals(nodeName)) {
                    ManagedList indexes = new ManagedList();
                    for (Node indexNode : SpringXmlConfigBuilder.childElements(childNode)) {
                        BeanDefinitionBuilder indexConfBuilder = this.createBeanBuilder(MapIndexConfig.class);
                        this.fillAttributeValues(indexNode, indexConfBuilder, new String[0]);
                        indexes.add((Object)indexConfBuilder.getBeanDefinition());
                    }
                    mapConfigBuilder.addPropertyValue("mapIndexConfigs", (Object)indexes);
                    continue;
                }
                if ("attributes".equals(nodeName)) {
                    ManagedList attributes = new ManagedList();
                    for (Node attributeNode : SpringXmlConfigBuilder.childElements(childNode)) {
                        BeanDefinitionBuilder attributeConfBuilder = this.createBeanBuilder(MapAttributeConfig.class);
                        this.fillAttributeValues(attributeNode, attributeConfBuilder, new String[0]);
                        attributes.add((Object)attributeConfBuilder.getBeanDefinition());
                    }
                    mapConfigBuilder.addPropertyValue("mapAttributeConfigs", (Object)attributes);
                    continue;
                }
                if ("entry-listeners".equals(nodeName)) {
                    listeners = this.parseListeners(childNode, EntryListenerConfig.class);
                    mapConfigBuilder.addPropertyValue("entryListenerConfigs", (Object)listeners);
                    continue;
                }
                if ("quorum-ref".equals(nodeName)) {
                    mapConfigBuilder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
                    continue;
                }
                if ("merge-policy".equals(nodeName)) {
                    this.handleMergePolicyConfig(childNode, mapConfigBuilder);
                    continue;
                }
                if ("query-caches".equals(nodeName)) {
                    ManagedList queryCaches = this.getQueryCaches(childNode);
                    mapConfigBuilder.addPropertyValue("queryCacheConfigs", (Object)queryCaches);
                    continue;
                }
                if ("partition-lost-listeners".endsWith(nodeName)) {
                    listeners = this.parseListeners(childNode, MapPartitionLostListenerConfig.class);
                    mapConfigBuilder.addPropertyValue("partitionLostListenerConfigs", (Object)listeners);
                    continue;
                }
                if ("hot-restart".equals(nodeName)) {
                    this.handleHotRestartConfig(mapConfigBuilder, childNode);
                    continue;
                }
                if ("map-eviction-policy".equals(nodeName)) {
                    this.handleMapEvictionPolicyConfig(mapConfigBuilder, childNode);
                    continue;
                }
                if (!"partition-strategy".equals(nodeName)) continue;
                PartitioningStrategyConfig psConfig = new PartitioningStrategyConfig(this.getTextContent(childNode));
                mapConfigBuilder.addPropertyValue("partitioningStrategyConfig", (Object)psConfig);
            }
            this.mapConfigManagedMap.put((Object)name, (Object)beanDefinition);
        }

        private void handleMapEvictionPolicyConfig(BeanDefinitionBuilder mapConfigBuilder, Node childNode) {
            String className;
            NamedNodeMap attributes = childNode.getAttributes();
            Node implementationNode = attributes.getNamedItem("implementation");
            Node classNameNode = attributes.getNamedItem("class-name");
            String implementation = implementationNode != null ? this.getTextContent(implementationNode) : null;
            String string = className = classNameNode != null ? this.getTextContent(classNameNode) : null;
            if (implementation != null) {
                mapConfigBuilder.addPropertyReference("mapEvictionPolicy", implementation);
            } else if (className != null) {
                className = Preconditions.checkHasText(className, "map-eviction-policy `className` cannot be null or empty");
                try {
                    MapEvictionPolicy mapEvictionPolicy = (MapEvictionPolicy)ClassLoaderUtil.newInstance(this.getClass().getClassLoader(), className);
                    mapConfigBuilder.addPropertyValue("mapEvictionPolicy", (Object)mapEvictionPolicy);
                }
                catch (Exception e) {
                    throw ExceptionUtil.rethrow(e);
                }
            } else {
                throw new IllegalArgumentException("One of `className` or `implementation` attributes is required to create map-eviction-policy");
            }
        }

        private void handleHotRestartConfig(BeanDefinitionBuilder configBuilder, Node node) {
            BeanDefinitionBuilder hotRestartConfigBuilder = this.createBeanBuilder(HotRestartConfig.class);
            this.fillAttributeValues(node, hotRestartConfigBuilder, new String[0]);
            configBuilder.addPropertyValue("hotRestartConfig", (Object)hotRestartConfigBuilder.getBeanDefinition());
        }

        private ManagedList getQueryCaches(Node childNode) {
            ManagedList queryCaches = new ManagedList();
            for (Node queryCacheNode : SpringXmlConfigBuilder.childElements(childNode)) {
                BeanDefinitionBuilder beanDefinitionBuilder = this.parseQueryCaches(queryCacheNode);
                queryCaches.add((Object)beanDefinitionBuilder.getBeanDefinition());
            }
            return queryCaches;
        }

        private BeanDefinitionBuilder parseQueryCaches(Node queryCacheNode) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(QueryCacheConfig.class);
            for (Node node : SpringXmlConfigBuilder.childElements(queryCacheNode)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(node);
                String textContent = this.getTextContent(node);
                NamedNodeMap attributes = queryCacheNode.getAttributes();
                String cacheName = this.getTextContent(attributes.getNamedItem("name"));
                builder.addPropertyValue("name", (Object)cacheName);
                if ("predicate".equals(nodeName)) {
                    BeanDefinitionBuilder predicateBuilder = this.createBeanBuilder(PredicateConfig.class);
                    String predicateType = this.getTextContent(node.getAttributes().getNamedItem("type"));
                    if ("sql".equals(predicateType)) {
                        predicateBuilder.addPropertyValue("sql", (Object)textContent);
                    } else if ("class-name".equals(predicateType)) {
                        predicateBuilder.addPropertyValue("className", (Object)textContent);
                    }
                    builder.addPropertyValue("predicateConfig", (Object)predicateBuilder.getBeanDefinition());
                    continue;
                }
                if ("entry-listeners".equals(nodeName)) {
                    ManagedList listeners = new ManagedList();
                    String implementationAttr = "implementation";
                    for (Node listenerNode : SpringXmlConfigBuilder.childElements(node)) {
                        BeanDefinitionBuilder listenerConfBuilder = this.createBeanBuilder(EntryListenerConfig.class);
                        this.fillAttributeValues(listenerNode, listenerConfBuilder, implementationAttr);
                        Node implementationNode = listenerNode.getAttributes().getNamedItem(implementationAttr);
                        if (implementationNode != null) {
                            listenerConfBuilder.addPropertyReference(implementationAttr, this.getTextContent(implementationNode));
                        }
                        listeners.add((Object)listenerConfBuilder.getBeanDefinition());
                    }
                    builder.addPropertyValue("entryListenerConfigs", (Object)listeners);
                    continue;
                }
                if ("include-value".equals(nodeName)) {
                    boolean includeValue = SpringXmlConfigBuilder.getBooleanValue(textContent);
                    builder.addPropertyValue("includeValue", (Object)includeValue);
                    continue;
                }
                if ("batch-size".equals(nodeName)) {
                    int batchSize = SpringXmlConfigBuilder.getIntegerValue("batch-size", textContent.trim());
                    builder.addPropertyValue("batchSize", (Object)batchSize);
                    continue;
                }
                if ("buffer-size".equals(nodeName)) {
                    int bufferSize = SpringXmlConfigBuilder.getIntegerValue("buffer-size", textContent.trim());
                    builder.addPropertyValue("bufferSize", (Object)bufferSize);
                    continue;
                }
                if ("delay-seconds".equals(nodeName)) {
                    int delaySeconds = SpringXmlConfigBuilder.getIntegerValue("delay-seconds", textContent.trim());
                    builder.addPropertyValue("delaySeconds", (Object)delaySeconds);
                    continue;
                }
                if ("in-memory-format".equals(nodeName)) {
                    String value = textContent.trim();
                    builder.addPropertyValue("inMemoryFormat", (Object)InMemoryFormat.valueOf(StringUtil.upperCaseInternal(value)));
                    continue;
                }
                if ("coalesce".equals(nodeName)) {
                    boolean coalesce = SpringXmlConfigBuilder.getBooleanValue(textContent);
                    builder.addPropertyValue("coalesce", (Object)coalesce);
                    continue;
                }
                if ("populate".equals(nodeName)) {
                    boolean populate = SpringXmlConfigBuilder.getBooleanValue(textContent);
                    builder.addPropertyValue("populate", (Object)populate);
                    continue;
                }
                if ("indexes".equals(nodeName)) {
                    ManagedList indexes = new ManagedList();
                    for (Node indexNode : SpringXmlConfigBuilder.childElements(node)) {
                        BeanDefinitionBuilder indexConfBuilder = this.createBeanBuilder(MapIndexConfig.class);
                        this.fillAttributeValues(indexNode, indexConfBuilder, new String[0]);
                        indexes.add((Object)indexConfBuilder.getBeanDefinition());
                    }
                    builder.addPropertyValue("indexConfigs", (Object)indexes);
                    continue;
                }
                if (!"eviction".equals(nodeName)) continue;
                builder.addPropertyValue("evictionConfig", (Object)this.getEvictionConfig(node));
            }
            return builder;
        }

        public void handleCache(Node node) {
            BeanDefinitionBuilder cacheConfigBuilder = this.createBeanBuilder(CacheSimpleConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, cacheConfigBuilder, new String[0]);
            for (Node childNode : SpringXmlConfigBuilder.childElements(node)) {
                ManagedList listeners;
                if ("eviction".equals(SpringXmlConfigBuilder.cleanNodeName(childNode))) {
                    cacheConfigBuilder.addPropertyValue("evictionConfig", (Object)this.getEvictionConfig(childNode));
                    continue;
                }
                if ("expiry-policy-factory".equals(SpringXmlConfigBuilder.cleanNodeName(childNode))) {
                    cacheConfigBuilder.addPropertyValue("expiryPolicyFactoryConfig", (Object)this.getExpiryPolicyFactoryConfig(childNode));
                    continue;
                }
                if ("cache-entry-listeners".equals(SpringXmlConfigBuilder.cleanNodeName(childNode))) {
                    listeners = new ManagedList();
                    for (Node listenerNode : SpringXmlConfigBuilder.childElements(childNode)) {
                        BeanDefinitionBuilder listenerConfBuilder = this.createBeanBuilder(CacheSimpleEntryListenerConfig.class);
                        this.fillAttributeValues(listenerNode, listenerConfBuilder, new String[0]);
                        listeners.add((Object)listenerConfBuilder.getBeanDefinition());
                    }
                    cacheConfigBuilder.addPropertyValue("cacheEntryListeners", (Object)listeners);
                    continue;
                }
                if ("wan-replication-ref".equals(SpringXmlConfigBuilder.cleanNodeName(childNode))) {
                    this.handleWanReplicationRef(cacheConfigBuilder, childNode);
                    continue;
                }
                if ("partition-lost-listeners".equals(SpringXmlConfigBuilder.cleanNodeName(childNode))) {
                    listeners = this.parseListeners(childNode, CachePartitionLostListenerConfig.class);
                    cacheConfigBuilder.addPropertyValue("partitionLostListenerConfigs", (Object)listeners);
                    continue;
                }
                if ("quorum-ref".equals(SpringXmlConfigBuilder.cleanNodeName(childNode))) {
                    cacheConfigBuilder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
                    continue;
                }
                if ("partition-lost-listeners".equals(SpringXmlConfigBuilder.cleanNodeName(childNode))) {
                    listeners = this.parseListeners(childNode, CachePartitionLostListenerConfig.class);
                    cacheConfigBuilder.addPropertyValue("partitionLostListenerConfigs", (Object)listeners);
                    continue;
                }
                if ("merge-policy".equals(SpringXmlConfigBuilder.cleanNodeName(childNode))) {
                    cacheConfigBuilder.addPropertyValue("mergePolicy", (Object)this.getTextContent(childNode));
                    continue;
                }
                if (!"hot-restart".equals(SpringXmlConfigBuilder.cleanNodeName(childNode))) continue;
                this.handleHotRestartConfig(cacheConfigBuilder, childNode);
            }
            this.cacheConfigManagedMap.put((Object)name, (Object)cacheConfigBuilder.getBeanDefinition());
        }

        public void handleWanReplication(Node node) {
            BeanDefinitionBuilder replicationConfigBuilder = this.createBeanBuilder(WanReplicationConfig.class);
            String name = this.getAttribute(node, "name");
            replicationConfigBuilder.addPropertyValue("name", (Object)name);
            ManagedList wanPublishers = new ManagedList();
            for (Node n : SpringXmlConfigBuilder.childElements(node)) {
                String nName = SpringXmlConfigBuilder.cleanNodeName(n);
                if ("wan-publisher".equals(nName)) {
                    BeanDefinitionBuilder publisherBuilder = this.createBeanBuilder(WanPublisherConfig.class);
                    AbstractBeanDefinition childBeanDefinition = publisherBuilder.getBeanDefinition();
                    this.fillAttributeValues(n, publisherBuilder, Collections.<String>emptyList());
                    String className = this.getAttribute(n, "class-name");
                    String implementation = this.getAttribute(n, "implementation");
                    publisherBuilder.addPropertyValue("className", (Object)className);
                    if (implementation != null) {
                        publisherBuilder.addPropertyReference("implementation", implementation);
                    }
                    Assert.isTrue((className != null || implementation != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create WanPublisherConfig!");
                    for (Node child : SpringXmlConfigBuilder.childElements(n)) {
                        String nodeName = SpringXmlConfigBuilder.cleanNodeName(child);
                        if ("properties".equals(nodeName)) {
                            this.handleProperties(child, publisherBuilder);
                            continue;
                        }
                        if ("queue-full-behavior".equals(nodeName)) {
                            publisherBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)this.getTextContent(child));
                            continue;
                        }
                        if ("queue-capacity".equals(nodeName)) {
                            publisherBuilder.addPropertyValue(this.xmlToJavaName(nodeName), (Object)this.getTextContent(child));
                            continue;
                        }
                        if ("aws".equals(nodeName)) {
                            this.handleAws(child, publisherBuilder);
                            continue;
                        }
                        if (!"discovery-strategies".equals(nodeName)) continue;
                        this.handleDiscoveryStrategies(child, publisherBuilder);
                    }
                    wanPublishers.add((Object)childBeanDefinition);
                    continue;
                }
                if (!"wan-consumer".equals(nName)) continue;
                BeanDefinitionBuilder consumerConfigBuilder = this.createBeanBuilder(WanConsumerConfig.class);
                String className = this.getAttribute(n, "class-name");
                String implementation = this.getAttribute(n, "implementation");
                consumerConfigBuilder.addPropertyValue("className", (Object)className);
                if (implementation != null) {
                    consumerConfigBuilder.addPropertyReference("implementation", implementation);
                }
                Assert.isTrue((className != null || implementation != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create WanConsumerConfig!");
                for (Node child : SpringXmlConfigBuilder.childElements(n)) {
                    String nodeName = SpringXmlConfigBuilder.cleanNodeName(child);
                    if (!"properties".equals(nodeName)) continue;
                    this.handleProperties(child, consumerConfigBuilder);
                }
                replicationConfigBuilder.addPropertyValue("wanConsumerConfig", (Object)consumerConfigBuilder.getBeanDefinition());
            }
            replicationConfigBuilder.addPropertyValue("wanPublisherConfigs", (Object)wanPublishers);
            this.wanReplicationManagedMap.put((Object)name, (Object)replicationConfigBuilder.getBeanDefinition());
        }

        private void handlePartitionGroup(Node node) {
            BeanDefinitionBuilder partitionConfigBuilder = this.createBeanBuilder(PartitionGroupConfig.class);
            this.fillAttributeValues(node, partitionConfigBuilder, new String[0]);
            ManagedList memberGroups = new ManagedList();
            for (Node child : SpringXmlConfigBuilder.childElements(node)) {
                String name = SpringXmlConfigBuilder.cleanNodeName(child);
                if (!"member-group".equals(name)) continue;
                BeanDefinitionBuilder memberGroupBuilder = this.createBeanBuilder(MemberGroupConfig.class);
                ManagedList interfaces = new ManagedList();
                for (Node n : SpringXmlConfigBuilder.childElements(child)) {
                    if (!"interface".equals(SpringXmlConfigBuilder.cleanNodeName(n))) continue;
                    interfaces.add((Object)this.getTextContent(n));
                }
                memberGroupBuilder.addPropertyValue("interfaces", (Object)interfaces);
                memberGroups.add((Object)memberGroupBuilder.getBeanDefinition());
            }
            partitionConfigBuilder.addPropertyValue("memberGroupConfigs", (Object)memberGroups);
            this.configBuilder.addPropertyValue("partitionGroupConfig", (Object)partitionConfigBuilder.getBeanDefinition());
        }

        private void handleManagementCenter(Node node) {
            BeanDefinitionBuilder managementCenterConfigBuilder = this.createBeanBuilder(ManagementCenterConfig.class);
            this.fillAttributeValues(node, managementCenterConfigBuilder, new String[0]);
            boolean isComplexType = false;
            List<String> complexTypeElements = Arrays.asList("url", "mutual-auth");
            for (Node c : SpringXmlConfigBuilder.childElements(node)) {
                if (!complexTypeElements.contains(SpringXmlConfigBuilder.cleanNodeName(c))) continue;
                isComplexType = true;
                break;
            }
            if (isComplexType) {
                for (Node child : SpringXmlConfigBuilder.childElements(node)) {
                    if ("url".equals(SpringXmlConfigBuilder.cleanNodeName(child))) {
                        String url = this.getTextContent(child);
                        managementCenterConfigBuilder.addPropertyValue("url", (Object)url);
                        continue;
                    }
                    if (!"mutual-auth".equals(SpringXmlConfigBuilder.cleanNodeName(child))) continue;
                    managementCenterConfigBuilder.addPropertyValue("mutualAuthConfig", (Object)this.handleMcMutualAuthConfig(child).getBeanDefinition());
                }
            }
            this.configBuilder.addPropertyValue("managementCenterConfig", (Object)managementCenterConfigBuilder.getBeanDefinition());
        }

        private BeanDefinitionBuilder handleMcMutualAuthConfig(Node node) {
            BeanDefinitionBuilder mcMutualAuthConfigBuilder = this.createBeanBuilder(MCMutualAuthConfig.class);
            this.fillAttributeValues(node, mcMutualAuthConfigBuilder, new String[0]);
            for (Node n : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(n);
                if ("factory-class-name".equals(nodeName)) {
                    mcMutualAuthConfigBuilder.addPropertyValue("factoryClassName", (Object)this.getTextContent(n).trim());
                    continue;
                }
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(n, mcMutualAuthConfigBuilder);
            }
            return mcMutualAuthConfigBuilder;
        }

        public void handleNearCacheConfig(Node node, BeanDefinitionBuilder configBuilder) {
            BeanDefinitionBuilder nearCacheConfigBuilder = this.createBeanBuilder(NearCacheConfig.class);
            this.fillAttributeValues(node, nearCacheConfigBuilder, new String[0]);
            for (Node childNode : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(childNode);
                if (!"eviction".equals(nodeName)) continue;
                this.handleEvictionConfig(childNode, nearCacheConfigBuilder);
            }
            configBuilder.addPropertyValue("nearCacheConfig", (Object)nearCacheConfigBuilder.getBeanDefinition());
        }

        private void handleEvictionConfig(Node node, BeanDefinitionBuilder configBuilder) {
            configBuilder.addPropertyValue("evictionConfig", (Object)this.getEvictionConfig(node));
        }

        private CacheSimpleConfig.ExpiryPolicyFactoryConfig getExpiryPolicyFactoryConfig(Node node) {
            String className = this.getAttribute(node, "class-name");
            if (!StringUtil.isNullOrEmpty(className)) {
                return new CacheSimpleConfig.ExpiryPolicyFactoryConfig(className);
            }
            CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig timedExpiryPolicyFactoryConfig = null;
            for (Node n : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(n);
                if (!"timed-expiry-policy-factory".equals(nodeName)) continue;
                String expiryPolicyTypeStr = this.getAttribute(n, "expiry-policy-type");
                String durationAmountStr = this.getAttribute(n, "duration-amount");
                String timeUnitStr = this.getAttribute(n, "time-unit");
                CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType expiryPolicyType = CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType.valueOf(StringUtil.upperCaseInternal(expiryPolicyTypeStr));
                if (expiryPolicyType != CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType.ETERNAL && (StringUtil.isNullOrEmpty(durationAmountStr) || StringUtil.isNullOrEmpty(timeUnitStr))) {
                    throw new InvalidConfigurationException("Both of the \"duration-amount\" or \"time-unit\" attributes are required for expiry policy factory configuration (except \"ETERNAL\" expiry policy type)");
                }
                CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig durationConfig = null;
                if (expiryPolicyType != CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType.ETERNAL) {
                    long durationAmount = Long.parseLong(durationAmountStr);
                    TimeUnit timeUnit = TimeUnit.valueOf(StringUtil.upperCaseInternal(timeUnitStr));
                    durationConfig = new CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig(durationAmount, timeUnit);
                }
                timedExpiryPolicyFactoryConfig = new CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig(expiryPolicyType, durationConfig);
            }
            if (timedExpiryPolicyFactoryConfig == null) {
                throw new InvalidConfigurationException("One of the \"class-name\" or \"timed-expire-policy-factory\" configuration is needed for expiry policy factory configuration");
            }
            return new CacheSimpleConfig.ExpiryPolicyFactoryConfig(timedExpiryPolicyFactoryConfig);
        }

        public void handleMapStoreConfig(Node node, BeanDefinitionBuilder mapConfigBuilder) {
            BeanDefinitionBuilder mapStoreConfigBuilder = this.createBeanBuilder(MapStoreConfig.class);
            AbstractBeanDefinition beanDefinition = mapStoreConfigBuilder.getBeanDefinition();
            for (Node child : SpringXmlConfigBuilder.childElements(node)) {
                if (!"properties".equals(SpringXmlConfigBuilder.cleanNodeName(child))) continue;
                this.handleProperties(child, mapStoreConfigBuilder);
                break;
            }
            String implAttrName = "implementation";
            String factoryImplAttrName = "factory-implementation";
            String initialModeAttrName = "initial-mode";
            this.fillAttributeValues(node, mapStoreConfigBuilder, implAttrName, factoryImplAttrName, "initialMode");
            NamedNodeMap attributes = node.getAttributes();
            Node implRef = attributes.getNamedItem(implAttrName);
            Node factoryImplRef = attributes.getNamedItem(factoryImplAttrName);
            Node initialMode = attributes.getNamedItem(initialModeAttrName);
            if (factoryImplRef != null) {
                mapStoreConfigBuilder.addPropertyReference(this.xmlToJavaName(factoryImplAttrName), this.getTextContent(factoryImplRef));
            }
            if (implRef != null) {
                mapStoreConfigBuilder.addPropertyReference(this.xmlToJavaName(implAttrName), this.getTextContent(implRef));
            }
            if (initialMode != null) {
                MapStoreConfig.InitialLoadMode mode = MapStoreConfig.InitialLoadMode.valueOf(StringUtil.upperCaseInternal(this.getTextContent(initialMode)));
                mapStoreConfigBuilder.addPropertyValue("initialLoadMode", (Object)mode);
            }
            mapConfigBuilder.addPropertyValue("mapStoreConfig", (Object)beanDefinition);
        }

        public void handleMultiMap(Node node) {
            BeanDefinitionBuilder multiMapConfigBuilder = this.createBeanBuilder(MultiMapConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, multiMapConfigBuilder, new String[0]);
            for (Node childNode : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(childNode);
                if ("entry-listeners".equals(nodeName)) {
                    ManagedList listeners = this.parseListeners(childNode, EntryListenerConfig.class);
                    multiMapConfigBuilder.addPropertyValue("entryListenerConfigs", (Object)listeners);
                    continue;
                }
                if ("quorum-ref".equals(nodeName)) {
                    multiMapConfigBuilder.addPropertyValue("quorumName", (Object)this.getTextContent(childNode));
                    continue;
                }
                if (!"merge-policy".equals(nodeName)) continue;
                this.handleMergePolicyConfig(childNode, multiMapConfigBuilder);
            }
            this.multiMapManagedMap.put((Object)name, (Object)multiMapConfigBuilder.getBeanDefinition());
        }

        public void handleTopic(Node node) {
            BeanDefinitionBuilder topicConfigBuilder = this.createBeanBuilder(TopicConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, topicConfigBuilder, new String[0]);
            for (Node childNode : SpringXmlConfigBuilder.childElements(node)) {
                if ("message-listeners".equals(SpringXmlConfigBuilder.cleanNodeName(childNode))) {
                    ManagedList listeners = this.parseListeners(childNode, ListenerConfig.class);
                    topicConfigBuilder.addPropertyValue("messageListenerConfigs", (Object)listeners);
                    continue;
                }
                if ("statistics-enabled".equals(SpringXmlConfigBuilder.cleanNodeName(childNode))) {
                    String statisticsEnabled = this.getTextContent(childNode);
                    topicConfigBuilder.addPropertyValue("statisticsEnabled", (Object)statisticsEnabled);
                    continue;
                }
                if ("global-ordering-enabled".equals(SpringXmlConfigBuilder.cleanNodeName(childNode))) {
                    String globalOrderingEnabled = this.getTextContent(childNode);
                    topicConfigBuilder.addPropertyValue("globalOrderingEnabled", (Object)globalOrderingEnabled);
                    continue;
                }
                if (!"multi-threading-enabled".equals(SpringXmlConfigBuilder.cleanNodeName(childNode))) continue;
                String multiThreadingEnabled = this.getTextContent(childNode);
                topicConfigBuilder.addPropertyValue("multiThreadingEnabled", (Object)multiThreadingEnabled);
            }
            this.topicManagedMap.put((Object)name, (Object)topicConfigBuilder.getBeanDefinition());
        }

        public void handleJobTracker(Node node) {
            BeanDefinitionBuilder jobTrackerConfigBuilder = this.createBeanBuilder(JobTrackerConfig.class);
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getTextContent(attName);
            this.fillAttributeValues(node, jobTrackerConfigBuilder, new String[0]);
            this.jobTrackerManagedMap.put((Object)name, (Object)jobTrackerConfigBuilder.getBeanDefinition());
        }

        private void handleSecurity(Node node) {
            BeanDefinitionBuilder securityConfigBuilder = this.createBeanBuilder(SecurityConfig.class);
            AbstractBeanDefinition beanDefinition = securityConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, securityConfigBuilder, new String[0]);
            for (Node child : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child);
                if ("member-credentials-factory".equals(nodeName)) {
                    this.handleCredentialsFactory(child, securityConfigBuilder);
                    continue;
                }
                if ("member-login-modules".equals(nodeName)) {
                    this.handleLoginModules(child, securityConfigBuilder, true);
                    continue;
                }
                if ("client-login-modules".equals(nodeName)) {
                    this.handleLoginModules(child, securityConfigBuilder, false);
                    continue;
                }
                if ("client-permission-policy".equals(nodeName)) {
                    this.handlePermissionPolicy(child, securityConfigBuilder);
                    continue;
                }
                if ("client-permissions".equals(nodeName)) {
                    this.handleSecurityPermissions(child, securityConfigBuilder);
                    continue;
                }
                if ("security-interceptors".equals(nodeName)) {
                    this.handleSecurityInterceptors(child, securityConfigBuilder);
                    continue;
                }
                if (!"client-block-unmapped-actions".equals(nodeName)) continue;
                securityConfigBuilder.addPropertyValue("clientBlockUnmappedActions", (Object)SpringXmlConfigBuilder.getBooleanValue(this.getTextContent(child)));
            }
            this.configBuilder.addPropertyValue("securityConfig", (Object)beanDefinition);
        }

        private void handleMemberAttributes(Node node) {
            BeanDefinitionBuilder memberAttributeConfigBuilder = this.createBeanBuilder(MemberAttributeConfig.class);
            AbstractBeanDefinition beanDefinition = memberAttributeConfigBuilder.getBeanDefinition();
            ManagedMap attributes = new ManagedMap();
            for (Node n : SpringXmlConfigBuilder.childElements(node)) {
                String name = SpringXmlConfigBuilder.cleanNodeName(n);
                if (!"attribute".equals(name)) continue;
                String attributeName = this.getTextContent(n.getAttributes().getNamedItem("name")).trim();
                String attributeType = this.getTextContent(n.getAttributes().getNamedItem("type")).trim();
                String value = this.getTextContent(n);
                Object oValue = "string".equals(attributeType) ? value : ("boolean".equals(attributeType) ? Boolean.valueOf(Boolean.parseBoolean(value)) : ("byte".equals(attributeType) ? Byte.valueOf(Byte.parseByte(value)) : ("double".equals(attributeType) ? Double.valueOf(Double.parseDouble(value)) : ("float".equals(attributeType) ? Float.valueOf(Float.parseFloat(value)) : ("int".equals(attributeType) ? Integer.valueOf(Integer.parseInt(value)) : ("long".equals(attributeType) ? Long.valueOf(Long.parseLong(value)) : ("short".equals(attributeType) ? Short.valueOf(Short.parseShort(value)) : value)))))));
                attributes.put((Object)attributeName, oValue);
            }
            memberAttributeConfigBuilder.addPropertyValue("attributes", (Object)attributes);
            this.configBuilder.addPropertyValue("memberAttributeConfig", (Object)beanDefinition);
        }

        private void handleNativeMemory(Node node) {
            BeanDefinitionBuilder nativeMemoryConfigBuilder = this.createBeanBuilder(NativeMemoryConfig.class);
            AbstractBeanDefinition beanDefinition = nativeMemoryConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, nativeMemoryConfigBuilder, new String[0]);
            for (Node child : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child);
                if (!"size".equals(nodeName)) continue;
                this.handleMemorySizeConfig(child, nativeMemoryConfigBuilder);
            }
            this.configBuilder.addPropertyValue("nativeMemoryConfig", (Object)beanDefinition);
        }

        private void handleMemorySizeConfig(Node node, BeanDefinitionBuilder nativeMemoryConfigBuilder) {
            BeanDefinitionBuilder memorySizeConfigBuilder = this.createBeanBuilder(MemorySize.class);
            NamedNodeMap attributes = node.getAttributes();
            Node value = attributes.getNamedItem("value");
            Node unit = attributes.getNamedItem("unit");
            memorySizeConfigBuilder.addConstructorArgValue((Object)this.getTextContent(value));
            memorySizeConfigBuilder.addConstructorArgValue((Object)MemoryUnit.valueOf(this.getTextContent(unit)));
            nativeMemoryConfigBuilder.addPropertyValue("size", (Object)memorySizeConfigBuilder.getBeanDefinition());
        }

        private void handleSecurityInterceptors(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            ManagedList lms = new ManagedList();
            for (Node child : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child);
                if (!"interceptor".equals(nodeName)) continue;
                BeanDefinitionBuilder siConfigBuilder = this.createBeanBuilder(SecurityInterceptorConfig.class);
                AbstractBeanDefinition beanDefinition = siConfigBuilder.getBeanDefinition();
                NamedNodeMap attributes = child.getAttributes();
                Node classNameNode = attributes.getNamedItem("class-name");
                String className = classNameNode != null ? this.getTextContent(classNameNode) : null;
                Node implNode = attributes.getNamedItem("implementation");
                String implementation = implNode != null ? this.getTextContent(implNode) : null;
                Assert.isTrue((className != null || implementation != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create SecurityInterceptorConfig!");
                siConfigBuilder.addPropertyValue("className", (Object)className);
                if (implementation != null) {
                    siConfigBuilder.addPropertyReference("implementation", implementation);
                }
                lms.add(beanDefinition);
            }
            securityConfigBuilder.addPropertyValue("securityInterceptorConfigs", (Object)lms);
        }

        private void handleCredentialsFactory(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            BeanDefinitionBuilder credentialsConfigBuilder = this.createBeanBuilder(CredentialsFactoryConfig.class);
            AbstractBeanDefinition beanDefinition = credentialsConfigBuilder.getBeanDefinition();
            NamedNodeMap attributes = node.getAttributes();
            Node classNameNode = attributes.getNamedItem("class-name");
            String className = classNameNode != null ? this.getTextContent(classNameNode) : null;
            Node implNode = attributes.getNamedItem("implementation");
            String implementation = implNode != null ? this.getTextContent(implNode) : null;
            credentialsConfigBuilder.addPropertyValue("className", (Object)className);
            if (implementation != null) {
                credentialsConfigBuilder.addPropertyReference("implementation", implementation);
            }
            Assert.isTrue((className != null || implementation != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create CredentialsFactory!");
            for (Node child : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child);
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, credentialsConfigBuilder);
                break;
            }
            securityConfigBuilder.addPropertyValue("memberCredentialsConfig", (Object)beanDefinition);
        }

        private void handleLoginModules(Node node, BeanDefinitionBuilder securityConfigBuilder, boolean member) {
            ManagedList lms = new ManagedList();
            for (Node child : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child);
                if (!"login-module".equals(nodeName)) continue;
                this.handleLoginModule(child, (List<BeanDefinition>)lms);
            }
            if (member) {
                securityConfigBuilder.addPropertyValue("memberLoginModuleConfigs", (Object)lms);
            } else {
                securityConfigBuilder.addPropertyValue("clientLoginModuleConfigs", (Object)lms);
            }
        }

        private void handleLoginModule(Node node, List<BeanDefinition> list) {
            BeanDefinitionBuilder lmConfigBuilder = this.createBeanBuilder(LoginModuleConfig.class);
            AbstractBeanDefinition beanDefinition = lmConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, lmConfigBuilder, "class-name", "implementation");
            NamedNodeMap attributes = node.getAttributes();
            Node classNameNode = attributes.getNamedItem("class-name");
            String className = classNameNode != null ? this.getTextContent(classNameNode) : null;
            Node implNode = attributes.getNamedItem("implementation");
            String implementation = implNode != null ? this.getTextContent(implNode) : null;
            lmConfigBuilder.addPropertyValue("className", (Object)className);
            if (implementation != null) {
                lmConfigBuilder.addPropertyReference("implementation", implementation);
            }
            Assert.isTrue((className != null || implementation != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create LoginModule!");
            for (Node child : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child);
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, lmConfigBuilder);
                break;
            }
            list.add((BeanDefinition)beanDefinition);
        }

        private void handlePermissionPolicy(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            BeanDefinitionBuilder permPolicyConfigBuilder = this.createBeanBuilder(PermissionPolicyConfig.class);
            AbstractBeanDefinition beanDefinition = permPolicyConfigBuilder.getBeanDefinition();
            NamedNodeMap attributes = node.getAttributes();
            Node classNameNode = attributes.getNamedItem("class-name");
            String className = classNameNode != null ? this.getTextContent(classNameNode) : null;
            Node implNode = attributes.getNamedItem("implementation");
            String implementation = implNode != null ? this.getTextContent(implNode) : null;
            permPolicyConfigBuilder.addPropertyValue("className", (Object)className);
            if (implementation != null) {
                permPolicyConfigBuilder.addPropertyReference("implementation", implementation);
            }
            Assert.isTrue((className != null || implementation != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create PermissionPolicy!");
            for (Node child : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child);
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, permPolicyConfigBuilder);
                break;
            }
            securityConfigBuilder.addPropertyValue("clientPolicyConfig", (Object)beanDefinition);
        }

        private void handleSecurityPermissions(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            ManagedSet permissions = new ManagedSet();
            for (Node child : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child);
                PermissionConfig.PermissionType type = PermissionConfig.PermissionType.getType(nodeName);
                if (type == null) continue;
                this.handleSecurityPermission(child, (Set<BeanDefinition>)permissions, type);
            }
            securityConfigBuilder.addPropertyValue("clientPermissionConfigs", (Object)permissions);
        }

        private void handleSecurityPermission(Node node, Set<BeanDefinition> permissions, PermissionConfig.PermissionType type) {
            BeanDefinitionBuilder permissionConfigBuilder = this.createBeanBuilder(PermissionConfig.class);
            AbstractBeanDefinition beanDefinition = permissionConfigBuilder.getBeanDefinition();
            permissionConfigBuilder.addPropertyValue("type", (Object)type);
            NamedNodeMap attributes = node.getAttributes();
            Node nameNode = attributes.getNamedItem("name");
            String name = nameNode != null ? this.getTextContent(nameNode) : "*";
            permissionConfigBuilder.addPropertyValue("name", (Object)name);
            Node principalNode = attributes.getNamedItem("principal");
            String principal = principalNode != null ? this.getTextContent(principalNode) : "*";
            permissionConfigBuilder.addPropertyValue("principal", (Object)principal);
            ManagedList endpoints = new ManagedList();
            ManagedList actions = new ManagedList();
            for (Node child : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child);
                if ("endpoints".equals(nodeName)) {
                    this.handleSecurityPermissionEndpoints(child, (List<String>)endpoints);
                    continue;
                }
                if (!"actions".equals(nodeName)) continue;
                this.handleSecurityPermissionActions(child, (List<String>)actions);
            }
            permissionConfigBuilder.addPropertyValue("endpoints", (Object)endpoints);
            permissionConfigBuilder.addPropertyValue("actions", (Object)actions);
            permissions.add((BeanDefinition)beanDefinition);
        }

        private void handleSecurityPermissionEndpoints(Node node, List<String> endpoints) {
            for (Node child : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child);
                if (!"endpoint".equals(nodeName)) continue;
                endpoints.add(this.getTextContent(child));
            }
        }

        private void handleSecurityPermissionActions(Node node, List<String> actions) {
            for (Node child : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child);
                if (!"action".equals(nodeName)) continue;
                actions.add(this.getTextContent(child));
            }
        }

        private void handleWanReplicationRef(BeanDefinitionBuilder beanDefinitionBuilder, Node childNode) {
            BeanDefinitionBuilder wanReplicationRefBuilder = this.createBeanBuilder(WanReplicationRef.class);
            AbstractBeanDefinition wanReplicationRefBeanDefinition = wanReplicationRefBuilder.getBeanDefinition();
            this.fillValues(childNode, wanReplicationRefBuilder, new String[0]);
            for (Node node : SpringXmlConfigBuilder.childElements(childNode)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(node);
                if (!nodeName.equals("filters")) continue;
                ManagedList filters = new ManagedList();
                this.handleFilters(node, (List<String>)filters);
                wanReplicationRefBuilder.addPropertyValue("filters", (Object)filters);
            }
            beanDefinitionBuilder.addPropertyValue("wanReplicationRef", (Object)wanReplicationRefBeanDefinition);
        }

        private void handleFilters(Node node, List<String> filters) {
            for (Node child : SpringXmlConfigBuilder.childElements(node)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(child);
                if (!"filter-impl".equals(nodeName)) continue;
                filters.add(this.getTextContent(child));
            }
        }
    }
}

