/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.dto;

import com.hazelcast.config.WanPublisherConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.management.JsonSerializable;
import com.hazelcast.internal.management.dto.WanPublisherConfigDTO;
import java.util.List;

public class WanReplicationConfigDTO
implements JsonSerializable {
    private WanReplicationConfig config;

    public WanReplicationConfigDTO(WanReplicationConfig config) {
        this.config = config;
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("name", this.config.getName());
        JsonArray publisherList = new JsonArray();
        for (WanPublisherConfig publisherConfig : this.config.getWanPublisherConfigs()) {
            WanPublisherConfigDTO dto = new WanPublisherConfigDTO(publisherConfig);
            publisherList.add(dto.toJson());
        }
        root.add("publishers", publisherList);
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.config = new WanReplicationConfig();
        this.config.setName(json.get("name").asString());
        List<WanPublisherConfig> publisherConfigs = this.config.getWanPublisherConfigs();
        JsonArray publishers = json.get("publishers").asArray();
        int size = publishers.size();
        for (int i = 0; i < size; ++i) {
            WanPublisherConfigDTO dto = new WanPublisherConfigDTO(new WanPublisherConfig());
            dto.fromJson(publishers.get(0).asObject());
            publisherConfigs.add(dto.getConfig());
        }
    }

    public WanReplicationConfig getConfig() {
        return this.config;
    }
}

