/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.client.impl.ClientEngine;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.NodeState;
import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.networking.InboundHandler;
import com.hazelcast.internal.networking.OutboundHandler;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.MemberSocketInterceptor;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.annotation.PrivateApi;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.util.AddressUtil;
import com.hazelcast.util.ThreadUtil;
import java.io.IOException;
import java.net.Socket;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

@PrivateApi
public class NodeIOService
implements IOService {
    private final Node node;
    private final NodeEngineImpl nodeEngine;

    public NodeIOService(Node node, NodeEngineImpl nodeEngine) {
        this.node = node;
        this.nodeEngine = nodeEngine;
    }

    @Override
    public HazelcastProperties properties() {
        return this.node.getProperties();
    }

    @Override
    public String getHazelcastName() {
        return this.node.hazelcastInstance.getName();
    }

    @Override
    public LoggingService getLoggingService() {
        return this.nodeEngine.getLoggingService();
    }

    @Override
    public boolean isActive() {
        return this.node.getState() != NodeState.SHUT_DOWN;
    }

    @Override
    public Address getThisAddress() {
        return this.node.getThisAddress();
    }

    @Override
    public void onFatalError(Exception e) {
        String hzName = this.nodeEngine.getHazelcastInstance().getName();
        Thread thread = new Thread(ThreadUtil.createThreadName(hzName, "io.error.shutdown")){

            @Override
            public void run() {
                NodeIOService.this.node.shutdown(false);
            }
        };
        thread.start();
    }

    public SocketInterceptorConfig getSocketInterceptorConfig() {
        return this.node.getConfig().getNetworkConfig().getSocketInterceptorConfig();
    }

    @Override
    public SymmetricEncryptionConfig getSymmetricEncryptionConfig() {
        return this.node.getConfig().getNetworkConfig().getSymmetricEncryptionConfig();
    }

    @Override
    public SSLConfig getSSLConfig() {
        return this.node.getConfig().getNetworkConfig().getSSLConfig();
    }

    @Override
    public ClientEngine getClientEngine() {
        return this.node.clientEngine;
    }

    @Override
    public TextCommandService getTextCommandService() {
        return this.node.getTextCommandService();
    }

    @Override
    public void removeEndpoint(final Address endPoint) {
        this.nodeEngine.getExecutionService().execute("hz:io", new Runnable(){

            @Override
            public void run() {
                ((NodeIOService)NodeIOService.this).node.clusterService.suspectAddressIfNotConnected(endPoint);
            }
        });
    }

    @Override
    public void onDisconnect(Address endpoint, Throwable cause) {
        if (cause == null) {
            return;
        }
        if (this.node.clusterService.getMember(endpoint) != null) {
            this.nodeEngine.getExecutionService().execute("hz:io", new ReconnectionTask(endpoint));
        }
    }

    @Override
    public void onSuccessfulConnection(Address address) {
        if (!this.node.getClusterService().isJoined()) {
            this.node.getJoiner().unblacklist(address);
        }
    }

    @Override
    public void onFailedConnection(Address address) {
        ClusterServiceImpl clusterService = this.node.clusterService;
        if (!clusterService.isJoined()) {
            this.node.getJoiner().blacklist(address, false);
        } else if (clusterService.getMember(address) != null) {
            this.nodeEngine.getExecutionService().schedule("hz:io", new ReconnectionTask(address), this.getConnectionMonitorInterval(), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void shouldConnectTo(Address address) {
        if (this.node.getThisAddress().equals(address)) {
            throw new RuntimeException("Connecting to self! " + address);
        }
    }

    @Override
    public boolean isSocketBind() {
        return this.node.getProperties().getBoolean(GroupProperty.SOCKET_CLIENT_BIND);
    }

    @Override
    public boolean isSocketBindAny() {
        return this.node.getProperties().getBoolean(GroupProperty.SOCKET_CLIENT_BIND_ANY);
    }

    @Override
    public void interceptSocket(Socket socket, boolean onAccept) throws IOException {
        socket.getChannel().configureBlocking(true);
        if (!this.isSocketInterceptorEnabled()) {
            return;
        }
        MemberSocketInterceptor memberSocketInterceptor = this.getMemberSocketInterceptor();
        if (memberSocketInterceptor == null) {
            return;
        }
        if (onAccept) {
            memberSocketInterceptor.onAccept(socket);
        } else {
            memberSocketInterceptor.onConnect(socket);
        }
    }

    @Override
    public boolean isSocketInterceptorEnabled() {
        SocketInterceptorConfig socketInterceptorConfig = this.getSocketInterceptorConfig();
        return socketInterceptorConfig != null && socketInterceptorConfig.isEnabled();
    }

    @Override
    public int getSocketConnectTimeoutSeconds() {
        return this.node.getProperties().getSeconds(GroupProperty.SOCKET_CONNECT_TIMEOUT_SECONDS);
    }

    @Override
    public long getConnectionMonitorInterval() {
        return this.node.getProperties().getMillis(GroupProperty.CONNECTION_MONITOR_INTERVAL);
    }

    @Override
    public int getConnectionMonitorMaxFaults() {
        return this.node.getProperties().getInteger(GroupProperty.CONNECTION_MONITOR_MAX_FAULTS);
    }

    @Override
    public void executeAsync(Runnable runnable) {
        this.nodeEngine.getExecutionService().execute("hz:io", runnable);
    }

    @Override
    public EventService getEventService() {
        return this.nodeEngine.getEventService();
    }

    @Override
    public InternalSerializationService getSerializationService() {
        return this.node.getSerializationService();
    }

    @Override
    public MemberSocketInterceptor getMemberSocketInterceptor() {
        return this.node.getNodeExtension().getMemberSocketInterceptor();
    }

    @Override
    public InboundHandler[] createMemberInboundHandlers(TcpIpConnection connection) {
        return this.node.getNodeExtension().createInboundHandlers(connection, this);
    }

    @Override
    public OutboundHandler[] createMemberOutboundHandlers(TcpIpConnection connection) {
        return this.node.getNodeExtension().createOutboundHandlers(connection, this);
    }

    @Override
    public Collection<Integer> getOutboundPorts() {
        NetworkConfig networkConfig = this.node.getConfig().getNetworkConfig();
        Collection<Integer> outboundPorts = networkConfig.getOutboundPorts();
        Collection<String> outboundPortDefinitions = networkConfig.getOutboundPortDefinitions();
        return AddressUtil.getOutboundPorts(outboundPorts, outboundPortDefinitions);
    }

    private class ReconnectionTask
    implements Runnable {
        private final Address endpoint;

        ReconnectionTask(Address endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public void run() {
            ClusterServiceImpl clusterService = ((NodeIOService)NodeIOService.this).node.clusterService;
            if (clusterService.getMember(this.endpoint) != null) {
                ((NodeIOService)NodeIOService.this).node.connectionManager.getOrConnect(this.endpoint);
            }
        }
    }
}

