/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.eviction;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.PartitionService;
import com.hazelcast.internal.eviction.ClearExpiredRecordsTask;
import com.hazelcast.partition.PartitionLostEvent;
import com.hazelcast.partition.PartitionLostListener;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.TaskScheduler;
import com.hazelcast.spi.partition.MigrationEndpoint;
import com.hazelcast.util.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ExpirationManager
implements LifecycleListener,
PartitionLostListener {
    private final int taskPeriodSeconds;
    private final NodeEngine nodeEngine;
    private final ClearExpiredRecordsTask task;
    private final TaskScheduler globalTaskScheduler;
    private final PartitionService partitionService;
    private final String regIdOfPartitionLostListener;
    private final AtomicBoolean scheduled = new AtomicBoolean(false);
    private final AtomicBoolean scheduledOneTime = new AtomicBoolean(false);
    private volatile ScheduledFuture<?> scheduledExpirationTask;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ExpirationManager(ClearExpiredRecordsTask task, NodeEngine nodeEngine) {
        this.task = task;
        this.nodeEngine = nodeEngine;
        this.globalTaskScheduler = nodeEngine.getExecutionService().getGlobalTaskScheduler();
        this.taskPeriodSeconds = Preconditions.checkPositive(task.getTaskPeriodSeconds(), "taskPeriodSeconds should be a positive number");
        this.getHazelcastInstance().getLifecycleService().addLifecycleListener(this);
        this.partitionService = this.getHazelcastInstance().getPartitionService();
        this.regIdOfPartitionLostListener = this.partitionService.addPartitionLostListener(this);
    }

    protected HazelcastInstance getHazelcastInstance() {
        return this.nodeEngine.getHazelcastInstance();
    }

    public void scheduleExpirationTask() {
        if (this.nodeEngine.getLocalMember().isLiteMember() || this.scheduled.get() || !this.scheduled.compareAndSet(false, true)) {
            return;
        }
        this.scheduledExpirationTask = this.globalTaskScheduler.scheduleWithRepetition(this.task, this.taskPeriodSeconds, this.taskPeriodSeconds, TimeUnit.SECONDS);
        this.scheduledOneTime.set(true);
    }

    void unscheduleExpirationTask() {
        this.scheduled.set(false);
        ScheduledFuture<?> scheduledFuture = this.scheduledExpirationTask;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
    }

    @Override
    public void stateChanged(LifecycleEvent event) {
        switch (event.getState()) {
            case SHUTTING_DOWN: 
            case MERGING: {
                this.unscheduleExpirationTask();
                break;
            }
            case MERGED: {
                this.rescheduleIfScheduledBefore();
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public void partitionLost(PartitionLostEvent event) {
        this.task.partitionLost(event);
    }

    public void onClusterStateChange(ClusterState newState) {
        if (newState == ClusterState.PASSIVE) {
            this.unscheduleExpirationTask();
        } else {
            this.rescheduleIfScheduledBefore();
        }
    }

    public void onCommitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE && event.getCurrentReplicaIndex() == 0) {
            this.task.sendQueuedExpiredKeys(this.task.containers[event.getPartitionId()]);
        }
    }

    public void onShutdown() {
        this.partitionService.removePartitionLostListener(this.regIdOfPartitionLostListener);
    }

    public ClearExpiredRecordsTask getTask() {
        return this.task;
    }

    private void rescheduleIfScheduledBefore() {
        if (!this.scheduledOneTime.get()) {
            return;
        }
        this.scheduleExpirationTask();
    }

    int getTaskPeriodSeconds() {
        return this.taskPeriodSeconds;
    }

    int getCleanupOperationCount() {
        return this.task.getCleanupOperationCount();
    }

    int getCleanupPercentage() {
        return this.task.getCleanupPercentage();
    }

    boolean isScheduled() {
        return this.scheduled.get();
    }
}

