/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.config.ClientFlakeIdGeneratorConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientReliableTopicConfig;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.config.ClientUserCodeDeploymentConfig;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.config.ConfigPatternMatcher;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.matcher.MatchingPointConfigPatternMatcher;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.internal.config.ConfigUtils;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.security.Credentials;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.function.BiConsumer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ClientConfig {
    private Properties properties = new Properties();
    private GroupConfig groupConfig = new GroupConfig();
    private ClientSecurityConfig securityConfig = new ClientSecurityConfig();
    private ClientNetworkConfig networkConfig = new ClientNetworkConfig();
    private LoadBalancer loadBalancer;
    private final List<ListenerConfig> listenerConfigs;
    private int executorPoolSize = -1;
    private String instanceName;
    private ConfigPatternMatcher configPatternMatcher = new MatchingPointConfigPatternMatcher();
    private final Map<String, NearCacheConfig> nearCacheConfigMap;
    private final Map<String, ClientReliableTopicConfig> reliableTopicConfigMap;
    private final Map<String, Map<String, QueryCacheConfig>> queryCacheConfigs;
    private SerializationConfig serializationConfig = new SerializationConfig();
    private NativeMemoryConfig nativeMemoryConfig = new NativeMemoryConfig();
    private final List<ProxyFactoryConfig> proxyFactoryConfigs;
    private ManagedContext managedContext;
    private ClassLoader classLoader;
    private String licenseKey;
    private ClientConnectionStrategyConfig connectionStrategyConfig = new ClientConnectionStrategyConfig();
    private ClientUserCodeDeploymentConfig userCodeDeploymentConfig = new ClientUserCodeDeploymentConfig();
    private final Map<String, ClientFlakeIdGeneratorConfig> flakeIdGeneratorConfigMap;
    private final Set<String> labels;
    private final ConcurrentMap<String, Object> userContext;

    public ClientConfig() {
        this.listenerConfigs = new LinkedList<ListenerConfig>();
        this.nearCacheConfigMap = new ConcurrentHashMap<String, NearCacheConfig>();
        this.reliableTopicConfigMap = new ConcurrentHashMap<String, ClientReliableTopicConfig>();
        this.proxyFactoryConfigs = new LinkedList<ProxyFactoryConfig>();
        this.flakeIdGeneratorConfigMap = new ConcurrentHashMap<String, ClientFlakeIdGeneratorConfig>();
        this.queryCacheConfigs = new ConcurrentHashMap<String, Map<String, QueryCacheConfig>>();
        this.labels = new HashSet<String>();
        this.userContext = new ConcurrentHashMap<String, Object>();
    }

    public ClientConfig(ClientConfig config) {
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)config.properties);
        this.groupConfig = new GroupConfig(config.groupConfig);
        this.securityConfig = new ClientSecurityConfig(config.securityConfig);
        this.networkConfig = new ClientNetworkConfig(config.networkConfig);
        this.loadBalancer = config.loadBalancer;
        this.listenerConfigs = new LinkedList<ListenerConfig>();
        for (ListenerConfig listenerConfig : config.listenerConfigs) {
            this.listenerConfigs.add(new ListenerConfig(listenerConfig));
        }
        this.executorPoolSize = config.executorPoolSize;
        this.instanceName = config.instanceName;
        this.configPatternMatcher = config.configPatternMatcher;
        this.nearCacheConfigMap = new ConcurrentHashMap<String, NearCacheConfig>();
        for (Map.Entry entry : config.nearCacheConfigMap.entrySet()) {
            this.nearCacheConfigMap.put((String)entry.getKey(), new NearCacheConfig((NearCacheConfig)entry.getValue()));
        }
        this.reliableTopicConfigMap = new ConcurrentHashMap<String, ClientReliableTopicConfig>();
        for (Map.Entry entry : config.reliableTopicConfigMap.entrySet()) {
            this.reliableTopicConfigMap.put((String)entry.getKey(), new ClientReliableTopicConfig((ClientReliableTopicConfig)entry.getValue()));
        }
        this.queryCacheConfigs = new ConcurrentHashMap<String, Map<String, QueryCacheConfig>>();
        for (Map.Entry entry : config.queryCacheConfigs.entrySet()) {
            Map value = (Map)entry.getValue();
            ConcurrentHashMap map = new ConcurrentHashMap();
            for (Map.Entry cacheConfigEntry : value.entrySet()) {
                map.put(cacheConfigEntry.getKey(), new QueryCacheConfig((QueryCacheConfig)cacheConfigEntry.getValue()));
            }
            this.queryCacheConfigs.put((String)entry.getKey(), map);
        }
        this.serializationConfig = new SerializationConfig(config.serializationConfig);
        this.nativeMemoryConfig = new NativeMemoryConfig(config.nativeMemoryConfig);
        this.proxyFactoryConfigs = new LinkedList<ProxyFactoryConfig>();
        for (ProxyFactoryConfig proxyFactoryConfig : config.proxyFactoryConfigs) {
            this.proxyFactoryConfigs.add(new ProxyFactoryConfig(proxyFactoryConfig));
        }
        this.managedContext = config.managedContext;
        this.classLoader = config.classLoader;
        this.licenseKey = config.licenseKey;
        this.connectionStrategyConfig = new ClientConnectionStrategyConfig(config.connectionStrategyConfig);
        this.userCodeDeploymentConfig = new ClientUserCodeDeploymentConfig(config.userCodeDeploymentConfig);
        this.flakeIdGeneratorConfigMap = new ConcurrentHashMap<String, ClientFlakeIdGeneratorConfig>();
        for (Map.Entry entry : config.flakeIdGeneratorConfigMap.entrySet()) {
            this.flakeIdGeneratorConfigMap.put((String)entry.getKey(), new ClientFlakeIdGeneratorConfig((ClientFlakeIdGeneratorConfig)entry.getValue()));
        }
        this.labels = new HashSet<String>(config.labels);
        this.userContext = new ConcurrentHashMap<String, Object>(config.userContext);
    }

    public void setConfigPatternMatcher(ConfigPatternMatcher configPatternMatcher) {
        Preconditions.isNotNull(configPatternMatcher, "configPatternMatcher");
        this.configPatternMatcher = configPatternMatcher;
    }

    public ConfigPatternMatcher getConfigPatternMatcher() {
        return this.configPatternMatcher;
    }

    public String getProperty(String name) {
        String value = this.properties.getProperty(name);
        return value != null ? value : System.getProperty(name);
    }

    public ClientConfig setProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ClientConfig setProperties(Properties properties) {
        Preconditions.isNotNull(properties, "properties");
        this.properties = properties;
        return this;
    }

    public ClientSecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    public ClientConfig setSecurityConfig(ClientSecurityConfig securityConfig) {
        Preconditions.isNotNull(securityConfig, "securityConfig");
        this.securityConfig = securityConfig;
        return this;
    }

    public ClientNetworkConfig getNetworkConfig() {
        return this.networkConfig;
    }

    public ClientConfig setNetworkConfig(ClientNetworkConfig networkConfig) {
        Preconditions.isNotNull(networkConfig, "networkConfig");
        this.networkConfig = networkConfig;
        return this;
    }

    public ClientConfig addReliableTopicConfig(ClientReliableTopicConfig reliableTopicConfig) {
        this.reliableTopicConfigMap.put(reliableTopicConfig.getName(), reliableTopicConfig);
        return this;
    }

    public ClientReliableTopicConfig getReliableTopicConfig(String name) {
        return ConfigUtils.getConfig(this.configPatternMatcher, this.reliableTopicConfigMap, name, ClientReliableTopicConfig.class, new BiConsumer<ClientReliableTopicConfig, String>(){

            @Override
            public void accept(ClientReliableTopicConfig clientReliableTopicConfig, String name) {
                clientReliableTopicConfig.setName(name);
            }
        });
    }

    @Deprecated
    public ClientConfig addNearCacheConfig(String name, NearCacheConfig nearCacheConfig) {
        nearCacheConfig.setName(name);
        return this.addNearCacheConfig(nearCacheConfig);
    }

    public ClientConfig addNearCacheConfig(NearCacheConfig nearCacheConfig) {
        this.nearCacheConfigMap.put(nearCacheConfig.getName(), nearCacheConfig);
        return this;
    }

    public ClientConfig addListenerConfig(ListenerConfig listenerConfig) {
        this.getListenerConfigs().add(listenerConfig);
        return this;
    }

    public ClientConfig addProxyFactoryConfig(ProxyFactoryConfig proxyFactoryConfig) {
        this.proxyFactoryConfigs.add(proxyFactoryConfig);
        return this;
    }

    public NearCacheConfig getNearCacheConfig(String name) {
        NearCacheConfig nearCacheConfig = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.nearCacheConfigMap, name);
        if (nearCacheConfig == null && (nearCacheConfig = this.nearCacheConfigMap.get("default")) != null) {
            nearCacheConfig = new NearCacheConfig(nearCacheConfig);
        }
        return nearCacheConfig;
    }

    public Map<String, NearCacheConfig> getNearCacheConfigMap() {
        return this.nearCacheConfigMap;
    }

    public ClientConfig setNearCacheConfigMap(Map<String, NearCacheConfig> nearCacheConfigMap) {
        Preconditions.isNotNull(nearCacheConfigMap, "nearCacheConfigMap");
        this.nearCacheConfigMap.clear();
        this.nearCacheConfigMap.putAll(nearCacheConfigMap);
        for (Map.Entry<String, NearCacheConfig> entry : this.nearCacheConfigMap.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public Map<String, ClientFlakeIdGeneratorConfig> getFlakeIdGeneratorConfigMap() {
        return this.flakeIdGeneratorConfigMap;
    }

    public ClientFlakeIdGeneratorConfig findFlakeIdGeneratorConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        ClientFlakeIdGeneratorConfig config = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.flakeIdGeneratorConfigMap, baseName);
        if (config != null) {
            return config;
        }
        return this.getFlakeIdGeneratorConfig("default");
    }

    public ClientFlakeIdGeneratorConfig getFlakeIdGeneratorConfig(String name) {
        return ConfigUtils.getConfig(this.configPatternMatcher, this.getFlakeIdGeneratorConfigMap(), name, ClientFlakeIdGeneratorConfig.class, new BiConsumer<ClientFlakeIdGeneratorConfig, String>(){

            @Override
            public void accept(ClientFlakeIdGeneratorConfig flakeIdGeneratorConfig, String name) {
                flakeIdGeneratorConfig.setName(name);
            }
        });
    }

    public ClientConfig addFlakeIdGeneratorConfig(ClientFlakeIdGeneratorConfig config) {
        this.flakeIdGeneratorConfigMap.put(config.getName(), config);
        return this;
    }

    public ClientConfig setFlakeIdGeneratorConfigMap(Map<String, ClientFlakeIdGeneratorConfig> map) {
        Preconditions.isNotNull(map, "flakeIdGeneratorConfigMap");
        this.flakeIdGeneratorConfigMap.clear();
        this.flakeIdGeneratorConfigMap.putAll(map);
        for (Map.Entry<String, ClientFlakeIdGeneratorConfig> entry : map.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public ClientConfig setReliableTopicConfigMap(Map<String, ClientReliableTopicConfig> map) {
        Preconditions.isNotNull(map, "reliableTopicConfigMap");
        this.reliableTopicConfigMap.clear();
        this.reliableTopicConfigMap.putAll(map);
        for (Map.Entry<String, ClientReliableTopicConfig> entry : map.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public Map<String, ClientReliableTopicConfig> getReliableTopicConfigMap() {
        return this.reliableTopicConfigMap;
    }

    @Deprecated
    public boolean isSmartRouting() {
        return this.networkConfig.isSmartRouting();
    }

    @Deprecated
    public ClientConfig setSmartRouting(boolean smartRouting) {
        this.networkConfig.setSmartRouting(smartRouting);
        return this;
    }

    @Deprecated
    public SocketInterceptorConfig getSocketInterceptorConfig() {
        return this.networkConfig.getSocketInterceptorConfig();
    }

    @Deprecated
    public ClientConfig setSocketInterceptorConfig(SocketInterceptorConfig socketInterceptorConfig) {
        this.networkConfig.setSocketInterceptorConfig(socketInterceptorConfig);
        return this;
    }

    @Deprecated
    public int getConnectionAttemptPeriod() {
        return this.networkConfig.getConnectionAttemptPeriod();
    }

    @Deprecated
    public ClientConfig setConnectionAttemptPeriod(int connectionAttemptPeriod) {
        this.networkConfig.setConnectionAttemptPeriod(connectionAttemptPeriod);
        return this;
    }

    @Deprecated
    public int getConnectionAttemptLimit() {
        return this.networkConfig.getConnectionAttemptLimit();
    }

    @Deprecated
    public ClientConfig setConnectionAttemptLimit(int connectionAttemptLimit) {
        this.networkConfig.setConnectionAttemptLimit(connectionAttemptLimit);
        return this;
    }

    @Deprecated
    public int getConnectionTimeout() {
        return this.networkConfig.getConnectionTimeout();
    }

    @Deprecated
    public ClientConfig setConnectionTimeout(int connectionTimeout) {
        this.networkConfig.setConnectionTimeout(connectionTimeout);
        return this;
    }

    public Credentials getCredentials() {
        return this.securityConfig.getCredentials();
    }

    public ClientConfig setCredentials(Credentials credentials) {
        this.securityConfig.setCredentials(credentials);
        return this;
    }

    @Deprecated
    public ClientConfig addAddress(String ... addresses) {
        this.networkConfig.addAddress(addresses);
        return this;
    }

    @Deprecated
    public ClientConfig setAddresses(List<String> addresses) {
        this.networkConfig.setAddresses(addresses);
        return this;
    }

    @Deprecated
    public List<String> getAddresses() {
        return this.networkConfig.getAddresses();
    }

    public GroupConfig getGroupConfig() {
        return this.groupConfig;
    }

    public ClientConfig setGroupConfig(GroupConfig groupConfig) {
        Preconditions.isNotNull(groupConfig, "groupConfig");
        this.groupConfig = groupConfig;
        return this;
    }

    public List<ListenerConfig> getListenerConfigs() {
        return this.listenerConfigs;
    }

    public ClientConfig setListenerConfigs(List<ListenerConfig> listenerConfigs) {
        Preconditions.isNotNull(listenerConfigs, "listenerConfigs");
        this.listenerConfigs.clear();
        this.listenerConfigs.addAll(listenerConfigs);
        return this;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public ClientConfig setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
        return this;
    }

    @Deprecated
    public boolean isRedoOperation() {
        return this.networkConfig.isRedoOperation();
    }

    @Deprecated
    public ClientConfig setRedoOperation(boolean redoOperation) {
        this.networkConfig.setRedoOperation(redoOperation);
        return this;
    }

    @Deprecated
    public SocketOptions getSocketOptions() {
        return this.networkConfig.getSocketOptions();
    }

    @Deprecated
    public ClientConfig setSocketOptions(SocketOptions socketOptions) {
        this.networkConfig.setSocketOptions(socketOptions);
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClientConfig setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public ManagedContext getManagedContext() {
        return this.managedContext;
    }

    public ClientConfig setManagedContext(ManagedContext managedContext) {
        this.managedContext = managedContext;
        return this;
    }

    public int getExecutorPoolSize() {
        return this.executorPoolSize;
    }

    public ClientConfig setExecutorPoolSize(int executorPoolSize) {
        this.executorPoolSize = executorPoolSize;
        return this;
    }

    public List<ProxyFactoryConfig> getProxyFactoryConfigs() {
        return this.proxyFactoryConfigs;
    }

    public ClientConfig setProxyFactoryConfigs(List<ProxyFactoryConfig> proxyFactoryConfigs) {
        Preconditions.isNotNull(proxyFactoryConfigs, "proxyFactoryConfigs");
        this.proxyFactoryConfigs.clear();
        this.proxyFactoryConfigs.addAll(proxyFactoryConfigs);
        return this;
    }

    public SerializationConfig getSerializationConfig() {
        return this.serializationConfig;
    }

    public ClientConfig setSerializationConfig(SerializationConfig serializationConfig) {
        Preconditions.isNotNull(serializationConfig, "serializationConfig");
        this.serializationConfig = serializationConfig;
        return this;
    }

    public NativeMemoryConfig getNativeMemoryConfig() {
        return this.nativeMemoryConfig;
    }

    public ClientConfig setNativeMemoryConfig(NativeMemoryConfig nativeMemoryConfig) {
        Preconditions.isNotNull(nativeMemoryConfig, "nativeMemoryConfig");
        this.nativeMemoryConfig = nativeMemoryConfig;
        return this;
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public ClientConfig setLicenseKey(String licenseKey) {
        this.licenseKey = licenseKey;
        return this;
    }

    public ClientConfig addQueryCacheConfig(String mapName, QueryCacheConfig queryCacheConfig) {
        Map<String, Map<String, QueryCacheConfig>> queryCacheConfigsPerMap = this.getQueryCacheConfigs();
        String queryCacheName = queryCacheConfig.getName();
        Map<String, QueryCacheConfig> queryCacheConfigs = queryCacheConfigsPerMap.get(mapName);
        if (queryCacheConfigs != null) {
            Preconditions.checkFalse(queryCacheConfigs.containsKey(queryCacheName), "A query cache already exists with name = [" + queryCacheName + ']');
        } else {
            queryCacheConfigs = new ConcurrentHashMap<String, QueryCacheConfig>();
            queryCacheConfigsPerMap.put(mapName, queryCacheConfigs);
        }
        queryCacheConfigs.put(queryCacheName, queryCacheConfig);
        return this;
    }

    public Map<String, Map<String, QueryCacheConfig>> getQueryCacheConfigs() {
        return this.queryCacheConfigs;
    }

    public void setQueryCacheConfigs(Map<String, Map<String, QueryCacheConfig>> queryCacheConfigs) {
        Preconditions.isNotNull(queryCacheConfigs, "queryCacheConfigs");
        this.queryCacheConfigs.clear();
        this.queryCacheConfigs.putAll(queryCacheConfigs);
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public ClientConnectionStrategyConfig getConnectionStrategyConfig() {
        return this.connectionStrategyConfig;
    }

    public ClientConfig setConnectionStrategyConfig(ClientConnectionStrategyConfig connectionStrategyConfig) {
        Preconditions.isNotNull(connectionStrategyConfig, "connectionStrategyConfig");
        this.connectionStrategyConfig = connectionStrategyConfig;
        return this;
    }

    public ClientUserCodeDeploymentConfig getUserCodeDeploymentConfig() {
        return this.userCodeDeploymentConfig;
    }

    public ClientConfig setUserCodeDeploymentConfig(ClientUserCodeDeploymentConfig userCodeDeploymentConfig) {
        Preconditions.isNotNull(userCodeDeploymentConfig, "userCodeDeploymentConfig");
        this.userCodeDeploymentConfig = userCodeDeploymentConfig;
        return this;
    }

    public QueryCacheConfig getOrCreateQueryCacheConfig(String mapName, String cacheName) {
        QueryCacheConfig queryCacheConfig;
        Map<String, Map<String, QueryCacheConfig>> allQueryCacheConfig = this.getQueryCacheConfigs();
        Map<String, QueryCacheConfig> queryCacheConfigsForMap = ConfigUtils.lookupByPattern(this.configPatternMatcher, allQueryCacheConfig, mapName);
        if (queryCacheConfigsForMap == null) {
            queryCacheConfigsForMap = new HashMap<String, QueryCacheConfig>();
            allQueryCacheConfig.put(mapName, queryCacheConfigsForMap);
        }
        if ((queryCacheConfig = ConfigUtils.lookupByPattern(this.configPatternMatcher, queryCacheConfigsForMap, cacheName)) == null) {
            queryCacheConfig = new QueryCacheConfig(cacheName);
            queryCacheConfigsForMap.put(cacheName, queryCacheConfig);
        }
        return queryCacheConfig;
    }

    public QueryCacheConfig getOrNullQueryCacheConfig(String mapName, String cacheName) {
        if (this.queryCacheConfigs == null) {
            return null;
        }
        Map<String, QueryCacheConfig> queryCacheConfigsForMap = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.queryCacheConfigs, mapName);
        if (queryCacheConfigsForMap == null) {
            return null;
        }
        return ConfigUtils.lookupByPattern(this.configPatternMatcher, queryCacheConfigsForMap, cacheName);
    }

    public ClientConfig addLabel(String label) {
        this.labels.add(label);
        return this;
    }

    public Set<String> getLabels() {
        return this.labels;
    }

    public ClientConfig setLabels(Set<String> labels) {
        Preconditions.isNotNull(labels, "labels");
        this.labels.clear();
        this.labels.addAll(labels);
        return this;
    }

    public ClientConfig setUserContext(ConcurrentMap<String, Object> userContext) {
        Preconditions.isNotNull(userContext, "userContext");
        this.userContext.clear();
        this.userContext.putAll(userContext);
        return this;
    }

    public ConcurrentMap<String, Object> getUserContext() {
        return this.userContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientConfig that = (ClientConfig)o;
        if (this.executorPoolSize != that.executorPoolSize) {
            return false;
        }
        if (!this.properties.equals(that.properties)) {
            return false;
        }
        if (!this.groupConfig.equals(that.groupConfig)) {
            return false;
        }
        if (!this.securityConfig.equals(that.securityConfig)) {
            return false;
        }
        if (!this.networkConfig.equals(that.networkConfig)) {
            return false;
        }
        if (this.loadBalancer != null ? !this.loadBalancer.equals(that.loadBalancer) : that.loadBalancer != null) {
            return false;
        }
        if (!this.listenerConfigs.equals(that.listenerConfigs)) {
            return false;
        }
        if (this.instanceName != null ? !this.instanceName.equals(that.instanceName) : that.instanceName != null) {
            return false;
        }
        if (this.configPatternMatcher != null ? !this.configPatternMatcher.equals(that.configPatternMatcher) : that.configPatternMatcher != null) {
            return false;
        }
        if (!this.nearCacheConfigMap.equals(that.nearCacheConfigMap)) {
            return false;
        }
        if (!this.reliableTopicConfigMap.equals(that.reliableTopicConfigMap)) {
            return false;
        }
        if (!this.queryCacheConfigs.equals(that.queryCacheConfigs)) {
            return false;
        }
        if (!this.serializationConfig.equals(that.serializationConfig)) {
            return false;
        }
        if (!this.nativeMemoryConfig.equals(that.nativeMemoryConfig)) {
            return false;
        }
        if (!this.proxyFactoryConfigs.equals(that.proxyFactoryConfigs)) {
            return false;
        }
        if (this.managedContext != null ? !this.managedContext.equals(that.managedContext) : that.managedContext != null) {
            return false;
        }
        if (this.classLoader != null ? !this.classLoader.equals(that.classLoader) : that.classLoader != null) {
            return false;
        }
        if (this.licenseKey != null ? !this.licenseKey.equals(that.licenseKey) : that.licenseKey != null) {
            return false;
        }
        if (!this.connectionStrategyConfig.equals(that.connectionStrategyConfig)) {
            return false;
        }
        if (!this.userCodeDeploymentConfig.equals(that.userCodeDeploymentConfig)) {
            return false;
        }
        if (!this.flakeIdGeneratorConfigMap.equals(that.flakeIdGeneratorConfigMap)) {
            return false;
        }
        if (!this.labels.equals(that.labels)) {
            return false;
        }
        return this.userContext.equals(that.userContext);
    }

    public int hashCode() {
        int result = this.properties.hashCode();
        result = 31 * result + this.groupConfig.hashCode();
        result = 31 * result + this.securityConfig.hashCode();
        result = 31 * result + this.networkConfig.hashCode();
        result = 31 * result + (this.loadBalancer != null ? this.loadBalancer.hashCode() : 0);
        result = 31 * result + this.listenerConfigs.hashCode();
        result = 31 * result + this.executorPoolSize;
        result = 31 * result + (this.instanceName != null ? this.instanceName.hashCode() : 0);
        result = 31 * result + (this.configPatternMatcher != null ? this.configPatternMatcher.hashCode() : 0);
        result = 31 * result + this.nearCacheConfigMap.hashCode();
        result = 31 * result + this.reliableTopicConfigMap.hashCode();
        result = 31 * result + this.queryCacheConfigs.hashCode();
        result = 31 * result + this.serializationConfig.hashCode();
        result = 31 * result + this.nativeMemoryConfig.hashCode();
        result = 31 * result + this.proxyFactoryConfigs.hashCode();
        result = 31 * result + (this.managedContext != null ? this.managedContext.hashCode() : 0);
        result = 31 * result + (this.classLoader != null ? this.classLoader.hashCode() : 0);
        result = 31 * result + (this.licenseKey != null ? this.licenseKey.hashCode() : 0);
        result = 31 * result + this.connectionStrategyConfig.hashCode();
        result = 31 * result + this.userCodeDeploymentConfig.hashCode();
        result = 31 * result + this.flakeIdGeneratorConfigMap.hashCode();
        result = 31 * result + this.labels.hashCode();
        result = 31 * result + this.userContext.hashCode();
        return result;
    }
}

