/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cp.internal.datastructures.atomiclong;

import com.hazelcast.client.impl.clientside.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CPAtomicLongAddAndGetCodec;
import com.hazelcast.client.impl.protocol.codec.CPAtomicLongAlterCodec;
import com.hazelcast.client.impl.protocol.codec.CPAtomicLongApplyCodec;
import com.hazelcast.client.impl.protocol.codec.CPAtomicLongCompareAndSetCodec;
import com.hazelcast.client.impl.protocol.codec.CPAtomicLongGetAndAddCodec;
import com.hazelcast.client.impl.protocol.codec.CPAtomicLongGetAndSetCodec;
import com.hazelcast.client.impl.protocol.codec.CPAtomicLongGetCodec;
import com.hazelcast.client.impl.protocol.codec.CPGroupDestroyCPObjectCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IFunction;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.datastructures.atomiclong.operation.AlterOp;
import com.hazelcast.spi.InternalCompletableFuture;

class RaftAtomicLongProxy
extends ClientProxy
implements IAtomicLong {
    private static final ClientMessageDecoder ADD_AND_GET_DECODER = new ClientMessageDecoder(){

        public Long decodeClientMessage(ClientMessage clientMessage) {
            return CPAtomicLongAddAndGetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder COMPARE_AND_SET_DECODER = new ClientMessageDecoder(){

        public Boolean decodeClientMessage(ClientMessage clientMessage) {
            return CPAtomicLongCompareAndSetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder GET_AND_ADD_DECODER = new ClientMessageDecoder(){

        public Long decodeClientMessage(ClientMessage clientMessage) {
            return CPAtomicLongGetAndAddCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder GET_AND_SET_DECODER = new ClientMessageDecoder(){

        public Long decodeClientMessage(ClientMessage clientMessage) {
            return CPAtomicLongGetAndSetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder GET_DECODER = new ClientMessageDecoder(){

        public Long decodeClientMessage(ClientMessage clientMessage) {
            return CPAtomicLongGetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder APPLY_DECODER = new ClientMessageDecoder(){

        public Object decodeClientMessage(ClientMessage clientMessage) {
            return CPAtomicLongApplyCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder ALTER_DECODER = new ClientMessageDecoder(){

        public Long decodeClientMessage(ClientMessage clientMessage) {
            return CPAtomicLongAlterCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private final RaftGroupId groupId;
    private final String objectName;

    RaftAtomicLongProxy(ClientContext context, RaftGroupId groupId, String proxyName, String objectName) {
        super("hz:raft:atomicLongService", proxyName, context);
        this.groupId = groupId;
        this.objectName = objectName;
    }

    @Override
    public long addAndGet(long delta) {
        return (Long)this.addAndGetAsync(delta).join();
    }

    @Override
    public boolean compareAndSet(long expect, long update) {
        return (Boolean)this.compareAndSetAsync(expect, update).join();
    }

    @Override
    public long decrementAndGet() {
        return (Long)this.decrementAndGetAsync().join();
    }

    @Override
    public long get() {
        return (Long)this.getAsync().join();
    }

    @Override
    public long getAndAdd(long delta) {
        return (Long)this.getAndAddAsync(delta).join();
    }

    @Override
    public long getAndSet(long newValue) {
        return (Long)this.getAndSetAsync(newValue).join();
    }

    @Override
    public long incrementAndGet() {
        return (Long)this.incrementAndGetAsync().join();
    }

    @Override
    public long getAndIncrement() {
        return (Long)this.getAndIncrementAsync().join();
    }

    @Override
    public void set(long newValue) {
        this.setAsync(newValue).join();
    }

    @Override
    public void alter(IFunction<Long, Long> function) {
        this.alterAsync((IFunction)function).join();
    }

    @Override
    public long alterAndGet(IFunction<Long, Long> function) {
        return (Long)this.alterAndGetAsync((IFunction)function).join();
    }

    @Override
    public long getAndAlter(IFunction<Long, Long> function) {
        return (Long)this.getAndAlterAsync((IFunction)function).join();
    }

    @Override
    public <R> R apply(IFunction<Long, R> function) {
        return (R)this.applyAsync((IFunction)function).join();
    }

    public InternalCompletableFuture<Long> addAndGetAsync(long delta) {
        ClientMessage request = CPAtomicLongAddAndGetCodec.encodeRequest(this.groupId, this.objectName, delta);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Long>(future, this.getSerializationService(), ADD_AND_GET_DECODER);
    }

    public InternalCompletableFuture<Boolean> compareAndSetAsync(long expect, long update) {
        ClientMessage request = CPAtomicLongCompareAndSetCodec.encodeRequest(this.groupId, this.objectName, expect, update);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Boolean>(future, this.getSerializationService(), COMPARE_AND_SET_DECODER);
    }

    public InternalCompletableFuture<Long> decrementAndGetAsync() {
        return this.addAndGetAsync(-1L);
    }

    public InternalCompletableFuture<Long> getAsync() {
        ClientMessage request = CPAtomicLongGetCodec.encodeRequest(this.groupId, this.objectName);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Long>(future, this.getSerializationService(), GET_DECODER);
    }

    public InternalCompletableFuture<Long> getAndAddAsync(long delta) {
        ClientMessage request = CPAtomicLongGetAndAddCodec.encodeRequest(this.groupId, this.objectName, delta);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Long>(future, this.getSerializationService(), GET_AND_ADD_DECODER);
    }

    public InternalCompletableFuture<Long> getAndSetAsync(long newValue) {
        ClientMessage request = CPAtomicLongGetAndSetCodec.encodeRequest(this.groupId, this.objectName, newValue);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Long>(future, this.getSerializationService(), GET_AND_SET_DECODER);
    }

    public InternalCompletableFuture<Long> incrementAndGetAsync() {
        return this.addAndGetAsync(1L);
    }

    public InternalCompletableFuture<Long> getAndIncrementAsync() {
        return this.getAndAddAsync(1L);
    }

    public InternalCompletableFuture<Void> setAsync(long newValue) {
        ICompletableFuture future = this.getAndSetAsync(newValue);
        return future;
    }

    public InternalCompletableFuture<Void> alterAsync(IFunction<Long, Long> function) {
        ICompletableFuture future = this.alterAndGetAsync((IFunction)function);
        return future;
    }

    public InternalCompletableFuture<Long> alterAndGetAsync(IFunction<Long, Long> function) {
        Object f = this.getSerializationService().toData(function);
        ClientMessage request = CPAtomicLongAlterCodec.encodeRequest(this.groupId, this.objectName, f, AlterOp.AlterResultType.NEW_VALUE.value());
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Long>(future, this.getSerializationService(), ALTER_DECODER);
    }

    public InternalCompletableFuture<Long> getAndAlterAsync(IFunction<Long, Long> function) {
        Object f = this.getSerializationService().toData(function);
        ClientMessage request = CPAtomicLongAlterCodec.encodeRequest(this.groupId, this.objectName, f, AlterOp.AlterResultType.OLD_VALUE.value());
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Long>(future, this.getSerializationService(), ALTER_DECODER);
    }

    public <R> InternalCompletableFuture<R> applyAsync(IFunction<Long, R> function) {
        Object f = this.getSerializationService().toData(function);
        ClientMessage request = CPAtomicLongApplyCodec.encodeRequest(this.groupId, this.objectName, f);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture(future, this.getSerializationService(), APPLY_DECODER);
    }

    @Override
    public String getPartitionKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onDestroy() {
        ClientMessage request = CPGroupDestroyCPObjectCodec.encodeRequest(this.groupId, this.getServiceName(), this.objectName);
        new ClientInvocation(this.getClient(), request, this.name).invoke().join();
    }

    public CPGroupId getGroupId() {
        return this.groupId;
    }
}

