/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.Config;
import com.hazelcast.config.YamlConfigBuilder;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.InputStream;
import java.util.Properties;

public class ClasspathYamlConfig
extends Config {
    private static final ILogger LOGGER = Logger.getLogger(ClasspathYamlConfig.class);

    public ClasspathYamlConfig(String resource) {
        this(resource, System.getProperties());
    }

    public ClasspathYamlConfig(String resource, Properties properties) {
        this(Thread.currentThread().getContextClassLoader(), resource, properties);
    }

    public ClasspathYamlConfig(ClassLoader classLoader, String resource) {
        this(classLoader, resource, System.getProperties());
    }

    public ClasspathYamlConfig(ClassLoader classLoader, String resource, Properties properties) {
        if (classLoader == null) {
            throw new IllegalArgumentException("classLoader can't be null");
        }
        if (resource == null) {
            throw new IllegalArgumentException("resource can't be null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties can't be null");
        }
        LOGGER.info("Configuring Hazelcast from '" + resource + "'.");
        InputStream in = classLoader.getResourceAsStream(resource);
        if (in == null) {
            throw new IllegalArgumentException("Specified resource '" + resource + "' could not be found!");
        }
        new YamlConfigBuilder(in).setProperties(properties).build(this);
    }
}

