/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.core;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.spi.annotation.Beta;
import com.hazelcast.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;

@Beta
public class Pipeline<E> {
    private static final Executor EXECUTOR = new Executor(){

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    };
    private final Semaphore semaphore;
    private final List<ICompletableFuture<E>> futures = new ArrayList<ICompletableFuture<E>>();

    public Pipeline(int depth) {
        Preconditions.checkPositive(depth, "depth must be positive");
        this.semaphore = new Semaphore(depth);
    }

    public List<E> results() throws Exception {
        ArrayList result = new ArrayList(this.futures.size());
        for (ICompletableFuture<E> f : this.futures) {
            result.add(f.get());
        }
        return result;
    }

    public ICompletableFuture<E> add(ICompletableFuture<E> future) throws InterruptedException {
        Preconditions.checkNotNull(future, "future can't be null");
        this.semaphore.acquire();
        this.futures.add(future);
        future.andThen(new ExecutionCallback<E>(){

            @Override
            public void onResponse(E response) {
                Pipeline.this.semaphore.release();
            }

            @Override
            public void onFailure(Throwable t) {
                Pipeline.this.semaphore.release();
            }
        }, EXECUTOR);
        return future;
    }
}

