/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.countdownlatch;

import com.hazelcast.cp.internal.datastructures.countdownlatch.RaftCountDownLatchDataSerializerHook;
import com.hazelcast.cp.internal.datastructures.spi.blocking.WaitKey;
import com.hazelcast.cp.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.util.Preconditions;
import java.io.IOException;
import java.util.UUID;

public class AwaitInvocationKey
implements WaitKey,
IdentifiedDataSerializable {
    private long commitIndex;
    private UUID invocationUid;

    AwaitInvocationKey() {
    }

    AwaitInvocationKey(long commitIndex, UUID invocationUid) {
        Preconditions.checkNotNull(invocationUid);
        this.commitIndex = commitIndex;
        this.invocationUid = invocationUid;
    }

    @Override
    public long sessionId() {
        return -1L;
    }

    @Override
    public long commitIndex() {
        return this.commitIndex;
    }

    @Override
    public UUID invocationUid() {
        return this.invocationUid;
    }

    @Override
    public int getFactoryId() {
        return RaftCountDownLatchDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 3;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.commitIndex);
        UUIDSerializationUtil.writeUUID(out, this.invocationUid);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.commitIndex = in.readLong();
        this.invocationUid = UUIDSerializationUtil.readUUID(in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwaitInvocationKey that = (AwaitInvocationKey)o;
        if (this.commitIndex != that.commitIndex) {
            return false;
        }
        return this.invocationUid.equals(that.invocationUid);
    }

    public int hashCode() {
        int result = (int)(this.commitIndex ^ this.commitIndex >>> 32);
        result = 31 * result + this.invocationUid.hashCode();
        return result;
    }

    public String toString() {
        return "AwaitInvocationKey{commitIndex=" + this.commitIndex + ", invocationUid=" + this.invocationUid + '}';
    }
}

