/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.lock;

import com.hazelcast.cp.internal.datastructures.lock.LockEndpoint;
import com.hazelcast.cp.internal.datastructures.lock.RaftLockDataSerializerHook;
import com.hazelcast.cp.internal.datastructures.spi.blocking.WaitKey;
import com.hazelcast.cp.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.util.Preconditions;
import java.io.IOException;
import java.util.UUID;

public class LockInvocationKey
implements WaitKey,
IdentifiedDataSerializable {
    private LockEndpoint endpoint;
    private long commitIndex;
    private UUID invocationUid;

    public LockInvocationKey() {
    }

    LockInvocationKey(LockEndpoint endpoint, long commitIndex, UUID invocationUid) {
        Preconditions.checkNotNull(endpoint);
        Preconditions.checkNotNull(invocationUid);
        this.endpoint = endpoint;
        this.commitIndex = commitIndex;
        this.invocationUid = invocationUid;
    }

    @Override
    public long commitIndex() {
        return this.commitIndex;
    }

    @Override
    public long sessionId() {
        return this.endpoint.sessionId();
    }

    @Override
    public UUID invocationUid() {
        return this.invocationUid;
    }

    LockEndpoint endpoint() {
        return this.endpoint;
    }

    boolean isDifferentInvocationOf(LockEndpoint endpoint, UUID invocationUid) {
        return this.endpoint().equals(endpoint) && !this.invocationUid().equals(invocationUid);
    }

    @Override
    public int getFactoryId() {
        return RaftLockDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 4;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.endpoint);
        out.writeLong(this.commitIndex);
        UUIDSerializationUtil.writeUUID(out, this.invocationUid);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.endpoint = (LockEndpoint)in.readObject();
        this.commitIndex = in.readLong();
        this.invocationUid = UUIDSerializationUtil.readUUID(in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LockInvocationKey that = (LockInvocationKey)o;
        if (this.commitIndex != that.commitIndex) {
            return false;
        }
        if (!this.endpoint.equals(that.endpoint)) {
            return false;
        }
        return this.invocationUid.equals(that.invocationUid);
    }

    public int hashCode() {
        int result = this.endpoint.hashCode();
        result = 31 * result + (int)(this.commitIndex ^ this.commitIndex >>> 32);
        result = 31 * result + this.invocationUid.hashCode();
        return result;
    }

    public String toString() {
        return "LockInvocationKey{endpoint=" + this.endpoint + ", commitIndex=" + this.commitIndex + ", invocationUid=" + this.invocationUid + '}';
    }
}

