/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.semaphore;

import com.hazelcast.cp.internal.datastructures.semaphore.RaftSemaphoreDataSerializerHook;
import com.hazelcast.cp.internal.datastructures.semaphore.SemaphoreEndpoint;
import com.hazelcast.cp.internal.datastructures.spi.blocking.WaitKey;
import com.hazelcast.cp.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.util.Preconditions;
import java.io.IOException;
import java.util.UUID;

public class AcquireInvocationKey
implements WaitKey,
IdentifiedDataSerializable {
    private long commitIndex;
    private SemaphoreEndpoint endpoint;
    private UUID invocationUid;
    private int permits;

    AcquireInvocationKey() {
    }

    AcquireInvocationKey(long commitIndex, SemaphoreEndpoint endpoint, UUID invocationUid, int permits) {
        Preconditions.checkNotNull(endpoint);
        Preconditions.checkNotNull(invocationUid);
        Preconditions.checkTrue(permits > 0, "permits must be positive");
        this.commitIndex = commitIndex;
        this.endpoint = endpoint;
        this.invocationUid = invocationUid;
        this.permits = permits;
    }

    @Override
    public long commitIndex() {
        return this.commitIndex;
    }

    @Override
    public long sessionId() {
        return this.endpoint.sessionId();
    }

    @Override
    public UUID invocationUid() {
        return this.invocationUid;
    }

    public SemaphoreEndpoint endpoint() {
        return this.endpoint;
    }

    public int permits() {
        return this.permits;
    }

    boolean isDifferentInvocationOf(SemaphoreEndpoint endpoint, UUID invocationUid) {
        return this.endpoint().equals(endpoint) && !this.invocationUid().equals(invocationUid);
    }

    @Override
    public int getFactoryId() {
        return RaftSemaphoreDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 3;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.commitIndex);
        out.writeObject(this.endpoint);
        UUIDSerializationUtil.writeUUID(out, this.invocationUid);
        out.writeInt(this.permits);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.commitIndex = in.readLong();
        this.endpoint = (SemaphoreEndpoint)in.readObject();
        this.invocationUid = UUIDSerializationUtil.readUUID(in);
        this.permits = in.readInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcquireInvocationKey that = (AcquireInvocationKey)o;
        if (this.commitIndex != that.commitIndex) {
            return false;
        }
        if (this.permits != that.permits) {
            return false;
        }
        if (!this.endpoint.equals(that.endpoint)) {
            return false;
        }
        return this.invocationUid.equals(that.invocationUid);
    }

    public int hashCode() {
        int result = (int)(this.commitIndex ^ this.commitIndex >>> 32);
        result = 31 * result + this.endpoint.hashCode();
        result = 31 * result + this.invocationUid.hashCode();
        result = 31 * result + this.permits;
        return result;
    }

    public String toString() {
        return "SemaphoreInvocationKey{commitIndex=" + this.commitIndex + ", endpoint=" + this.endpoint + ", invocationUid=" + this.invocationUid + ", permits=" + this.permits + '}';
    }
}

